/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.nps.serviceProviders.DirLanguage;
import com.novell.nps.sessionManager.PortalSession;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;

public class NetwareLang
implements DirLanguage {
    public Locale[] convertDirLangsToISOLocales(String dirLangs, PortalSession session) {
        Vector newLocales = NetwareLang.convertNWDirLangsToISOLocales(dirLangs);
        return NetwareLang.vectorToLocales(newLocales);
    }

    private static String convertNWtoISO(String currentLang) {
        if (currentLang.equalsIgnoreCase("ENGLISH")) {
            return "en";
        }
        if (currentLang.equalsIgnoreCase("DEUTSCH")) {
            return "de";
        }
        if (currentLang.equalsIgnoreCase("ESPANOL")) {
            return "es";
        }
        if (currentLang.equalsIgnoreCase("FRANCAIS")) {
            return "fr";
        }
        if (currentLang.equalsIgnoreCase("ITALIANO")) {
            return "it";
        }
        if (currentLang.equalsIgnoreCase("NIHONGO")) {
            return "ja";
        }
        if (currentLang.equalsIgnoreCase("DANSK")) {
            return "da";
        }
        if (currentLang.equalsIgnoreCase("NEDERLAN")) {
            return "nl";
        }
        if (currentLang.equalsIgnoreCase("CHINESES")) {
            return "zh";
        }
        if (currentLang.equalsIgnoreCase("CHINESET")) {
            return "zh";
        }
        if (currentLang.equalsIgnoreCase("SUOMI")) {
            return "fi";
        }
        if (currentLang.equalsIgnoreCase("HANGUL")) {
            return "ko";
        }
        if (currentLang.equalsIgnoreCase("NORSK")) {
            return "no";
        }
        if (currentLang.equalsIgnoreCase("PORTUGUE")) {
            return "pt";
        }
        if (currentLang.equalsIgnoreCase("RUSSKI")) {
            return "ru";
        }
        if (currentLang.equalsIgnoreCase("SVENSKA")) {
            return "sv";
        }
        if (currentLang.length() == 2 && Arrays.asList(Locale.getISOLanguages()).contains(currentLang)) {
            return currentLang;
        }
        if (currentLang.length() == 5 && Arrays.asList(Locale.getISOLanguages()).contains(currentLang.substring(0, 2)) && Arrays.asList(Locale.getISOCountries()).contains(currentLang.substring(3))) {
            return currentLang;
        }
        return null;
    }

    private static Vector convertNWDirLangsToISOLocales(String dirLangs) {
        Vector<Locale> localeVec = new Vector<Locale>();
        while (dirLangs != null) {
            String currentLang = null;
            int index = dirLangs.indexOf("$");
            if (index != -1) {
                currentLang = dirLangs.substring(0, index);
                dirLangs = dirLangs.substring(index + 1);
            } else {
                currentLang = dirLangs;
                dirLangs = null;
            }
            String isoLang = NetwareLang.convertNWtoISO(currentLang);
            Object newLang = null;
            if (isoLang == null) continue;
            Locale newLocale = NetwareLang.convertISOStringToLocale(isoLang);
            localeVec.add(newLocale);
        }
        return localeVec;
    }

    static Locale convertISOStringToLocale(String isoLocale) {
        String language = null;
        String country = null;
        int index = isoLocale.indexOf("_");
        if (index != -1) {
            language = isoLocale.substring(0, index);
            country = isoLocale.substring(index + 1);
        } else {
            language = isoLocale;
            country = "";
        }
        return new Locale(language, country);
    }

    private static Locale[] vectorToLocales(Vector localeVec) {
        Locale[] isoLocales = new Locale[localeVec.size()];
        for (int i = 0; i < localeVec.size(); ++i) {
            isoLocales[i] = (Locale)localeVec.get(i);
        }
        return isoLocales;
    }
}

