/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.serviceProviders.ServiceProvider;
import com.novell.nps.sessionManager.PortalSession;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServiceManager {
    private static Hashtable serviceProviders = new Hashtable();
    private static Hashtable serviceProvidersConfig = new Hashtable();
    private static Hashtable availableServices = new Hashtable();
    private static Hashtable defaultServicesProvidedByProvider = new Hashtable();
    public static final String DEFAULT_DIRECTORY_PROVIDER = "System.DefaultDirectoryProvider";
    public static final String SESSION_DIRECTORY_PROVIDER = "System.SessionDirectoryProvider";

    public static void init() {
        String[] serviceProviderClasses = ConfigManager.getSetting("ServiceProviders");
        if (serviceProviderClasses != null) {
            for (int i = 0; i < serviceProviderClasses.length; ++i) {
                String[] services = ConfigManager.getSetting(serviceProviderClasses[i]);
                serviceProvidersConfig.put(serviceProviderClasses[i], services);
                Vector<String> defaultServicesProvided = new Vector<String>();
                for (int j = 0; j < services.length; ++j) {
                    String defaultSPName;
                    if (availableServices.containsKey(services[j]) || !(defaultSPName = ConfigManager.getSingleSetting(services[j])).equals(serviceProviderClasses[i])) continue;
                    availableServices.put(services[j], serviceProviderClasses[i]);
                    defaultServicesProvided.addElement(services[j]);
                }
                defaultServicesProvidedByProvider.put(serviceProviderClasses[i], defaultServicesProvided);
            }
        }
    }

    static ServiceProvider createAndAssignServiceProviderInstance(PortalSession session, String spClassName) {
        ServiceProvider sp = null;
        try {
            Class<?> spClass = Class.forName(spClassName);
            sp = (ServiceProvider)spClass.newInstance();
            sp.init(session);
            session.setAttribute("ServiceProvider." + spClassName, sp);
            Vector defaultServicesProvided = (Vector)defaultServicesProvidedByProvider.get(spClassName);
            for (int i = 0; i < defaultServicesProvided.size(); ++i) {
                String nameOfServiceDefaultingToProvider = (String)defaultServicesProvided.elementAt(i);
                session.setAttribute("Service." + nameOfServiceDefaultingToProvider, sp);
            }
        }
        catch (Exception e) {
            Debug.log("Servicemanager", 1, e);
        }
        return sp;
    }

    public static ServiceProvider getServiceProvider(String serviceName, PortalSession session) {
        ServiceProvider sp = (ServiceProvider)session.getAttribute("Service." + serviceName);
        if (null == sp) {
            String spClassName = (String)availableServices.get(serviceName);
            sp = ServiceManager.createAndAssignServiceProviderInstance(session, spClassName);
        }
        return sp;
    }

    public static ServiceProvider getSpecificServiceProvider(String serviceProviderName, PortalSession session) {
        ServiceProvider sp = (ServiceProvider)session.getAttribute("ServiceProvider." + serviceProviderName);
        if (null == sp) {
            sp = ServiceManager.createAndAssignServiceProviderInstance(session, serviceProviderName);
        }
        return sp;
    }

    public static Enumeration getProviders(PortalSession session) {
        return serviceProviders.elements();
    }
}

