/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ShellCommand {
    public Process p;
    public OutputStreamWriter stdin;
    public BufferedReader stdout;
    public BufferedReader stderr;

    public ShellCommand(String cmd) throws IOException {
        this.p = Runtime.getRuntime().exec(cmd);
        if (System.getProperty("os.name").startsWith("Linux")) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stdin = new OutputStreamWriter(this.p.getOutputStream());
        this.stdout = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        this.stderr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
    }

    public void waitFor() {
        try {
            this.stdin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int exitValue() {
        try {
            return this.p.exitValue();
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void eatOutput() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    int c;
                    while ((c = ShellCommand.this.stdout.read()) >= 0) {
                        System.out.write(c);
                    }
                }
                catch (IOException ex) {
                    System.out.println("IOException caught");
                }
            }
        };
        thread.start();
    }

    public void feedInput(String text) {
        System.out.println("input to ShellCommand: " + text);
        try {
            if (text == null) {
                this.stdin.close();
            } else {
                this.stdin.write(text + "\n");
            }
        }
        catch (IOException ex) {
            System.out.println("IOException caught");
        }
    }

    public void eatErrorOutput() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    int c;
                    while ((c = ShellCommand.this.stderr.read()) >= 0) {
                        System.err.write(c);
                    }
                }
                catch (IOException ex) {
                    System.out.println("IOException caught");
                }
            }
        };
        thread.start();
    }
}

