/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.sessionManager;

import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.fw.DeprecatedAttrs;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.servlet.FwSession;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.LogoutException;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.sessionManager.DefaultPortalRequest;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.nps.sessionManager.PortalSessionTimeoutEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;

public class DefaultPortalSession
implements FwSession,
Serializable {
    public static final String DEVICES_SETTING = "Devices";
    public static final String SPECIAL_STYLESHEET_DEVICES_SETTING = "SpecialStylesheetDevices";
    public static final String SINGLE_GADGET_DEVICES_SETTING = "SingleGadgetDevices";
    private static final String DT = "DefaultPortalSession";
    private static final String PUBLIC_CONNECTION = "AuthenticationManager.PublicConnection";
    private transient HttpSession m_session;

    public DefaultPortalSession(HttpSession httpSession) {
        if (httpSession != null) {
            this.m_session = httpSession;
        }
        FwUtils.savePortalSession((HttpSession)httpSession, (HttpSession)this);
        if (httpSession.getAttribute("USERDN") == null) {
            AuthenticationManager.setUserDNAndCN((PortalSession)((Object)this), "");
        }
    }

    public void updateTheSession(HttpSession httpSession) {
        this.m_session = httpSession;
    }

    public String getUserName() {
        return this.getUserDN();
    }

    public String getUserDN() {
        String sRet = null;
        try {
            sRet = DirAuthenticator.getDirAuth((HttpServletRequest)FwUtils.getRequest((HttpSession)this)).getAuthenticationBroker().getAuthLdapName();
        }
        catch (AuthBrokerException e) {
            D.log((Throwable)e);
        }
        return sRet;
    }

    public String getUserCN() {
        return DirUtils.getLeftMostName((String)this.getUserDN());
    }

    public boolean isXSLSupported() {
        return false;
    }

    public void setXSLSupported(boolean xslSupported) {
    }

    public boolean testXSLSupport() {
        return false;
    }

    public void clearTestXSLSupport() {
    }

    public synchronized void setGlobalRenderOverride(boolean render) {
    }

    public synchronized void setUseGlobalRenderOverride(boolean useOverride) {
    }

    public Object getAttribute(String par1) {
        return this.getAttribute(par1, true);
    }

    public Object getAttribute(String par1, boolean checkDeprecated) {
        Object value = this.m_session.getAttribute(par1);
        if (value == null && checkDeprecated) {
            value = DeprecatedAttrs.get((String)par1, (String)"Session", (HttpServletRequest)FwUtils.getRequest((HttpSession)this));
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        return this.m_session.getAttributeNames();
    }

    public void putValue(String par1, Object par2) {
        this.setAttribute(par1, par2);
    }

    public void removeAttribute(String name) {
        this.m_session.removeAttribute(name);
    }

    public void removeValue(String par1) {
        this.removeAttribute(par1);
    }

    public void setAttribute(String name, Object value) {
        this.m_session.setAttribute(name, value);
    }

    public long getCreationTime() {
        return this.m_session.getCreationTime();
    }

    public String getId() {
        return this.m_session.getId();
    }

    public String getCurrentBrowser() {
        return FwUtils.getBrowserId((HttpSession)this.m_session);
    }

    public void setDeviceType(String userAgent) {
        FwUtils.setDeviceType((HttpSession)this.m_session);
    }

    public String getDeviceType() {
        return FwUtils.getDeviceType((HttpSession)this.m_session);
    }

    public String getContentType() {
        return FwUtils.getContentType((HttpSession)this.m_session);
    }

    public void setContentType() {
    }

    public boolean isSpecialStylesheetDevice() {
        return false;
    }

    static void setSingleGadgetDevices() {
    }

    public boolean isSingleGadgetDevice() {
        return FwUtils.isSingleGadgetDevice((HttpSession)this.m_session);
    }

    public Locale getCurrentLocale() {
        return FwUtils.getCurrentLocale((HttpSession)this.m_session);
    }

    public String getLocaleString() {
        return FwUtils.getLocaleString((HttpSession)this.m_session);
    }

    public Locale[] getAllLocales() {
        return FwUtils.getLocales((HttpSession)this.m_session);
    }

    public Locale[] getLocales() {
        return FwUtils.getLocales((HttpSession)this.m_session);
    }

    public long getLastAccessedTime() {
        return this.m_session.getLastAccessedTime();
    }

    public void updateLastAccessedTime() {
    }

    public int getMaxInactiveInterval() {
        return this.m_session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String par1) {
        return this.getAttribute(par1);
    }

    public String[] getValueNames() {
        return this.m_session.getValueNames();
    }

    public void invalidate() {
        this.m_session.invalidate();
    }

    public boolean isNew() {
        return this.m_session.isNew();
    }

    public void setMaxInactiveInterval(int par1) {
        this.m_session.setMaxInactiveInterval(par1);
    }

    public void updateMaxInactiveInterval() {
    }

    public Date getLoginTime() {
        return FwUtils.getLoginTime((HttpSession)this.m_session);
    }

    public void setLoginTime(Date date) {
        FwUtils.setLoginTime((HttpSession)this.m_session, (Date)date);
    }

    public void clearLoginTime() {
        FwUtils.clearLoginTime((HttpSession)this.m_session);
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        PortalEventManager.postEvent(new PortalSessionTimeoutEvent((PortalSession)((Object)this)));
        D.log((String)"Session Timed out");
        DefaultPortalRequest.removeCachedSession((PortalSession)((Object)this));
        try {
            AuthenticationManager.portalLogout((PortalSession)((Object)this));
        }
        catch (LogoutException e) {
            D.log((Throwable)e);
        }
        PortalConnection publicConnection = (PortalConnection)this.getAttribute(PUBLIC_CONNECTION);
        if (publicConnection != null) {
            try {
                publicConnection.logout();
            }
            catch (Exception ex) {
                D.log((Throwable)ex, (int)2, (int)3);
            }
        }
    }

    public void setSkin(String skinName) {
        FwUtils.setSkin((HttpSession)this.m_session, (String)skinName);
    }

    public String getSkin() {
        return FwUtils.getSkin((HttpSession)this.m_session);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.m_session.removeAttribute("fw_SessionTaskInstances");
        this.m_session.removeAttribute("System.MainPageGadgetInstance");
        this.m_session.removeAttribute("SESSION_COOKIES");
        s.defaultWriteObject();
    }

    public ServletContext getServletContext() {
        return this.m_session.getServletContext();
    }

    public HttpSession getRealSession() {
        return this.m_session;
    }
}

