/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.snmp;

import Snmp2.SnmpAPI;
import Snmp2.SnmpClient;
import Snmp2.SnmpException;
import Snmp2.SnmpNull;
import Snmp2.SnmpOID;
import Snmp2.SnmpPDU;
import Snmp2.SnmpSession;
import Snmp2.SnmpTimeticks;
import Snmp2.SnmpVar;
import Snmp2.SnmpVarBind;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.debug.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class PortalSnmpAgent
extends Thread
implements SnmpClient {
    private static final String DT = "PortalSnmpAgent";
    private SnmpAPI m_api;
    private SnmpSession m_session;
    private SnmpPDU m_trap;
    private int m_snmpVersion;
    private String enterpriseOID;
    private Vector varBindList = new Vector();
    private String m_target;
    private String m_community;
    private static String s_target = "Localhost";
    private static int s_port = 162;

    public PortalSnmpAgent(String target, int port, String community) throws SnmpException, UnknownHostException {
        this.m_api = new SnmpAPI();
        this.m_api.start();
        this.m_target = target;
        this.m_community = community;
        this.m_session = new SnmpSession(this.m_api);
        this.m_session.version = SnmpAPI.SNMP_VERSION_1;
        this.m_session.client = this;
        this.m_session.peername = target;
        this.m_session.remote_port = port;
        this.m_session.community = community;
        this.m_session.retries = 2;
        this.m_session.timeout = 5000;
        this.enterpriseOID = ".1.3.6.1.4.1.23.2.97";
    }

    public PortalSnmpAgent() throws SnmpException, UnknownHostException {
        this(s_target, s_port, "public");
    }

    public PortalSnmpAgent(int port) throws SnmpException, UnknownHostException {
        this("Localhost", port, "public");
    }

    public PortalSnmpAgent(int port, String target) throws SnmpException, UnknownHostException {
        this(target, port, "public");
    }

    public PortalSnmpAgent(String target) throws SnmpException, UnknownHostException {
        this(target, s_port, "public");
    }

    public SnmpVarBind addVarBind(String oid) {
        return this.addVarBind(oid, null);
    }

    public SnmpVarBind addVarBind(String oid, SnmpVar val) {
        SnmpVarBind vb = new SnmpVarBind();
        vb.oid = new SnmpOID(oid);
        vb.variable = val != null ? val : new SnmpNull();
        this.varBindList.addElement(vb);
        return vb;
    }

    public SnmpVarBind insertVarBindElementAt(String oid, SnmpVar val, int index) {
        SnmpVarBind vb = new SnmpVarBind();
        vb.oid = new SnmpOID(oid);
        vb.variable = val != null ? val : new SnmpNull();
        this.varBindList.insertElementAt(vb, index);
        return vb;
    }

    public SnmpVarBind addVarBind(String oid, SnmpVar val, Vector vblist) {
        SnmpVarBind vb = new SnmpVarBind();
        vb.oid = new SnmpOID(oid);
        vb.variable = val != null ? val : new SnmpNull();
        vblist.addElement(vb);
        return vb;
    }

    public SnmpVarBind insertVarBindElementAt(String oid, SnmpVar val, Vector vblist, int index) {
        SnmpVarBind vb = new SnmpVarBind();
        vb.oid = new SnmpOID(oid);
        vb.variable = val != null ? val : new SnmpNull();
        vblist.insertElementAt(vb, index);
        return vb;
    }

    public void clearVarBindList() {
        this.varBindList.removeAllElements();
    }

    public void sendV1Trap(String target, String community, int genericType, int specificType, Vector varBindList) {
        try {
            this.m_session.open();
            this.m_session.peername = target;
            this.m_session.community = community;
            this.m_trap = new SnmpPDU(this.m_api);
            this.m_trap.reqid = 0;
            this.m_trap.time = FwUtils.getAppUpTime() / 10L;
            this.m_trap.community = community;
            this.m_trap.agent_addr = InetAddress.getLocalHost();
            this.m_trap.trap_type = genericType;
            this.m_trap.specific_type = specificType;
            this.m_trap.command = (byte)-92;
            this.m_trap.enterprise = new SnmpOID(this.enterpriseOID);
            if (varBindList == null) {
                varBindList = new Vector();
            }
            this.m_trap.variables = (Vector)varBindList.clone();
            this.m_session.send(this.m_trap);
            this.m_session.close();
        }
        catch (SnmpException x) {
            Debug.log(DT, 1, (Exception)((Object)x));
        }
        catch (UnknownHostException x) {
            Debug.log(DT, 1, x);
        }
    }

    public void sendV1Trap(String target, String community, String enterpriseOid, int genericType, int specificType, Vector varBindList) {
        try {
            this.m_session.open();
            this.m_session.peername = target;
            this.m_session.community = community;
            this.m_trap = new SnmpPDU(this.m_api);
            this.m_trap.reqid = 0;
            this.m_trap.time = FwUtils.getAppUpTime() / 10L;
            this.m_trap.community = community;
            this.m_trap.agent_addr = InetAddress.getLocalHost();
            this.m_trap.trap_type = genericType;
            this.m_trap.specific_type = specificType;
            this.m_trap.command = (byte)-92;
            this.m_trap.enterprise = new SnmpOID(enterpriseOid);
            if (varBindList == null) {
                varBindList = new Vector();
            }
            this.m_trap.variables = (Vector)varBindList.clone();
            this.m_session.send(this.m_trap);
            this.m_session.close();
        }
        catch (SnmpException x) {
            Debug.log(DT, 1, (Exception)((Object)x));
        }
        catch (UnknownHostException e) {
            Debug.log(DT, 1, e);
        }
    }

    public void sendV1Trap(int genericType, int specificType, Vector varBindList) {
        try {
            this.m_session.open();
            this.m_trap = new SnmpPDU(this.m_api);
            this.m_trap.reqid = 0;
            this.m_trap.time = FwUtils.getAppUpTime() / 10L;
            this.m_trap.community = this.m_community;
            this.m_trap.agent_addr = InetAddress.getLocalHost();
            this.m_trap.trap_type = genericType;
            this.m_trap.specific_type = specificType;
            this.m_trap.command = (byte)-92;
            this.m_trap.enterprise = new SnmpOID(this.enterpriseOID);
            if (varBindList == null) {
                varBindList = new Vector();
            }
            this.m_trap.variables = (Vector)varBindList.clone();
            this.m_session.send(this.m_trap);
            this.m_session.close();
        }
        catch (SnmpException x) {
            Debug.log(DT, 1, (Exception)((Object)x));
        }
        catch (UnknownHostException e) {
            Debug.log(DT, 1, e);
        }
    }

    public void sendV1Trap(int genericType, int specificType) {
        this.sendV1Trap(genericType, specificType, this.varBindList);
    }

    public void sendV1Trap(int specificType, Vector vector) {
        this.sendV1Trap(6, specificType, vector);
    }

    public void sendV1Trap(int specificType) {
        this.sendV1Trap(6, specificType, this.varBindList);
    }

    public void sendV1Trap(int specificType, String enterpriseOid) {
        this.sendV1Trap(this.m_target, this.m_community, enterpriseOid, 6, specificType, this.varBindList);
    }

    public void sendV2Trap(String target, String community, SnmpOID snmpoid, Vector varBindList) {
        try {
            this.m_session.open();
            this.m_session.peername = target;
            this.m_session.community = community;
            this.m_session.version = SnmpAPI.SNMP_VERSION_2C;
            this.m_trap = new SnmpPDU(this.m_api);
            this.m_trap.reqid = 0;
            this.m_trap.time = FwUtils.getAppUpTime() / 10L;
            this.m_trap.community = community;
            this.m_trap.agent_addr = InetAddress.getLocalHost();
            this.m_trap.command = (byte)-89;
            SnmpTimeticks snmptimeticks = new SnmpTimeticks(this.m_trap.time);
            if (varBindList == null) {
                varBindList = new Vector();
            }
            this.insertVarBindElementAt(".1.3.6.1.6.3.1.1.4.1.0", (SnmpVar)snmpoid, varBindList, 0);
            this.insertVarBindElementAt(".1.3.6.1.2.1.1.3.0", (SnmpVar)snmptimeticks, varBindList, 0);
            this.m_trap.variables = (Vector)varBindList.clone();
            this.m_session.send(this.m_trap);
            this.m_session.close();
        }
        catch (SnmpException x) {
            Debug.log(DT, 1, (Exception)((Object)x));
        }
        catch (UnknownHostException e) {
            Debug.log(DT, 1, e);
        }
    }

    public void sendV2Trap(String target, String community, SnmpOID snmpoid) {
        this.sendV2Trap(this.m_target, community, snmpoid, this.varBindList);
    }

    public void sendV2Trap(SnmpOID snmpoid, Vector varBindList) {
        try {
            this.m_session.open();
            this.m_session.version = SnmpAPI.SNMP_VERSION_2C;
            this.m_trap = new SnmpPDU(this.m_api);
            this.m_trap.reqid = 0;
            this.m_trap.time = FwUtils.getAppUpTime() / 10L;
            this.m_trap.community = this.m_community;
            this.m_trap.agent_addr = InetAddress.getLocalHost();
            this.m_trap.command = (byte)-89;
            SnmpTimeticks snmptimeticks = new SnmpTimeticks(this.m_trap.time);
            if (varBindList == null) {
                varBindList = new Vector();
            }
            this.insertVarBindElementAt(".1.3.6.1.6.3.1.1.4.1.0", (SnmpVar)snmpoid, varBindList, 0);
            this.insertVarBindElementAt(".1.3.6.1.2.1.1.3.0", (SnmpVar)snmptimeticks, varBindList, 0);
            this.m_trap.variables = (Vector)varBindList.clone();
            this.m_session.send(this.m_trap);
            this.m_session.close();
        }
        catch (SnmpException x) {
            Debug.log(DT, 1, (Exception)((Object)x));
        }
        catch (UnknownHostException e) {
            Debug.log(DT, 1, e);
        }
    }

    public void sendV2Trap(SnmpOID snmpoid) {
        this.sendV2Trap(snmpoid, this.varBindList);
    }

    public synchronized boolean callback(SnmpSession session, SnmpPDU pdu, int requestId) {
        return true;
    }

    public boolean authenticate(SnmpPDU pdu, String community) {
        return true;
    }

    public void debugPrint(String debugOutput) {
        Debug.log(DT, 1, debugOutput);
    }

    public static void setTargetAddress(String targetAddress) {
        s_target = targetAddress;
    }

    public static void setTargetPort(int targetPort) {
        s_port = targetPort;
    }

    public static String getTargetAddress() {
        return s_target;
    }
}

