/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;

public class Log {
    public static final int LOG_NONE = 0;
    public static final int LOG_HIGH = 1;
    public static final int LOG_MED = 2;
    public static final int LOG_LOW = 3;
    private static final String[] LOG_STRINGS = new String[]{"LOG_NONE", "LOG_HIGH", "LOG_MED", "LOG_LOW"};
    public static final int LOG_DEBUG = -999;
    private static int m_iDebugLevel = 0;
    private static PrintStream m_printstreamDebugOut = System.err;

    public static void setLevel(String sLevel) {
        if (null != sLevel) {
            try {
                Log.setLevel(Integer.parseInt(sLevel));
            }
            catch (Exception e) {
                for (int i = 0; i < LOG_STRINGS.length; ++i) {
                    if (!LOG_STRINGS[i].equalsIgnoreCase(sLevel)) continue;
                    Log.setLevel(i);
                    break;
                }
            }
        }
    }

    public static void setLevel(int iLevel) {
        m_iDebugLevel = iLevel;
        Log.log("Logging", m_iDebugLevel, "Level set to: " + (m_iDebugLevel < LOG_STRINGS.length ? LOG_STRINGS[m_iDebugLevel] : Integer.toString(m_iDebugLevel)));
    }

    public static PrintStream getOutput() {
        return m_printstreamDebugOut;
    }

    public static void setOutput(PrintStream out) {
        m_printstreamDebugOut = out;
    }

    public static void setOutput(OutputStream outputStream) {
        Log.setOutput(new PrintStream(outputStream, true));
    }

    public static void setOutput(File fOut) throws FileNotFoundException {
        Log.setOutput(new FileOutputStream(fOut));
    }

    public static void setOutput(String sOut) throws FileNotFoundException {
        Log.setOutput(new File(sOut));
    }

    public static synchronized void log(String sTag, int iLevel, String sMessage, Throwable t) {
        if (iLevel <= m_iDebugLevel) {
            if (null == sTag) {
                sTag = "";
            }
            m_printstreamDebugOut.print("---(" + new Date().toString() + ") " + sTag + ": ");
            if (null != sMessage) {
                m_printstreamDebugOut.println(sMessage);
            } else {
                m_printstreamDebugOut.println();
            }
            if (null != t) {
                m_printstreamDebugOut.println(t.getLocalizedMessage());
                t.printStackTrace(m_printstreamDebugOut);
            }
        }
    }

    public static synchronized void log(String sTag, int iLevel, String sMessage) {
        Log.log(sTag, iLevel, sMessage, null);
    }

    public static synchronized void log(String sTag, int iLevel, Throwable t) {
        Log.log(sTag, iLevel, null, t);
    }
}

