/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public abstract class ISO8859Encoder
extends CharEncoder {
    public static final int MAP_SIZE = 96;
    private final char[] charMap = new char[96];
    private final byte[] byteMap = new byte[96];

    protected ISO8859Encoder(char[] cArray) {
        if (cArray.length != 96) {
            throw new IllegalArgumentException("ISO8859Encoder: Wrong table size");
        }
        this.initMap(cArray);
    }

    public int encodeChars(char[] cArray, int n, int n2, byte[] byArray, int n3) throws CharEncodingException, EncodingBufferFullException {
        int n4 = n3;
        int n5 = n + n2;
        int n6 = n;
        while (n6 < n5) {
            int n7 = cArray[n6] & 0xFFFF;
            if (n7 > 126) {
                int n8 = Arrays.binarySearch(this.charMap, (char)n7);
                if (n8 < 0) {
                    if (n7 >= 55296 && n7 < 56320 && n6 + 1 < n5) {
                        char c = cArray[++n6];
                        n7 = (n7 - 55296 << 10) + (c - 56320) + 65536;
                    }
                    throw new CharEncodingException(n7, n6, n4);
                }
                n7 = this.byteMap[n8] & 0xFF;
            }
            if (n4 >= byArray.length) {
                throw new EncodingBufferFullException(n4, n6);
            }
            byArray[n4++] = (byte)n7;
            ++n6;
        }
        return n4 - n3;
    }

    public int encodeChar(int n, byte[] byArray, int n2) throws CharEncodingException, EncodingBufferFullException {
        if (n > 126) {
            int n3;
            if (n > 65535 || (n3 = Arrays.binarySearch(this.charMap, (char)n)) < 0) {
                throw new CharEncodingException(n, 0, n2);
            }
            n = this.byteMap[n3] & 0xFF;
        }
        if (n2 >= byArray.length) {
            throw new EncodingBufferFullException(n2, 0);
        }
        byArray[n2] = (byte)n;
        return 1;
    }

    private void initMap(char[] cArray) {
        ArrayList<CharEntry> arrayList = new ArrayList<CharEntry>(96);
        int n = 0;
        while (n < 96) {
            arrayList.add(new CharEntry(cArray[n], (byte)(n + 160)));
            ++n;
        }
        Collections.sort(arrayList, new CharEntryComparator());
        n = 0;
        while (n < 96) {
            CharEntry charEntry = (CharEntry)arrayList.get(n);
            this.charMap[n] = charEntry.c;
            this.byteMap[n] = charEntry.b;
            ++n;
        }
    }

    private static class CharEntryComparator
    implements Comparator {
        private CharEntryComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((CharEntry)object).c - ((CharEntry)object2).c;
        }
    }

    private static class CharEntry {
        public final char c;
        public final byte b;

        public CharEntry(char c, byte by) {
            this.c = c;
            this.b = by;
        }
    }
}

