/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class UTF16Encoder
extends CharEncoder {
    public static final String NAME = "UTF-16";
    private boolean first = true;

    public void reset() {
        this.first = false;
    }

    public int encodeChar(int n, byte[] byArray, int n2) throws CharEncodingException, EncodingBufferFullException {
        int n3 = 0;
        if (this.first) {
            if (n2 + 2 <= byArray.length) {
                byArray[n2] = -1;
                byArray[n2 + 1] = -2;
                this.first = false;
                n3 += 2;
            }
            n2 += 2;
        }
        if (n < 65535) {
            if (n2 + 2 <= byArray.length) {
                byArray[n2] = (byte)(n & 0xFF);
                byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
                return n3 + 2;
            }
        } else if (n2 + 4 <= byArray.length) {
            int n4 = (n - 65536 >> 10) + 55296;
            int n5 = (n - 65536 & 0x3FF) + 56320;
            byArray[n2] = (byte)(n4 & 0xFF);
            byArray[n2 + 1] = (byte)(n4 >> 8 & 0xFF);
            byArray[n2 + 2] = (byte)(n5 & 0xFF);
            byArray[n2 + 3] = (byte)(n5 >> 8 & 0xFF);
            return n3 + 4;
        }
        throw new EncodingBufferFullException(n2, 0);
    }

    public String getEncoding() {
        return NAME;
    }
}

