/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.DocumentTypeImpl;
import com.novell.xml.util.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class DOMImplementationImpl
implements DOMImplementation {
    private static DOMImplementationImpl domImplementation = null;

    public boolean hasFeature(String string, String string2) {
        return DOMImplementationImpl.checkFeature(string, string2);
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (!XMLUtil.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        if (!XMLUtil.isQName(string)) {
            throw new DOMExceptionImpl(14, null);
        }
        return new DocumentTypeImpl(null, string, string2, string3, null);
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        DocumentImpl documentImpl = DocumentImpl.newDocument();
        if (documentType != null) {
            if (documentType instanceof DocumentTypeImpl) {
                documentImpl.setDocumentType((DocumentTypeImpl)documentType);
            } else {
                throw new DOMExceptionImpl(4, null);
            }
        }
        if (string2 != null) {
            documentImpl.appendChild(documentImpl.createElementNS(string, string2));
        }
        return documentImpl;
    }

    public static DOMImplementation getDOMImplementation() {
        if (domImplementation == null) {
            domImplementation = new DOMImplementationImpl();
        }
        return domImplementation;
    }

    protected static boolean checkFeature(String string, String string2) {
        if (!string.equalsIgnoreCase("XML") && !string.equalsIgnoreCase("Core")) {
            return false;
        }
        return string2 == null || string2.length() == 0 || string2.equals("1.0") || string2.equals("2.0");
    }

    private DOMImplementationImpl() {
    }
}

