/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.util.URIResolver;
import com.novell.xml.dom.DOMImplementationImpl;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.StylesheetAssociation;
import com.novell.xml.util.XMLUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public final class DOMUtil {
    public static void printDocument(Writer writer, Document document) throws IOException {
        DOMWriter dOMWriter = new DOMWriter(document, writer);
        dOMWriter.write();
        writer.flush();
    }

    public static void printDocumentWithFormat(Writer writer, Document document) throws IOException {
        DOMWriter dOMWriter = new DOMWriter(document, writer);
        dOMWriter.setIndent(true);
        dOMWriter.write();
        writer.flush();
    }

    public static void printFragment(Writer writer, Node node) throws IOException {
        DOMWriter dOMWriter = new DOMWriter(node, writer);
        dOMWriter.write();
        writer.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void stripWhitespace(Node var0) {
        if (var0 == null) {
            return;
        }
        var1_1 = var0;
        var2_2 = true;
        var3_3 = var1_1;
        while (var3_3 != null) {
            if (var3_3.getNodeType() == 1 && (var4_4 = ((Element)var3_3).getAttribute("xml:space")).length() > 0) {
                var2_2 = var4_4.equals("preserve") == false;
                break;
            }
            var3_3 = var3_3.getParentNode();
        }
        var4_4 = new Stack<E>();
        while (var1_1 != null) {
            block13: {
                var5_5 = false;
                var6_6 = var1_1.getNodeType();
                if (var6_6 == 1) {
                    var4_4.push(var2_2 != false ? Boolean.TRUE : Boolean.FALSE);
                    var7_7 = ((Element)var1_1).getAttribute("xml:space");
                    if (var7_7.length() > 0) {
                        var2_2 = var7_7.equals("preserve") == false;
                    }
                } else if (var6_6 == 3) {
                    var7_7 = var1_1.getNextSibling();
                    while (var7_7 != null) {
                        if (var7_7.getNodeType() == 3) {
                            ((CharacterData)var1_1).appendData(var7_7.getNodeValue());
                            var1_1.getParentNode().removeChild((Node)var7_7);
                            var7_7 = var1_1.getNextSibling();
                            continue;
                        }
                        var7_7 = null;
                    }
                    var5_5 = var2_2 != false && XMLUtil.isXMLWhitespace(var1_1.getNodeValue()) != false;
                }
                var7_7 = var1_1;
                if (!var1_1.hasChildNodes()) ** GOTO lbl45
                var1_1 = var1_1.getFirstChild();
                break block13;
lbl-1000:
                // 1 sources

                {
                    if (var1_1.getNodeType() == 1) {
                        var2_2 = (Boolean)var4_4.pop();
                    }
                    if (var1_1.getNextSibling() != null) {
                        var1_1 = var1_1.getNextSibling();
                        break;
                    }
                    var1_1 = var1_1.getParentNode();
lbl45:
                    // 2 sources

                    ** while (var1_1 != null && var1_1 != var0)
                }
lbl46:
                // 2 sources

                v0 = var1_1 = var1_1 == var0 ? null : var1_1;
            }
            if (!var5_5) continue;
            var7_7.getParentNode().removeChild((Node)var7_7);
        }
    }

    public static String describeNode(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                return "/";
            }
            case 1: {
                String string = "<" + node.getNodeName() + ">";
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        string = string + " " + DOMUtil.describeNode(namedNodeMap.item(n));
                        ++n;
                    }
                }
                return string;
            }
            case 2: {
                return "@" + node.getNodeName() + " = \"" + node.getNodeValue() + "\"";
            }
            case 8: {
                return "<!--" + XMLUtil.escape(node.getNodeValue(), 50) + "-->";
            }
            case 7: {
                return "<?" + node.getNodeName() + " " + XMLUtil.escape(node.getNodeValue(), 50) + "?>";
            }
            case 3: 
            case 4: {
                return XMLUtil.quote(node.getNodeValue(), 50);
            }
        }
        return "?? node(" + node.getNodeType() + ")";
    }

    public static ExpandedQName getExpandedName(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getExpandedName();
        }
        short s = node.getNodeType();
        String string = node.getNodeName();
        if (s == 1 || s == 2 && !XMLUtil.isNamespaceDecl(string)) {
            return new ExpandedQName(string, node);
        }
        return new ExpandedQName("", string, "");
    }

    public static String getLocalName(Node node) {
        return XMLUtil.getLocalName(node.getNodeName());
    }

    public static NamespaceName getNamespaceName(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getExpandedName().getNamespaceName();
        }
        String string = XMLUtil.getPrefix(node.getNodeName());
        if (string.length() == 0 && node.getNodeType() == 2) {
            return NamespaceName.NULL_NAMESPACE;
        }
        return new NamespaceName(DOMUtil.getURIforNSPrefix(string, node));
    }

    public static String getURIforNSPrefix(String string, Node node) {
        if (string.equals("xml")) {
            return NamespaceName.XML_NAMESPACE.getString();
        }
        boolean bl = node instanceof NodeImpl;
        String string2 = string.length() == 0 ? "xmlns" : "xmlns:" + string;
        Node node2 = node;
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                Node node3;
                if (bl) {
                    node3 = ((ElementImpl)node2).getNamespaces().getNamedItem(string);
                    return node3 != null ? node3.getNodeValue() : null;
                }
                node3 = ((Element)node2).getAttributeNode(string2);
                if (node3 != null) {
                    return node3.getValue();
                }
            }
            node2 = node2.getParentNode();
        }
        return string2 == "xmlns" ? "" : null;
    }

    public static String getPrefixforNSURI(String string, Node node) {
        if (string.equals(NamespaceName.XML_NAMESPACE.getString())) {
            return "xml";
        }
        boolean bl = node instanceof NodeImpl;
        Node node2 = node;
        while (node2 != null) {
            String string2;
            Node node3;
            int n;
            NamedNodeMap namedNodeMap;
            if (node2.getNodeType() == 1 && bl) {
                namedNodeMap = ((ElementImpl)node2).getNamespaces();
                n = 0;
                while ((node3 = namedNodeMap.item(n)) != null) {
                    string2 = node3.getNodeName();
                    if (node3.getNodeValue().equals(string) && node3 == namedNodeMap.getNamedItem(string2)) {
                        return string2;
                    }
                    ++n;
                }
                return null;
            }
            namedNodeMap = ((Element)node2).getAttributes();
            n = 0;
            while ((node3 = namedNodeMap.item(n)) != null) {
                String string3;
                String string4;
                string2 = node3.getNodeName();
                if (XMLUtil.isNamespaceDecl(string2) && node3.getNodeValue().equals(string) && (string4 = DOMUtil.getURIforNSPrefix(string3 = XMLUtil.getPrefix(string2), node)) != null && string4.equals(string)) {
                    return string3;
                }
                ++n;
            }
            node2 = node2.getParentNode();
        }
        return null;
    }

    public static Element getElementByID(Document document, String string) {
        if (document == null || !(document instanceof DocumentImpl)) {
            return null;
        }
        return ((DocumentImpl)document).findElementById(string);
    }

    public static StylesheetAssociation[] getStylesheetAssociations(Document document, String string) {
        Object object;
        ArrayList<StylesheetAssociation> arrayList = new ArrayList<StylesheetAssociation>();
        Node node = document.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) break;
            if (node.getNodeType() == 7 && ((ProcessingInstruction)node).getTarget().equals("xml-stylesheet")) {
                object = (ProcessingInstruction)node;
                String string2 = object.getData();
                String string3 = XMLUtil.getPseudoAttribute(string2, "href");
                String string4 = XMLUtil.getPseudoAttribute(string2, "type");
                String string5 = XMLUtil.getPseudoAttribute(string2, "title");
                String string6 = XMLUtil.getPseudoAttribute(string2, "media");
                String string7 = XMLUtil.getPseudoAttribute(string2, "charset");
                boolean bl = XMLUtil.getPseudoAttribute(string2, "alternate").equals("yes");
                String string8 = null;
                if (string != null) {
                    string8 = string;
                } else if (document instanceof NodeImpl) {
                    string8 = ((NodeImpl)((Object)document)).getBaseURI();
                }
                string3 = URIResolver.resolveURI(string3, string8);
                arrayList.add(new StylesheetAssociation(string3, string4, string5, string6, string7, bl));
            }
            node = node.getNextSibling();
        }
        object = new StylesheetAssociation[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public static Document cloneDocument(Document document) throws DOMException {
        if (document != null) {
            Object object;
            DOMImplementation dOMImplementation = DOMImplementationImpl.getDOMImplementation();
            DocumentType documentType = document.getDoctype();
            DocumentType documentType2 = null;
            DocumentImpl documentImpl = null;
            if (documentType != null) {
                Node node;
                Object object2;
                documentType2 = dOMImplementation.createDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
                documentImpl = (DocumentImpl)dOMImplementation.createDocument(null, null, documentType2);
                documentImpl.setSmartNS(true);
                object = documentType.getNotations();
                NamedNodeMap namedNodeMap = documentType2.getNotations();
                int n = 0;
                while ((object2 = object.item(n)) != null) {
                    namedNodeMap.setNamedItem(documentImpl.importNode((Node)object2, true));
                    ++n;
                }
                object2 = documentType.getEntities();
                NamedNodeMap namedNodeMap2 = documentType2.getEntities();
                int n2 = 0;
                while ((node = object2.item(n2)) != null) {
                    namedNodeMap2.setNamedItem(documentImpl.importNode(node, true));
                    ++n2;
                }
            } else {
                documentImpl = (DocumentImpl)dOMImplementation.createDocument(null, null, null);
                documentImpl.setSmartNS(true);
            }
            object = document.getFirstChild();
            while (object != null) {
                if (object.getNodeType() != 10) {
                    documentImpl.appendChild(documentImpl.importNode((Node)object, true));
                }
                object = object.getNextSibling();
            }
            return documentImpl;
        }
        return null;
    }

    public static boolean checkNamespacesAgree(Node node) {
        try {
            Object object;
            Object object2;
            short s = node.getNodeType();
            if (s == 2 || s == 1) {
                NamespaceName namespaceName;
                object2 = node.getLocalName();
                if (object2 == null) {
                    return false;
                }
                if (!(s == 2 && XMLUtil.isNamespaceDecl(node.getNodeName()) || (namespaceName = DOMUtil.getNamespaceName(node)).equals((NamespaceName)(object = new NamespaceName(node.getNamespaceURI()))) || node.getNamespaceURI() == null && namespaceName.equals("#{Unknown}#"))) {
                    return false;
                }
            }
            switch (s) {
                case 1: {
                    object2 = node.getAttributes();
                    int n = 0;
                    while ((object = object2.item(n++)) != null) {
                        if (DOMUtil.checkNamespacesAgree((Node)object)) continue;
                        return false;
                    }
                }
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    object2 = node.getFirstChild();
                    while (object2 != null) {
                        if (!DOMUtil.checkNamespacesAgree((Node)object2)) {
                            return false;
                        }
                        object2 = object2.getNextSibling();
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean addNamespaceDecls(Node node) {
        Object object;
        NamespaceName namespaceName;
        Object object2;
        boolean bl = false;
        short s = node.getNodeType();
        if (!(s != 2 && s != 1 || (object2 = node.getNamespaceURI()) == null || s == 2 && XMLUtil.isNamespaceDecl(node.getNodeName()) || (namespaceName = DOMUtil.getNamespaceName(node)).equals((NamespaceName)(object = new NamespaceName(node.getNamespaceURI()))))) {
            Element element = s == 2 ? ((Attr)node).getOwnerElement() : (Element)node;
            String string = DOMUtil.getPrefixforNSURI((String)object2, element);
            if (string != null) {
                node.setPrefix(string.length() > 0 ? string : null);
            } else {
                String string2;
                String string3 = node.getPrefix();
                if (s == 2) {
                    string2 = string3;
                    int n = 1;
                    element = ((Attr)node).getOwnerElement();
                    while (element.getAttribute("xmlns:" + string3).length() > 0) {
                        string3 = string2 + '-' + String.valueOf(n);
                    }
                } else {
                    element = (Element)node;
                }
                string2 = "xmlns";
                if (string3 != null) {
                    string2 = string2 + ":" + string3;
                }
                element.setAttributeNS(NamespaceName.XMLNS_NAMESPACE.getString(), string2, (String)object2);
            }
            bl = true;
        }
        switch (s) {
            case 1: {
                object2 = node.getAttributes();
                int n = 0;
                while ((object = object2.item(n++)) != null) {
                    bl = DOMUtil.addNamespaceDecls((Node)object) | bl;
                }
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                object2 = node.getFirstChild();
                while (object2 != null) {
                    bl = DOMUtil.addNamespaceDecls((Node)object2) | bl;
                    object2 = object2.getNextSibling();
                }
                break;
            }
        }
        return bl;
    }

    public static boolean stringsEqual(String string, String string2) {
        return string == string2 || string != null && string2 != null && string.equals(string2);
    }

    private DOMUtil() {
    }
}

