/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.CDATASectionImpl;
import com.novell.xml.dom.CommentImpl;
import com.novell.xml.dom.DOMExceptionImpl;
import com.novell.xml.dom.DOMImplementationImpl;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFragmentImpl;
import com.novell.xml.dom.DocumentTypeImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.EntityImpl;
import com.novell.xml.dom.EntityReferenceImpl;
import com.novell.xml.dom.NamespaceImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.dom.NotationImpl;
import com.novell.xml.dom.ProcessingInstructionImpl;
import com.novell.xml.dom.TagNameNodeList;
import com.novell.xml.dom.TagNameNodeListNS;
import com.novell.xml.dom.TextImpl;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    private DocumentTypeImpl docType;
    private boolean locked = false;
    private Map idMap;
    private boolean doCheckNames = true;
    private int orderChangeCount = -1;
    private boolean smartNS = true;

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public DocumentType getDoctype() {
        return this.docType;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Element getDocumentElement() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) break;
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public Element createElement(String string) throws DOMException {
        this.checkName(string);
        return new ElementImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.checkNames()) {
            this.checkName(string);
            if ("XML".equalsIgnoreCase(string) || string2.indexOf("?>") != -1) {
                throw new DOMExceptionImpl(5, null);
            }
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Attr createAttribute(String string) throws DOMException {
        this.checkName(string);
        return new AttrImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        this.checkName(string);
        return new EntityReferenceImpl(this, string);
    }

    public NodeList getElementsByTagName(String string) {
        return new TagNameNodeList(this, string);
    }

    public void setDocumentType(DocumentTypeImpl documentTypeImpl) throws DOMException {
        if (documentTypeImpl.getOwnerDocument() != null) {
            throw new DOMExceptionImpl(4, null);
        }
        this.docType = documentTypeImpl;
        documentTypeImpl.setOwnerDocument(this);
    }

    public Notation createNotation(String string, String string2, String string3) {
        return new NotationImpl(this, string, string2, string3);
    }

    public Entity createEntity(String string, String string2, String string3, String string4) {
        return new EntityImpl(this, string, string2, string3, string4);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        NodeImpl nodeImpl = null;
        switch (node.getNodeType()) {
            case 1: {
                Node node2;
                Element element;
                Object object;
                boolean bl2 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Element element2 = (Element)node;
                if (!bl2 || element2.getLocalName() == null) {
                    if (this.smartNS) {
                        object = DOMUtil.getNamespaceName(node);
                        String string = NamespaceName.NULL_NAMESPACE.equals((NamespaceName)object) ? null : ((NamespaceName)object).getString();
                        element = this.createElementNS(string, element2.getTagName());
                    } else {
                        element = this.createElement(element2.getTagName());
                    }
                } else {
                    element = this.createElementNS(element2.getNamespaceURI(), element2.getTagName());
                }
                object = element2.getAttributes();
                int n = 0;
                while (n < object.getLength()) {
                    node2 = (Attr)object.item(n);
                    Attr attr = (Attr)this.importNode(node2, true);
                    if (attr.getLocalName() != null) {
                        element.setAttributeNodeNS(attr);
                    } else {
                        element.setAttributeNode(attr);
                    }
                    ++n;
                }
                if (bl) {
                    node2 = element2.getFirstChild();
                    while (node2 != null) {
                        element.appendChild(this.importNode(node2, bl));
                        node2 = node2.getNextSibling();
                    }
                }
                nodeImpl = (NodeImpl)((Object)element);
                break;
            }
            case 2: {
                Attr attr;
                Object object;
                boolean bl3 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Attr attr2 = (Attr)node;
                if (!bl3 || attr2.getLocalName() == null) {
                    if (this.smartNS) {
                        NamespaceName namespaceName;
                        object = XMLUtil.isNamespaceDecl(attr2.getNodeName()) ? NamespaceName.XMLNS_NAMESPACE.getString() : (NamespaceName.NULL_NAMESPACE.equals(namespaceName = DOMUtil.getNamespaceName(node)) ? null : namespaceName.getString());
                        attr = this.createAttributeNS((String)object, attr2.getNodeName());
                    } else {
                        attr = this.createAttribute(attr2.getNodeName());
                    }
                } else {
                    attr = this.createAttributeNS(attr2.getNamespaceURI(), attr2.getNodeName());
                }
                ((AttrImpl)attr).setSpecified(attr2.getSpecified());
                object = attr2.getFirstChild();
                while (object != null) {
                    attr.appendChild(this.importNode((Node)object, bl));
                    object = object.getNextSibling();
                }
                nodeImpl = (NodeImpl)((Object)attr);
                break;
            }
            case 3: {
                nodeImpl = (NodeImpl)((Object)this.createTextNode(((Text)node).getData()));
                break;
            }
            case 4: {
                nodeImpl = (NodeImpl)((Object)this.createCDATASection(((CDATASection)node).getData()));
                break;
            }
            case 5: {
                EntityReference entityReference = this.createEntityReference(node.getNodeName());
                nodeImpl = (NodeImpl)((Object)entityReference);
                break;
            }
            case 7: {
                nodeImpl = (NodeImpl)((Object)this.createProcessingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                nodeImpl = (NodeImpl)((Object)this.createComment(node.getNodeValue()));
                break;
            }
            case 11: {
                DocumentFragment documentFragment = this.createDocumentFragment();
                if (bl) {
                    Node node3 = node.getFirstChild();
                    while (node3 != null) {
                        documentFragment.appendChild(this.importNode(node3, bl));
                        node3 = node3.getNextSibling();
                    }
                }
                nodeImpl = (NodeImpl)((Object)documentFragment);
                break;
            }
            case 6: {
                Entity entity = (Entity)node;
                Entity entity2 = this.createEntity(entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                if (bl) {
                    ((NodeImpl)((Object)entity2)).setDeepReadOnly(false);
                    Node node4 = node.getFirstChild();
                    while (node4 != null) {
                        entity2.appendChild(this.importNode(node4, bl));
                        node4 = node4.getNextSibling();
                    }
                    ((NodeImpl)((Object)entity2)).setDeepReadOnly(true);
                }
                nodeImpl = (NodeImpl)((Object)entity2);
                break;
            }
            case 12: {
                Notation notation = (Notation)node;
                nodeImpl = (NodeImpl)((Object)this.createNotation(notation.getNodeName(), notation.getPublicId(), notation.getSystemId()));
                break;
            }
            default: {
                throw new DOMExceptionImpl(9, null);
            }
        }
        if (node instanceof NodeImpl) {
            NodeImpl nodeImpl2 = (NodeImpl)node;
            nodeImpl.setBaseURI(nodeImpl2.getBaseURI());
            nodeImpl.setLineNumber(nodeImpl2.getLineNumber());
            nodeImpl.setColumnNumber(nodeImpl2.getColumnNumber());
        }
        return nodeImpl;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        this.checkNameNS(string, string2, false);
        return new ElementImpl(this, string, string2);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        this.checkNameNS(string, string2, true);
        return new AttrImpl(this, string, string2);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new TagNameNodeListNS(this, string, string2);
    }

    public Element getElementById(String string) {
        return this.findElementById(string);
    }

    public NamespaceImpl createNamespaceNode(String string, String string2) {
        return new NamespaceImpl(this, string, string2);
    }

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setCheckNames(boolean bl) {
        this.doCheckNames = bl;
    }

    public void setSmartNS(boolean bl) {
        this.smartNS = bl;
    }

    public boolean getSmartNS() {
        return this.smartNS;
    }

    public boolean isOrderCurrent() {
        return this.orderChangeCount == this.changeCount;
    }

    public void setOrderCurrent(boolean bl) {
        this.orderChangeCount = bl ? this.changeCount : -1;
    }

    public void updateDocumentOrder() {
        if (this.orderChangeCount == this.changeCount) {
            return;
        }
        NodeImpl nodeImpl = this;
        int n = 0;
        block0: while (nodeImpl != null) {
            nodeImpl.setDocumentOrder(n++);
            if (nodeImpl.getNodeType() == 1) {
                n = ((ElementImpl)nodeImpl).updateDocumentOrder(n);
            }
            if (nodeImpl.hasChildNodes()) {
                nodeImpl = (NodeImpl)nodeImpl.getFirstChild();
                continue;
            }
            if (nodeImpl.getNextSibling() != null) {
                nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
                continue;
            }
            do {
                if ((nodeImpl = (NodeImpl)nodeImpl.getParentNode()) == null || nodeImpl.getNextSibling() == null) continue;
                nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
                continue block0;
            } while (nodeImpl != null);
        }
        this.setOrderCurrent(true);
    }

    public static DocumentImpl newDocument() {
        return new DocumentImpl();
    }

    public void addId(ElementImpl elementImpl, String string) {
        if (this.idMap == null) {
            this.idMap = new HashMap();
        } else if (this.idMap.containsKey(string)) {
            this.idMap.remove(string);
        }
        this.idMap.put(string, elementImpl);
        elementImpl.setMapped(true);
    }

    public void removeId(String string) {
        ElementImpl elementImpl;
        if (this.idMap != null && (elementImpl = (ElementImpl)this.idMap.remove(string)) != null) {
            elementImpl.setMapped(false);
        }
    }

    public ElementImpl findElementById(String string) {
        if (this.idMap != null) {
            return (ElementImpl)this.idMap.get(string);
        }
        return null;
    }

    protected DocumentImpl() {
        super(null, null, null);
        this.document = this;
    }

    protected boolean checkNames() {
        return this.doCheckNames;
    }

    public static String constructMessage(String string, Object[] objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.novell.xml.dom.DOMImpl_messages");
        try {
            string = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        return objectArray == null ? string : MessageFormat.format(string, objectArray);
    }
}

