/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.sax;

import com.novell.xml.dom.AttrImpl;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.DocumentTypeImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.sax.DocumentCommentHandler;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXtoDOM
implements DocumentCommentHandler,
DTDHandler {
    protected Document document;
    protected Node currentNode;
    protected int currentNodePosition;
    protected boolean novellDOM;
    protected boolean level2DOM;
    protected Locator locator = null;
    protected NamespaceStack namespaceStack;

    public SAXtoDOM(Document document) {
        this.document = document;
        this.novellDOM = document instanceof DocumentImpl;
        if (this.novellDOM) {
            ((DocumentImpl)document).setCheckNames(false);
        }
        this.level2DOM = document.getImplementation().hasFeature("XML", "2.0");
        if (this.level2DOM) {
            this.namespaceStack = new NamespaceStack();
        }
    }

    public Document getResult() {
        return this.document;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        Node node = this.document.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.document.removeChild(node);
            node = node2;
        }
        this.currentNode = this.document;
        if (this.novellDOM) {
            this.currentNodePosition = 0;
            this.setLocatorInfo((NodeImpl)((Object)this.document));
        }
    }

    public void endDocument() throws SAXException {
        Node node;
        Node node2 = this.document.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            if (node != null && node2.getNodeType() == 3 && node.getNodeType() == 3) {
                ((Text)node2).appendData(((Text)node).getData());
                this.document.removeChild(node);
                continue;
            }
            node2 = node;
        }
        if (this.novellDOM) {
            if (this.document.getDoctype() != null) {
                node = (DocumentTypeImpl)this.document.getDoctype();
                Element element = this.document.getDocumentElement();
                if (element != null) {
                    ((DocumentTypeImpl)node).setName(element.getTagName());
                }
            }
            ((DocumentImpl)this.document).setOrderCurrent(true);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Element element;
        String string2;
        Object object;
        Object object2;
        int n;
        if (this.level2DOM) {
            this.namespaceStack.push();
            n = 0;
            while (n < attributeList.getLength()) {
                object2 = attributeList.getName(n);
                if (XMLUtil.isNamespaceDecl((String)object2)) {
                    object = XMLUtil.getPrefix((String)object2);
                    string2 = ((String)object).length() > 0 ? XMLUtil.getLocalName((String)object2) : "";
                    this.namespaceStack.add(string2, new NamespaceName(attributeList.getValue(n)));
                }
                ++n;
            }
            element = XMLUtil.isQName(string) ? ((object = this.namespaceStack.getNamespaceName((String)(object2 = XMLUtil.getPrefix(string)))) == null || ((NamespaceName)object).equals(NamespaceName.NULL_NAMESPACE) ? (((String)object2).length() == 0 ? this.document.createElementNS(null, string) : this.document.createElement(string)) : this.document.createElementNS(((NamespaceName)object).getString(), string)) : this.document.createElement(string);
        } else {
            element = this.document.createElement(string);
        }
        this.currentNode.appendChild(element);
        if (this.novellDOM) {
            this.setLocatorInfo((NodeImpl)((Object)element));
        }
        n = 0;
        while (n < attributeList.getLength()) {
            object = attributeList.getName(n);
            if (this.level2DOM) {
                if (XMLUtil.isQName((String)object)) {
                    string2 = XMLUtil.getPrefix((String)object);
                    NamespaceName namespaceName = null;
                    if (XMLUtil.isNamespaceDecl((String)object)) {
                        namespaceName = NamespaceName.XMLNS_NAMESPACE;
                    } else if (string2.length() > 0) {
                        namespaceName = this.namespaceStack.getNamespaceName(string2);
                    }
                    if (namespaceName == null || namespaceName.equals(NamespaceName.NULL_NAMESPACE)) {
                        if (string2.length() == 0) {
                            object2 = this.document.createAttributeNS(null, (String)object);
                            element.setAttributeNodeNS((Attr)object2);
                        } else {
                            object2 = this.document.createAttribute((String)object);
                            element.setAttributeNode((Attr)object2);
                        }
                    } else {
                        object2 = this.document.createAttributeNS(namespaceName.getString(), (String)object);
                        element.setAttributeNodeNS((Attr)object2);
                    }
                } else {
                    object2 = this.document.createAttribute((String)object);
                    element.setAttributeNode((Attr)object2);
                }
            } else {
                object2 = this.document.createAttribute(attributeList.getName(n));
                element.setAttributeNode((Attr)object2);
            }
            object2.setValue(attributeList.getValue(n));
            if (this.novellDOM) {
                if (attributeList.getType(n).equals("ID")) {
                    ((AttrImpl)object2).setIdType(true);
                }
                this.setLocatorInfo((NodeImpl)object2);
            }
            ++n;
        }
        this.currentNode = element;
    }

    public void endElement(String string) throws SAXException {
        this.currentNode = this.currentNode.getParentNode();
        Node node = this.currentNode = this.currentNode == null ? this.document : this.currentNode;
        if (this.level2DOM) {
            this.namespaceStack.pop();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Text text = this.document.createTextNode(new String(cArray, n, n2));
        Node node = this.currentNode.getLastChild();
        if (node != null && node.getNodeType() == 3) {
            ((Text)node).appendData(text.getData());
            return;
        }
        this.currentNode.appendChild(text);
        if (this.novellDOM) {
            this.setLocatorInfo((NodeImpl)((Object)text));
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string == null || string.length() == 0) {
            this.comment(string2);
        } else {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
            this.currentNode.appendChild(processingInstruction);
            if (this.novellDOM) {
                this.setLocatorInfo((NodeImpl)((Object)processingInstruction));
            }
        }
    }

    public void comment(String string) throws SAXException {
        Comment comment = this.document.createComment(string);
        this.currentNode.appendChild(comment);
        if (this.novellDOM) {
            this.setLocatorInfo((NodeImpl)((Object)comment));
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.novellDOM) {
            DocumentType documentType = this.ensureDocType();
            NamedNodeMap namedNodeMap = documentType.getNotations();
            Notation notation = ((DocumentImpl)this.document).createNotation(string, string2, string3);
            namedNodeMap.setNamedItem(notation);
            this.setLocatorInfo((NodeImpl)((Object)notation));
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.novellDOM) {
            DocumentType documentType = this.ensureDocType();
            NamedNodeMap namedNodeMap = documentType.getEntities();
            Entity entity = ((DocumentImpl)this.document).createEntity(string, string2, string3, string4);
            namedNodeMap.setNamedItem(entity);
            this.setLocatorInfo((NodeImpl)((Object)entity));
        }
    }

    protected DocumentType ensureDocType() {
        DocumentType documentType = this.document.getDoctype();
        if (documentType == null) {
            documentType = this.document.getImplementation().createDocumentType("x", "x", "x");
            ((DocumentImpl)this.document).setDocumentType((DocumentTypeImpl)documentType);
        }
        return documentType;
    }

    protected void setLocatorInfo(NodeImpl nodeImpl) {
        if (this.locator != null) {
            String string;
            nodeImpl.setColumnNumber(this.locator.getColumnNumber());
            nodeImpl.setLineNumber(this.locator.getLineNumber());
            String string2 = this.locator.getSystemId();
            if (!(string2 == null || (string = nodeImpl.getBaseURI()) != null && string.equals(string2))) {
                if (((NodeImpl)((Object)this.document)).getBaseURI() == null && nodeImpl.getParentNode() == this.document) {
                    ((NodeImpl)((Object)this.document)).setBaseURI(string2);
                } else {
                    nodeImpl.setBaseURI(string2);
                }
            }
        }
        nodeImpl.setDocumentOrder(this.currentNodePosition++);
    }
}

