/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.util;

import com.novell.xml.util.NamespaceName;
import java.util.ArrayList;
import java.util.List;

public class NamespaceStack {
    private final List namespaceList = new ArrayList(16);
    private final List prefixList = new ArrayList(16);
    private int[] pointerStack = new int[32];
    private int pointerStackSize = 32;
    private int stackTop;
    private int top = 0;
    private int end = 0;

    public NamespaceStack() {
        this.add("xml", NamespaceName.XML_NAMESPACE);
    }

    public void push() {
        if (this.stackTop == this.pointerStackSize) {
            int[] nArray = new int[this.pointerStackSize * 2];
            System.arraycopy(this.pointerStack, 0, nArray, 0, this.pointerStackSize);
            this.pointerStack = nArray;
            this.pointerStackSize *= 2;
        }
        this.pointerStack[this.stackTop++] = this.top;
        this.pointerStack[this.stackTop++] = this.end;
    }

    public void pop() {
        this.end = this.pointerStack[--this.stackTop];
        this.top = this.pointerStack[--this.stackTop];
        while (this.end < this.namespaceList.size()) {
            int n = this.namespaceList.size() - 1;
            this.namespaceList.remove(n);
            this.prefixList.remove(n);
        }
    }

    public boolean add(String string, NamespaceName namespaceName) {
        int n = this.end - 1;
        while (n >= 0) {
            if (string.equals((String)this.prefixList.get(n)) && namespaceName.equals((NamespaceName)this.namespaceList.get(n))) {
                return false;
            }
            --n;
        }
        this.prefixList.add(string);
        this.namespaceList.add(namespaceName);
        ++this.end;
        return true;
    }

    public NamespaceName getNamespaceName(String string) {
        int n = this.end - 1;
        while (n >= 0) {
            if (string.equals((String)this.prefixList.get(n))) {
                return (NamespaceName)this.namespaceList.get(n);
            }
            --n;
        }
        return string.length() == 0 ? NamespaceName.NULL_NAMESPACE : null;
    }
}

