/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisDescendant;
import com.novell.xml.xpath.AxisElement;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class AxisFollowing
extends AxisElement {
    private Node sibling;
    private Node following;
    private AxisDescendant descendants = new AxisDescendant();

    public String toString() {
        return "following";
    }

    public void done() {
        super.done();
        this.sibling = null;
        this.following = null;
        this.descendants.done();
    }

    public Node first() {
        this.init();
        this.sibling = this.getContextNode();
        this.following = null;
        return this.next();
    }

    public Node next() {
        do {
            if (this.following != null) {
                if (this.following == this.sibling) {
                    this.descendants.setup(this.sibling, this.stripper);
                    this.following = this.descendants.first();
                } else {
                    this.following = this.descendants.next();
                }
            }
            while (this.following == null && this.sibling != null) {
                this.following = XPathUtil.getNextSibling(this.sibling);
                this.sibling = this.following == null ? this.sibling.getParentNode() : this.following;
            }
        } while (this.following != null && this.stripNode(this.following));
        return this.incPosition(this.following);
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.following;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Node sibling;
        private Node following;
        private ContextListMark mark;

        public Mark(AxisFollowing axisFollowing2) {
            super(axisFollowing2);
            this.sibling = axisFollowing2.sibling;
            this.following = axisFollowing2.following;
            this.mark = axisFollowing2.descendants.getMark();
        }

        public void restoreState(AxisFollowing axisFollowing) {
            super.restoreState(axisFollowing);
            axisFollowing.sibling = this.sibling;
            axisFollowing.following = this.following;
            axisFollowing.descendants.returnToMark(this.mark);
        }
    }
}

