/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.ElementImpl;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.XPathNamespaceNode;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AxisNamespace
extends Axis {
    private Set foundPrefixes = new HashSet();
    private Node ancestor = null;
    private NamedNodeMap attrMap = null;
    private NamedNodeMap namespaceMap = null;
    private int mapIndex = -1;
    private int lastAttr = 0;
    private XPathNamespaceNode lastNamespace;
    private static final String XMLNS = "xmlns";

    public String toString() {
        return "namespace";
    }

    public void done() {
        super.done();
        this.foundPrefixes.clear();
        this.ancestor = null;
        this.attrMap = null;
        this.namespaceMap = null;
        this.lastNamespace = null;
    }

    public Node first() {
        this.init();
        this.mapIndex = -1;
        return this.next();
    }

    public Node next() {
        return this.incPosition(this.getNextNamespace());
    }

    public int principalNodeType() {
        return -1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.lastNamespace;
    }

    protected void init() {
        super.init();
        Node node = this.getContextNode();
        this.namespaceMap = null;
        if (node != null && node.getNodeType() == 1) {
            this.ancestor = node;
            if (node instanceof ElementImpl) {
                this.namespaceMap = ((ElementImpl)node).getNamespaces();
            }
        } else {
            this.ancestor = null;
        }
        this.attrMap = null;
        this.lastAttr = -1;
        if (this.foundPrefixes != null) {
            this.foundPrefixes.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Node getNextNamespace() {
        if (this.namespaceMap == null) ** GOTO lbl24
        return this.namespaceMap.item(++this.mapIndex);
lbl-1000:
        // 1 sources

        {
            if (this.attrMap == null) {
                this.attrMap = this.ancestor.getAttributes();
                this.lastAttr = -1;
            }
            if (this.attrMap != null) {
                var1_1 = this.lastAttr + 1;
                while (var1_1 < this.attrMap.getLength()) {
                    var2_2 = (Attr)this.attrMap.item(var1_1);
                    var3_3 = var2_2.getNodeName();
                    if (XMLUtil.isNamespaceDecl(var3_3)) {
                        var4_4 = var3_3.length() > "xmlns".length() ? var3_3.substring("xmlns".length() + 1, var3_3.length()) : "";
                        var5_5 = var2_2.getNodeValue();
                        if (!this.foundPrefixes.contains(var4_4)) {
                            this.foundPrefixes.add(var4_4);
                            this.lastAttr = var1_1;
                            this.lastNamespace = new XPathNamespaceNode(var4_4, var5_5, this.ancestor);
                            return this.lastNamespace;
                        }
                    }
                    ++var1_1;
                }
            }
            this.ancestor = this.ancestor.getParentNode();
            this.attrMap = null;
lbl24:
            // 2 sources

            ** while (this.ancestor != null)
        }
lbl25:
        // 1 sources

        return null;
    }

    protected class Mark
    extends Axis.AxisMark {
        private Set foundPrefixes;
        private Node ancestor;
        private NamedNodeMap attrMap;
        private NamedNodeMap namespaceMap;
        private int mapIndex;
        private int lastAttr;
        private XPathNamespaceNode lastNamespace;

        public Mark(AxisNamespace axisNamespace2) {
            super(axisNamespace2);
            this.ancestor = axisNamespace2.ancestor;
            this.lastAttr = axisNamespace2.lastAttr;
            this.attrMap = this.ancestor == null ? null : this.ancestor.getAttributes();
            this.namespaceMap = axisNamespace2.namespaceMap;
            this.mapIndex = axisNamespace2.mapIndex;
            this.foundPrefixes = new HashSet(axisNamespace2.foundPrefixes);
        }

        public void restoreState(AxisNamespace axisNamespace) {
            super.restoreState(axisNamespace);
            axisNamespace.ancestor = this.ancestor;
            axisNamespace.lastAttr = this.lastAttr;
            axisNamespace.mapIndex = this.mapIndex;
            axisNamespace.namespaceMap = this.namespaceMap;
            axisNamespace.attrMap = this.attrMap;
            axisNamespace.foundPrefixes = this.foundPrefixes;
            axisNamespace.lastNamespace = this.lastNamespace;
        }
    }
}

