/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetRegistrar;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Function {
    private FunctionSignature signature;
    private Method[] methods = null;

    protected Function(FunctionSignature functionSignature) {
        this.signature = functionSignature;
    }

    public Function getInstance(ArgumentList argumentList) throws XPathParserException {
        return this;
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        String string;
        if (this.methods == null) {
            this.findMethods();
        }
        int n = objectArray.length - this.signature.getRequiredArgs().length;
        try {
            return (ExpressionValue)this.methods[n].invoke((Object)this, objectArray);
        }
        catch (ClassCastException classCastException) {
            throw new XPathConversionException(classCastException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            string = invocationTargetException.getMessage();
        }
        catch (IllegalAccessException illegalAccessException) {
            string = illegalAccessException.getMessage();
        }
        String[] stringArray = new String[]{this.getSignature().getName().getQName(), string};
        throw new XPathEvaluationException("ee2", stringArray);
    }

    public boolean isConstant() {
        return false;
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
    }

    protected FunctionSignature getSignature() {
        return this.signature;
    }

    private void findMethods() throws XPathEvaluationException {
        try {
            Class<?> clazz = this.getClass();
            int n = 1 + this.signature.getOptionalArgs().length;
            this.methods = new Method[n];
            Class[] classArray = this.signature.getRequiredArgs();
            this.methods[0] = clazz.getMethod(this.signature.getName().getLocalPart(), classArray);
            Class[] classArray2 = this.signature.getOptionalArgs();
            int n2 = 1;
            while (n2 < n) {
                Class[] classArray3 = new Class[classArray.length + n2];
                int n3 = 0;
                while (n3 < classArray.length) {
                    classArray3[n3] = classArray[n3];
                    ++n3;
                }
                int n4 = 0;
                while (n4 <= n2 - 1) {
                    classArray3[n3++] = classArray2[n4];
                    ++n4;
                }
                this.methods[n2] = clazz.getMethod(this.signature.getName().getLocalPart(), classArray3);
                ++n2;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XPathEvaluationException("pe12", this.signature.getName().toString());
        }
    }
}

