/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.DocumentOrderComparator;
import com.novell.xml.xpath.ContextListMark;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathConversionException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Node;

public class NodeSet
implements ExpressionValue,
Expression,
ContextNodeList {
    private SortedSet set;
    private Iterator setIt;
    private int index;
    private Node currentNode;
    private static Class argType = XPathUtil.doGetClass("com.novell.xml.xpath.NodeSet");
    protected static DocumentOrderComparator nodeComparator = new DocumentOrderComparator();

    public NodeSet() {
        this.set = new TreeSet(nodeComparator);
    }

    public NodeSet(Collection collection) throws Exception {
        if (collection.isEmpty()) {
            this.set = new TreeSet(nodeComparator);
        } else {
            Iterator iterator = collection.iterator();
            if (iterator.hasNext() && !(iterator.next() instanceof Node)) {
                throw new Exception("Cannot convert arbitrary type to node-set");
            }
            this.set = new TreeSet(nodeComparator);
            this.set.addAll(collection);
        }
    }

    public NodeSet(NodeSet nodeSet) {
        this.set = new TreeSet(nodeSet.set);
    }

    public static Class getArgType() {
        return argType;
    }

    public void add(Node node) {
        this.set.add(node);
    }

    public void remove(Node node) {
        this.set.remove(node);
    }

    public boolean contains(Node node) {
        return this.set.contains(node);
    }

    public void union(NodeSet nodeSet) {
        if (nodeSet.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.set = new TreeSet(nodeSet.set);
            return;
        }
        Iterator iterator = nodeSet.set.iterator();
        while (iterator.hasNext()) {
            this.set.add((Node)iterator.next());
        }
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public String toString() {
        return this.getStringValue();
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public Class getResultType() {
        return NodeSet.getArgType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }

    public int getValueType() {
        return 3;
    }

    public void castFrom(Object object) throws XPathConversionException {
        if (object == null) {
            this.set = new TreeSet();
        } else if (object instanceof ExpressionValue) {
            this.set = new TreeSet(((ExpressionValue)object).getNodeSetValue().set);
        } else if (object instanceof Node) {
            this.set = new TreeSet();
            this.set.add((Node)object);
        } else {
            throw new XPathConversionException("vce1");
        }
    }

    public boolean getBooleanValue() throws XPathConversionException {
        return !this.set.isEmpty();
    }

    public double getNumberValue() throws XPathConversionException {
        return NumberValue.convertToNumber(this.getStringValue());
    }

    public String getStringValue() {
        if (this.set.isEmpty()) {
            return "";
        }
        return XPathUtil.getNodeValue((Node)this.set.first());
    }

    public NodeSet getNodeSetValue() throws XPathConversionException {
        return this;
    }

    public Object getNativeValue() {
        return this.set.first();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Node set:");
        Node node = this.first();
        if (node != null) {
            do {
                printWriter.println("\t" + XPathUtil.describeNode(node));
            } while ((node = this.next()) != null);
        } else {
            printWriter.println("\tEmpty");
        }
    }

    public Node first() {
        this.currentNode = null;
        this.setIt = this.set.iterator();
        this.index = 0;
        if (this.setIt.hasNext()) {
            ++this.index;
            this.currentNode = (Node)this.setIt.next();
        }
        return this.currentNode;
    }

    public Node next() {
        this.currentNode = null;
        if (this.setIt != null && this.setIt.hasNext()) {
            ++this.index;
            this.currentNode = (Node)this.setIt.next();
        }
        return this.currentNode;
    }

    public int count() {
        return this.set.size();
    }

    public int position() {
        return this.index;
    }

    public int order() {
        return 1;
    }

    public ContextListMark getMark() {
        return new Mark(this);
    }

    public Node returnToMark(ContextListMark contextListMark) {
        ((Mark)contextListMark).restoreState(this);
        return this.currentNode;
    }

    protected class Mark
    implements ContextListMark {
        private Iterator setIt;
        private int index;
        private Node currentNode;

        Mark(NodeSet nodeSet2) {
            this.index = nodeSet2.index;
            this.setIt = nodeSet2.setIt;
            this.currentNode = nodeSet2.currentNode;
        }

        void restoreState(NodeSet nodeSet) {
            nodeSet.index = this.index;
            nodeSet.setIt = this.setIt;
            nodeSet.currentNode = this.currentNode;
        }
    }
}

