/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.AbsoluteLocationPath;
import com.novell.xml.xpath.AndExpr;
import com.novell.xml.xpath.ArgumentList;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisAttribute;
import com.novell.xml.xpath.AxisChild;
import com.novell.xml.xpath.AxisDescendantOrSelf;
import com.novell.xml.xpath.AxisNameToken;
import com.novell.xml.xpath.AxisParent;
import com.novell.xml.xpath.AxisSelf;
import com.novell.xml.xpath.Basis;
import com.novell.xml.xpath.BrokenNotEqualsExpr;
import com.novell.xml.xpath.DivExpr;
import com.novell.xml.xpath.EqualsExpr;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.FilterExpr;
import com.novell.xml.xpath.FunctionCall;
import com.novell.xml.xpath.FunctionLibrary;
import com.novell.xml.xpath.FunctionLibraryImpl;
import com.novell.xml.xpath.FunctionNameToken;
import com.novell.xml.xpath.GreaterThanEqualsExpr;
import com.novell.xml.xpath.GreaterThanExpr;
import com.novell.xml.xpath.LessThanEqualsExpr;
import com.novell.xml.xpath.LessThanExpr;
import com.novell.xml.xpath.LiteralToken;
import com.novell.xml.xpath.MinusExpr;
import com.novell.xml.xpath.ModExpr;
import com.novell.xml.xpath.MulExpr;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.NodeType;
import com.novell.xml.xpath.NodeTypePI;
import com.novell.xml.xpath.NodeTypeToken;
import com.novell.xml.xpath.NotEqualsExpr;
import com.novell.xml.xpath.NumberToken;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.OperatorToken;
import com.novell.xml.xpath.OrExpr;
import com.novell.xml.xpath.PathExpr;
import com.novell.xml.xpath.PlusExpr;
import com.novell.xml.xpath.Predicate;
import com.novell.xml.xpath.RelativeLocationPath;
import com.novell.xml.xpath.Scanner;
import com.novell.xml.xpath.Step;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.UnaryExpr;
import com.novell.xml.xpath.UnionExpr;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.VariableRefToken;
import com.novell.xml.xpath.VariableReference;
import com.novell.xml.xpath.WildcardName;
import com.novell.xml.xpath.WildcardNameToken;
import com.novell.xml.xpath.XPathException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.functions.XPathBuiltIns;
import java.util.Vector;

public class Parser {
    private Token[] tokens;
    private int currentToken;
    private Token nullToken = new Token(0);
    private VariableBindings variables;
    private FunctionLibrary library;
    private NamespaceContext namespaces;
    private boolean brokenMode = false;
    private static FunctionLibrary defaultFunctionLibrary = null;
    private static Object libSync = new Object();

    public Parser(NamespaceContext namespaceContext) {
        this(null, Parser.getDefaultFunctionLibrary(), namespaceContext);
    }

    public Parser(VariableBindings variableBindings, FunctionLibrary functionLibrary, NamespaceContext namespaceContext) {
        this.variables = variableBindings;
        this.library = functionLibrary != null ? functionLibrary : Parser.getDefaultFunctionLibrary();
        this.namespaces = namespaceContext;
    }

    public boolean setBrokenMode(boolean bl) {
        boolean bl2 = this.brokenMode;
        this.brokenMode = bl;
        return bl2;
    }

    public Expression parse(String string) throws XPathParserException {
        this.tokenize(string);
        return this.parse();
    }

    public Expression parse(Token[] tokenArray) throws XPathParserException {
        this.tokens = tokenArray;
        this.currentToken = 0;
        return this.parse();
    }

    protected Expression parse() throws XPathParserException {
        Expression expression = this.parseExpr();
        if (this.peekToken().getType() != 0) {
            throw new XPathParserException("pe5");
        }
        return expression;
    }

    protected Expression parseExpr() throws XPathParserException {
        if (this.peekToken().getType() == 0) {
            throw new XPathParserException("pe6");
        }
        return this.parseOrExpr();
    }

    protected Expression parseOrExpr() throws XPathParserException {
        Expression expression = this.parseAndExpr();
        Token token = this.peekToken();
        while (this.getOperator(token) == 15) {
            this.nextToken();
            expression = new OrExpr(expression, this.parseAndExpr());
            token = this.peekToken();
        }
        return expression;
    }

    protected Expression parseAndExpr() throws XPathParserException {
        Expression expression = this.parseEqualityExpr();
        Token token = this.peekToken();
        while (token.getType() == 10 && ((OperatorToken)token).getOperator() == 12) {
            this.nextToken();
            expression = new AndExpr(expression, this.parseEqualityExpr());
            token = this.peekToken();
        }
        return expression;
    }

    protected Expression parseEqualityExpr() throws XPathParserException {
        Expression expression = this.parseRelationalExpr();
        Token token = this.peekToken();
        while (true) {
            int n = this.getOperator(token);
            switch (n) {
                case 9: {
                    this.nextToken();
                    expression = new EqualsExpr(expression, this.parseRelationalExpr());
                    break;
                }
                case 1: {
                    this.nextToken();
                    if (this.brokenMode) {
                        expression = new BrokenNotEqualsExpr(expression, this.parseRelationalExpr());
                        break;
                    }
                    expression = new NotEqualsExpr(expression, this.parseRelationalExpr());
                    break;
                }
                default: {
                    return expression;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseRelationalExpr() throws XPathParserException {
        Expression expression = this.parseAdditiveExpr();
        Token token = this.peekToken();
        while (true) {
            int n = this.getOperator(token);
            switch (n) {
                case 7: {
                    this.nextToken();
                    expression = new LessThanExpr(expression, this.parseAdditiveExpr());
                    break;
                }
                case 10: {
                    this.nextToken();
                    expression = new GreaterThanExpr(expression, this.parseAdditiveExpr());
                    break;
                }
                case 8: {
                    this.nextToken();
                    expression = new LessThanEqualsExpr(expression, this.parseAdditiveExpr());
                    break;
                }
                case 11: {
                    this.nextToken();
                    expression = new GreaterThanEqualsExpr(expression, this.parseAdditiveExpr());
                    break;
                }
                default: {
                    return expression;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseAdditiveExpr() throws XPathParserException {
        Expression expression = this.parseMultiplicativeExpr();
        Token token = this.peekToken();
        while (true) {
            int n = this.getOperator(token);
            switch (n) {
                case 3: {
                    this.nextToken();
                    expression = new PlusExpr(expression, this.parseMultiplicativeExpr());
                    break;
                }
                case 4: {
                    this.nextToken();
                    expression = new MinusExpr(expression, this.parseMultiplicativeExpr());
                    break;
                }
                default: {
                    return expression;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseMultiplicativeExpr() throws XPathParserException {
        Expression expression = this.parseUnaryExpr();
        Token token = this.peekToken();
        while (true) {
            int n = this.getOperator(token);
            switch (n) {
                case 2: {
                    this.nextToken();
                    expression = new MulExpr(expression, this.parseUnaryExpr());
                    break;
                }
                case 13: {
                    this.nextToken();
                    expression = new DivExpr(expression, this.parseUnaryExpr());
                    break;
                }
                case 14: {
                    this.nextToken();
                    expression = new ModExpr(expression, this.parseUnaryExpr());
                    break;
                }
                default: {
                    return expression;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseUnaryExpr() throws XPathParserException {
        Token token = this.peekToken();
        int n = this.getOperator(token);
        if (n == 4) {
            this.nextToken();
            return new UnaryExpr(this.parseUnaryExpr());
        }
        return this.parseUnionExpr();
    }

    protected Expression parseUnionExpr() throws XPathParserException {
        Expression expression = this.parsePathExpr();
        Token token = this.peekToken();
        int n;
        while ((n = this.getOperator(token)) == 16) {
            this.nextToken();
            expression = new UnionExpr(expression, this.parsePathExpr());
            token = this.peekToken();
        }
        return expression;
    }

    protected Expression parsePathExpr() throws XPathParserException {
        Token token = this.peekToken();
        int n = this.getOperator(token);
        int n2 = token.getType();
        if (n == 5 || n2 == 14 || n2 == 11 || n2 == 12 || n == 6 || n2 == 5 || n2 == 6 || n2 == 7) {
            return this.parseLocationPath();
        }
        Expression expression = this.parseFilterExpr();
        token = this.peekToken();
        while (true) {
            n = this.getOperator(token);
            switch (n) {
                case 5: {
                    this.nextToken();
                    expression = new PathExpr(expression, this.parseRelativeLocationPath());
                    break;
                }
                case 6: {
                    this.nextToken();
                    NodeTypeToken nodeTypeToken = new NodeTypeToken(2);
                    RelativeLocationPath relativeLocationPath = new RelativeLocationPath(new Step(new Basis(new AxisDescendantOrSelf(), (NodeTest)new NodeType(nodeTypeToken))));
                    relativeLocationPath = new RelativeLocationPath(relativeLocationPath, this.parseRelativeLocationPath());
                    expression = new PathExpr(expression, relativeLocationPath);
                    break;
                }
                default: {
                    return expression;
                }
            }
            token = this.peekToken();
        }
    }

    protected Expression parseFilterExpr() throws XPathParserException {
        Expression expression = this.parsePrimaryExpr();
        Token token = this.peekToken();
        while (token.getType() == 3) {
            this.nextToken();
            expression = new FilterExpr(expression, this.parsePredicate());
            token = this.peekToken();
        }
        return expression;
    }

    protected Expression parsePrimaryExpr() throws XPathParserException {
        Token token = this.peekToken();
        switch (token.getType()) {
            case 17: {
                Expression expression;
                this.nextToken();
                VariableRefToken variableRefToken = (VariableRefToken)token;
                ExpandedQName expandedQName = new ExpandedQName(this.namespaces.getNamespaceName(variableRefToken.getPrefix()), variableRefToken.getLocalPart(), variableRefToken.getPrefix());
                Expression expression2 = expression = this.variables != null ? this.variables.getVariable(expandedQName) : null;
                if (expression == null) {
                    throw new XPathParserException("pe14", expandedQName.getQName());
                }
                return new VariableReference(expandedQName, expression);
            }
            case 15: {
                this.nextToken();
                return new StringValue(((LiteralToken)token).getValue());
            }
            case 16: {
                this.nextToken();
                return new NumberValue(((NumberToken)token).getValue());
            }
            case 13: {
                return this.parseFunctionCall();
            }
            case 1: {
                this.nextToken();
                Expression expression = this.parseExpr();
                if (this.peekToken().getType() != 2) {
                    throw new XPathParserException("pe4", ')');
                }
                this.nextToken();
                return expression;
            }
        }
        throw new XPathParserException("pe7");
    }

    protected Expression parseFunctionCall() throws XPathParserException {
        Token token = this.peekToken();
        this.nextToken();
        FunctionNameToken functionNameToken = (FunctionNameToken)token;
        ExpandedQName expandedQName = new ExpandedQName(this.namespaces.getNamespaceName(functionNameToken.getPrefix()), functionNameToken.getLocalPart(), functionNameToken.getPrefix());
        return new FunctionCall(this.library.getFunction(expandedQName), this.parseArgumentList());
    }

    protected ArgumentList parseArgumentList() throws XPathParserException {
        int n;
        Token token = this.peekToken();
        if (token.getType() != 1) {
            throw new XPathParserException("pe4", '(');
        }
        this.nextToken();
        token = this.peekToken();
        if (token.getType() == 2) {
            this.nextToken();
            return null;
        }
        Vector<Expression> vector = new Vector<Expression>(2, 2);
        do {
            vector.addElement(this.parseExpr());
            token = this.peekToken();
            n = token.getType();
            if (n == 8) {
                this.nextToken();
                continue;
            }
            if (n == 2) continue;
            throw new XPathParserException("pe4", ')');
        } while (n == 8);
        this.nextToken();
        Expression[] expressionArray = new Expression[vector.size()];
        int n2 = 0;
        while (n2 < expressionArray.length) {
            expressionArray[n2] = (Expression)vector.elementAt(n2);
            ++n2;
        }
        return new ArgumentList(expressionArray);
    }

    protected Expression parseLocationPath() throws XPathParserException {
        Token token = this.peekToken();
        int n = this.getOperator(token);
        if (n == 5) {
            this.nextToken();
            token = this.peekToken();
            int n2 = token.getType();
            if (n2 == 14 || n2 == 11 || n2 == 12 || n2 == 5 || n2 == 6 || n2 == 7) {
                return new AbsoluteLocationPath(this.parseRelativeLocationPath());
            }
            return new AbsoluteLocationPath();
        }
        if (n == 6) {
            this.nextToken();
            NodeTypeToken nodeTypeToken = new NodeTypeToken(2);
            RelativeLocationPath relativeLocationPath = new RelativeLocationPath(new Step(new Basis(new AxisDescendantOrSelf(), (NodeTest)new NodeType(nodeTypeToken))));
            RelativeLocationPath relativeLocationPath2 = this.parseRelativeLocationPath();
            relativeLocationPath2 = new RelativeLocationPath(relativeLocationPath, relativeLocationPath2);
            return new AbsoluteLocationPath(relativeLocationPath2);
        }
        return this.parseRelativeLocationPath();
    }

    protected RelativeLocationPath parseRelativeLocationPath() throws XPathParserException {
        RelativeLocationPath relativeLocationPath = new RelativeLocationPath(this.parseStep());
        Token token = this.peekToken();
        while (true) {
            int n;
            if ((n = this.getOperator(token)) == 5) {
                this.nextToken();
                relativeLocationPath = new RelativeLocationPath(relativeLocationPath, new RelativeLocationPath(this.parseStep()));
            } else if (n == 6) {
                this.nextToken();
                NodeTypeToken nodeTypeToken = new NodeTypeToken(2);
                RelativeLocationPath relativeLocationPath2 = new RelativeLocationPath(new Step(new Basis(new AxisDescendantOrSelf(), (NodeTest)new NodeType(nodeTypeToken))));
                relativeLocationPath = new RelativeLocationPath(relativeLocationPath, relativeLocationPath2);
                relativeLocationPath = new RelativeLocationPath(relativeLocationPath, new RelativeLocationPath(this.parseStep()));
            } else {
                return relativeLocationPath;
            }
            token = this.peekToken();
        }
    }

    protected Step parseStep() throws XPathParserException {
        Step step;
        NodeTypeToken nodeTypeToken;
        Token token = this.peekToken();
        int n = token.getType();
        if (n == 5) {
            this.nextToken();
            nodeTypeToken = new NodeTypeToken(2);
            step = new Step(new Basis(new AxisSelf(), (NodeTest)new NodeType(nodeTypeToken)));
        } else if (n == 6) {
            this.nextToken();
            nodeTypeToken = new NodeTypeToken(2);
            step = new Step(new Basis(new AxisParent(), (NodeTest)new NodeType(nodeTypeToken)));
        } else {
            step = new Step(this.parseBasis());
        }
        token = this.peekToken();
        while (token.getType() == 3) {
            this.nextToken();
            step = new Step(step, this.parsePredicate());
            token = this.peekToken();
        }
        return step;
    }

    protected Basis parseBasis() throws XPathParserException {
        Axis axis;
        Token token = this.peekToken();
        int n = token.getType();
        if (n == 14) {
            this.nextToken();
            if (this.peekToken().getType() != 9) {
                throw new XPathParserException("pe4", "::");
            }
            this.nextToken();
            return new Basis((AxisNameToken)token, this.parseNodeTest());
        }
        if (n == 7) {
            this.nextToken();
            axis = new AxisAttribute();
        } else {
            axis = new AxisChild();
        }
        return new Basis(axis, this.parseNodeTest());
    }

    protected NodeTest parseNodeTest() throws XPathParserException {
        Token token = this.peekToken();
        int n = token.getType();
        if (n == 12) {
            this.nextToken();
            if (this.peekToken().getType() != 1) {
                throw new XPathParserException("pe4", '(');
            }
            this.nextToken();
            if (((NodeTypeToken)token).getNodeType() == 3) {
                LiteralToken literalToken = null;
                if (this.peekToken().getType() == 15) {
                    literalToken = (LiteralToken)this.peekToken();
                    this.nextToken();
                }
                if (this.peekToken().getType() != 2) {
                    throw new XPathParserException("pe4", ')');
                }
                this.nextToken();
                return new NodeTypePI(literalToken == null ? "" : literalToken.getValue());
            }
            if (this.peekToken().getType() != 2) {
                throw new XPathParserException("pe4", ')');
            }
            this.nextToken();
            return new NodeType((NodeTypeToken)token);
        }
        if (n == 11) {
            this.nextToken();
            try {
                return new WildcardName((WildcardNameToken)token, this.namespaces);
            }
            catch (XPathException xPathException) {
                throw new XPathParserException(xPathException.getMessage());
            }
        }
        throw new XPathParserException("pe8");
    }

    protected Predicate parsePredicate() throws XPathParserException {
        Expression expression = this.parseExpr();
        Token token = this.peekToken();
        if (token.getType() != 4) {
            throw new XPathParserException("pe4", ']');
        }
        this.nextToken();
        return new Predicate(expression);
    }

    public void tokenize(String string) throws XPathParserException {
        Scanner scanner = new Scanner(string);
        this.tokens = scanner.scan();
        this.currentToken = 0;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    protected Token peekToken() {
        return this.currentToken < this.tokens.length ? this.tokens[this.currentToken] : this.nullToken;
    }

    protected void nextToken() {
        ++this.currentToken;
    }

    protected int getOperator(Token token) {
        return token.getType() == 10 ? ((OperatorToken)token).getOperator() : 0;
    }

    protected FunctionLibrary getLibrary() {
        return this.library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FunctionLibrary getDefaultFunctionLibrary() {
        Object object = libSync;
        synchronized (object) {
            if (defaultFunctionLibrary == null) {
                defaultFunctionLibrary = new FunctionLibraryImpl();
                XPathBuiltIns.addBuiltIns(defaultFunctionLibrary);
            }
        }
        return defaultFunctionLibrary;
    }

    protected VariableBindings getVariables() {
        return this.variables;
    }
}

