/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.dom.Namespace;
import com.novell.xml.dom.NodeDecorator;
import com.novell.xml.util.NamespaceName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathNamespaceNode
extends NodeDecorator
implements Comparable,
Namespace {
    private Node ownerElement;
    private String prefix;
    private NamespaceName namespaceName;

    public XPathNamespaceNode(String string, String string2, Node node) {
        super(XPathNamespaceNode.createBase(string.length() > 0 ? "xmlns:" + string : "xmlns", node));
        this.ownerElement = node;
        this.prefix = string;
        this.namespaceName = new NamespaceName(string2);
    }

    private static Node createBase(String string, Node node) {
        Document document = node.getOwnerDocument();
        document = document == null ? (Document)node : document;
        Attr attr = document.createAttribute(string);
        return attr;
    }

    public final short getNodeType() {
        return -1;
    }

    public final Node getParentNode() {
        return this.ownerElement;
    }

    public final String getNodeName() {
        return this.prefix;
    }

    public final String getNodeValue() {
        return this.namespaceName.getString();
    }

    public NamespaceName getNamespaceName() {
        return this.namespaceName;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Node) {
            n = ((Node)object).getNodeType() == 2 ? 1 : -1;
        } else if (object instanceof XPathNamespaceNode) {
            XPathNamespaceNode xPathNamespaceNode = (XPathNamespaceNode)object;
            n = this.getNodeName().compareTo(xPathNamespaceNode.getNodeName());
            if (n == 0) {
                n = this.getNodeValue().compareTo(xPathNamespaceNode.getNodeValue());
            }
        } else {
            n = -1;
        }
        return n;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }
}

