/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import org.w3c.dom.Node;

public class xpathSum
extends Function {
    public xpathSum() {
        super(xpathSum.createSignature());
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        try {
            NodeSet nodeSet = (NodeSet)objectArray[0];
            Node node = nodeSet.first();
            double d = 0.0;
            while (node != null) {
                double d2;
                String string = XPathUtil.getNodeValue(node);
                if (string != null && !Double.isNaN(d2 = NumberValue.convertToNumber(string))) {
                    d += Double.valueOf(string).doubleValue();
                }
                node = nodeSet.next();
            }
            return new NumberValue(d);
        }
        catch (ClassCastException classCastException) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "sum";
    }

    private static FunctionSignature createSignature() {
        Class[] classArray = new Class[]{NodeSet.getArgType()};
        return new FunctionSignature(new ExpandedQName("", "sum"), NumberValue.getArgType(), classArray);
    }
}

