/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.xml.sax.SAXtoDOM;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.process.StripList;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SAXtoDOMStrip
extends SAXtoDOM {
    protected Node currentText = null;
    protected final StripList stripList;
    protected boolean xmlSpacePreserve = false;
    protected Stack stack = new Stack();

    public SAXtoDOMStrip(Document document, StripList stripList) {
        super(document);
        this.stripList = stripList;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.strip();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.strip();
        super.startElement(string, attributeList);
        this.pushState();
        String string2 = ((Element)this.currentNode).getAttribute("xml:space");
        if (string2.length() > 0) {
            if (string2.equals("preserve")) {
                this.xmlSpacePreserve = true;
            } else if (string2.equals("default")) {
                this.xmlSpacePreserve = false;
            }
        }
    }

    public void endElement(String string) throws SAXException {
        this.strip();
        super.endElement(string);
        this.popState();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        this.currentText = this.currentNode.getLastChild();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.strip();
        super.processingInstruction(string, string2);
    }

    public void comment(String string) throws SAXException {
        this.strip();
        super.comment(string);
    }

    protected void strip() {
        if (this.currentText != null && this.stripNode(this.currentText)) {
            this.currentText.getParentNode().removeChild(this.currentText);
        }
        this.currentText = null;
    }

    public boolean stripNode(Node node) {
        if (this.stripList == null || this.stripList.size() == 0) {
            return false;
        }
        String string = node.getNodeValue();
        if (string == null) {
            return false;
        }
        if (XMLUtil.isXMLWhitespace(string)) {
            if (!this.stripList.checkStrip(node.getParentNode())) {
                return false;
            }
            return !this.xmlSpacePreserve;
        }
        return false;
    }

    protected void pushState() {
        this.stack.push(this.xmlSpacePreserve ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void popState() {
        this.xmlSpacePreserve = (Boolean)this.stack.pop();
    }
}

