/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.functions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.NumberValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.Stylesheet;
import java.util.HashMap;
import java.util.Map;

public class xsltSystemProperty
extends Function {
    private static Map xsltMap = null;
    private static Map nxslMap = null;
    private static Object gate = new Object();

    public xsltSystemProperty() {
        super(xsltSystemProperty.createSignature());
    }

    public ExpressionValue invoke(Object[] objectArray) throws XPathEvaluationException {
        try {
            ExpressionValue expressionValue = null;
            ExpressionContext expressionContext = (ExpressionContext)objectArray[1];
            String string = ((ExpressionValue)objectArray[2]).getStringValue();
            ExpandedQName expandedQName = expressionContext.getExpandedName(string);
            NamespaceName namespaceName = expandedQName.getNamespaceName();
            if (namespaceName.isEmpty()) {
                String string2 = System.getProperty(expandedQName.getLocalPart());
                if (string2 != null) {
                    expressionValue = new StringValue(string2);
                }
            } else if (namespaceName.equals(Stylesheet.NAMESPACE)) {
                xsltSystemProperty.init();
                expressionValue = (ExpressionValue)xsltMap.get(expandedQName.getLocalPart());
            } else if (namespaceName.equals(Stylesheet.NXSL_NAMESPACE)) {
                xsltSystemProperty.init();
                expressionValue = (ExpressionValue)nxslMap.get(expandedQName.getLocalPart());
            }
            if (expressionValue == null) {
                expressionValue = new StringValue();
            }
            return expressionValue;
        }
        catch (ClassCastException classCastException) {
            throw new XPathEvaluationException("pe11");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XPathEvaluationException("pe9");
        }
    }

    public String toString() {
        return "system-property";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = gate;
        synchronized (object) {
            if (xsltMap == null) {
                xsltMap = new HashMap();
                xsltMap.put("version", new NumberValue(NumberValue.convertToNumber("1.0")));
                xsltMap.put("vendor", new StringValue("Novell, Inc."));
                xsltMap.put("vendor-url", new StringValue("http://www.novell.com"));
            }
            if (nxslMap == null) {
                nxslMap = new HashMap();
                nxslMap.put("version", new NumberValue(NumberValue.convertToNumber(Integer.toString(2) + "." + Integer.toString(0))));
                nxslMap.put("build", new NumberValue(NumberValue.convertToNumber(Integer.toString(10))));
            }
        }
    }

    private static FunctionSignature createSignature() {
        try {
            Class[] classArray = new Class[]{FunctionSignature.getContextArgTypes()[0], FunctionSignature.getContextArgTypes()[1], StringValue.getArgType()};
            return new FunctionSignature(new ExpandedQName("", "system-property"), Class.forName("com.novell.xml.xpath.ExpressionValue"), classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.getLocalizedMessage());
        }
    }
}

