/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.parser.AVTLiteralToken;
import com.novell.xsl.parser.AVTScanner;
import com.novell.xsl.parser.AVTSeparatorToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class AVT
implements Expression {
    private Expression[] operands;

    public static Expression parse(String string, Parser parser, ErrorHandler errorHandler) throws XPathParserException {
        Object[] objectArray;
        AVTScanner aVTScanner = new AVTScanner(string);
        Token[] tokenArray = aVTScanner.scan();
        if (aVTScanner.getScanException() != null) {
            errorHandler.warning(aVTScanner.getScanException().getMessage());
        }
        if (tokenArray.length == 1 && tokenArray[0] instanceof AVTLiteralToken) {
            return new StringValue(((AVTLiteralToken)tokenArray[0]).getValue());
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        ArrayList<Token> arrayList2 = new ArrayList<Token>(32);
        int n = 0;
        while (n < tokenArray.length) {
            if (tokenArray[n] instanceof AVTLiteralToken || tokenArray[n] instanceof AVTSeparatorToken) {
                if (arrayList2.size() > 0) {
                    objectArray = new Token[arrayList2.size()];
                    arrayList2.toArray(objectArray);
                    arrayList2.clear();
                    arrayList.add(parser.parse((Token[])objectArray));
                }
                if (tokenArray[n] instanceof AVTLiteralToken) {
                    arrayList.add(new StringValue(((AVTLiteralToken)tokenArray[n]).getValue()));
                }
            } else {
                arrayList2.add(tokenArray[n]);
            }
            ++n;
        }
        if (arrayList2.size() > 0) {
            tokenArray = new Token[arrayList2.size()];
            arrayList2.toArray(tokenArray);
            arrayList.add(parser.parse(tokenArray));
        }
        objectArray = new Expression[arrayList.size()];
        arrayList.toArray(objectArray);
        return new AVT((Expression[])objectArray);
    }

    protected AVT(Expression[] expressionArray) {
        this.operands = expressionArray;
    }

    public Expression[] getOperands() {
        return this.operands;
    }

    public String toString() {
        String string = new String();
        int n = 0;
        while (n < this.operands.length) {
            string = !(this.operands[n] instanceof StringValue) ? string + "{" + this.operands[n].toString() + "}" : string + this.operands[n].toString();
            ++n;
        }
        return string;
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < this.operands.length) {
            stringBuffer.append(expressionContext.evaluate(node, this.operands[n]).getStringValue());
            ++n;
        }
        return new StringValue(stringBuffer.toString());
    }

    public boolean isConstant() {
        int n = 0;
        while (n < this.operands.length) {
            if (!this.operands[n].isConstant()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Class getResultType() {
        return StringValue.getArgType();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
        int n = 0;
        while (n < this.operands.length) {
            this.operands[n].registerForReset(xPathResetRegistrar);
            ++n;
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }
}

