/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.XMLUtil;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.parser.AttrDef;
import com.novell.xsl.parser.AttributeParser;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.AttributeSet;
import com.novell.xsl.process.Template;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeSetParser {
    private static AttrDef[] attributeSetAttr = new AttrDef[]{new AttrDef("name", 1, null, 6), new AttrDef("use-attribute-sets", 0, null, 9)};

    public static void parse(StylesheetParser stylesheetParser, Element element) throws XSLTParserException {
        Object[] objectArray = AttrDef.parseAttributes(stylesheetParser, element, attributeSetAttr);
        if (objectArray[0] == null) {
            return;
        }
        ExpandedQName expandedQName = (ExpandedQName)objectArray[0];
        Collection collection = null;
        if (objectArray[1] != null) {
            collection = stylesheetParser.parseQNames(element.getAttributeNode("use-attribute-sets"), (String)objectArray[1]);
        }
        ArrayList<Template> arrayList = new ArrayList<Template>();
        ExpandedQName expandedQName2 = new ExpandedQName(Stylesheet.NAMESPACE, "attribute");
        Node node = element.getFirstChild();
        while (node != null) {
            short s = node.getNodeType();
            if (s == 1) {
                ExpandedQName expandedQName3 = DOMUtil.getExpandedName(node);
                if (expandedQName2.equals(expandedQName3)) {
                    stylesheetParser.pushNSContext(node);
                    Template template = AttributeParser.parse(stylesheetParser, (Element)node);
                    stylesheetParser.popNSContext();
                    arrayList.add(template);
                } else {
                    stylesheetParser.reportError(element, node, "spe4");
                }
            } else if (!(s != 3 && s != 4 || XMLUtil.isXMLWhitespace(node.getNodeValue()))) {
                stylesheetParser.reportError(node, "spe4");
            }
            node = node.getNextSibling();
        }
        Template[] templateArray = new Template[arrayList.size()];
        arrayList.toArray(templateArray);
        try {
            stylesheetParser.getStylesheet().setAttributeSet(new AttributeSet(expandedQName, collection, templateArray, stylesheetParser.getImportPrecedence(), element));
        }
        catch (XSLException xSLException) {
            stylesheetParser.reportError(element, xSLException.getMessage());
        }
    }
}

