/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.pattern;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisAncestor;
import com.novell.xml.xpath.AxisParent;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.pattern.StepPattern;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class RelativePathPattern
implements Pattern {
    protected RelativePathPattern lhs;
    protected Axis axis = null;
    protected StepPattern rhs = null;

    public RelativePathPattern(StepPattern stepPattern) {
        this.rhs = stepPattern;
    }

    public RelativePathPattern(RelativePathPattern relativePathPattern, int n, StepPattern stepPattern) {
        this.lhs = relativePathPattern;
        this.rhs = stepPattern;
        if (n == 5) {
            this.axis = new AxisParent();
        } else if (n == 6) {
            this.axis = new AxisAncestor();
        } else {
            throw new IllegalArgumentException("RelativePathPattern: Invalid operator parameter");
        }
    }

    protected RelativePathPattern() {
        this.rhs = null;
        this.lhs = null;
        this.axis = null;
    }

    protected RelativePathPattern(RelativePathPattern relativePathPattern) {
        this.rhs = relativePathPattern.rhs;
        this.lhs = relativePathPattern.lhs;
        this.axis = relativePathPattern.axis;
    }

    public String toString() {
        if (this.lhs != null) {
            return this.lhs.toString() + "/" + this.rhs.toString();
        }
        return this.rhs.toString();
    }

    public boolean match(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        return this.performMatch(node, expressionContext) != null;
    }

    public double getDefaultPriority() {
        if (this.lhs != null || this.axis != null || this.rhs == null) {
            return 0.5;
        }
        return this.rhs.getDefaultPriority();
    }

    public int getTarget() {
        return this.rhs != null ? this.rhs.getTarget() : 9;
    }

    public ExpandedQName getTargetName() {
        return this.rhs != null ? this.rhs.getTargetName() : null;
    }

    public void dump(PrintWriter printWriter, int n) {
        XPathUtil.dump(this, printWriter, n);
    }

    protected Node performMatch(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        if (!this.rhs.match(node, expressionContext)) {
            return null;
        }
        if (this.axis == null || this.lhs == null) {
            return node;
        }
        this.axis.setup(node, expressionContext);
        node = this.axis.first();
        while (node != null) {
            if ((node = this.lhs.performMatch(node, expressionContext)) != null) {
                return node;
            }
            node = this.axis.next();
        }
        return null;
    }
}

