/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.WildcardName;
import com.novell.xsl.process.Priority;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Element;

public class ElementMatch
implements Comparable {
    private final WildcardName name;
    private final boolean strip;
    private final int importance;
    private final Priority priority;
    private final int number;

    public ElementMatch(WildcardName wildcardName, boolean bl, int n, int n2) {
        this.name = wildcardName;
        this.strip = bl;
        this.importance = n;
        this.number = n2;
        this.priority = Priority.create(Util.getWildcardNamePriority(wildcardName));
    }

    public boolean matches(Element element) {
        return this.name.evaluate(element);
    }

    public boolean isStrip() {
        return this.strip;
    }

    public int compareTo(Object object) {
        ElementMatch elementMatch = (ElementMatch)object;
        if (this.importance != elementMatch.importance) {
            return elementMatch.importance - this.importance;
        }
        int n = elementMatch.priority.compareTo(this.priority);
        if (n != 0) {
            return n;
        }
        return elementMatch.number - this.number;
    }

    public int getNumber() {
        return this.number;
    }

    public void dump(PrintWriter printWriter, int n) {
        printWriter.println(this.name.toString() + " importance=" + this.importance + " number=" + this.number + " strip=" + this.strip);
    }
}

