/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import com.novell.xsl.process.ProcessingEnv;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public abstract class Rule
implements Comparable {
    private Pattern pattern;
    private ExpandedQName name;
    private Mode mode;
    private int importance;
    private Priority priority;
    private int number;
    private Node nsContext;

    public Rule(Pattern pattern, ExpandedQName expandedQName, Mode mode, int n, Priority priority, int n2, Node node) {
        this.pattern = pattern;
        this.name = expandedQName;
        this.mode = mode;
        this.importance = n;
        this.priority = priority == null ? (pattern != null ? Priority.create(pattern.getDefaultPriority()) : Priority.create(0.0)) : priority;
        this.number = n2;
        this.nsContext = node;
    }

    protected Rule(Rule rule, Pattern pattern) {
        this.pattern = pattern;
        this.name = rule.name;
        this.mode = rule.mode;
        this.importance = rule.importance;
        this.priority = rule.priority;
        this.number = rule.number;
        this.nsContext = rule.nsContext;
    }

    public abstract Rule cloneForUnion(Pattern var1);

    public abstract void dump(PrintWriter var1, int var2);

    public Pattern getPattern() {
        return this.pattern;
    }

    public ExpandedQName getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getImportance() {
        return this.importance;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public int getNumber() {
        return this.number;
    }

    public int compareTo(Object object) {
        Rule rule = (Rule)object;
        if (this.importance != rule.importance) {
            return rule.importance - this.importance;
        }
        int n = rule.priority.compareTo(this.priority);
        if (n != 0) {
            return n;
        }
        return rule.number - this.number;
    }

    public boolean matches(Node node, ProcessingEnv processingEnv, Mode mode) throws XSLException {
        if (this.mode == mode || this.mode == Mode.ANY_MODE) {
            Trace.traceMatch(" mode+");
            try {
                return this.pattern.match(node, processingEnv.getContext());
            }
            catch (XPathEvaluationException xPathEvaluationException) {
                processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
            }
        }
        Trace.traceMatch(" mode-");
        return false;
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    protected static void indent(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("\t");
            ++n2;
        }
    }
}

