/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.pattern.Pattern;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.RuleList;
import com.novell.xsl.process.RuleMap;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class RuleCollection {
    private RuleList rootRules = new RuleList();
    private RuleMap elementRules = new RuleMap();
    private RuleList attributeRules = new RuleList();
    private RuleList otherRules = new RuleList();
    private Map namedRules = new HashMap();
    private Rule[] builtInRules;
    private boolean isOptimized = false;

    public RuleCollection() {
        int n = 2;
        if (n < 4) {
            n = 4;
        }
        if (n < 8) {
            n = 8;
        }
        if (n < 11) {
            n = 11;
        }
        if (n < 9) {
            n = 9;
        }
        if (n < 10) {
            n = 10;
        }
        if (n < 1) {
            n = 1;
        }
        if (n < 6) {
            n = 6;
        }
        if (n < 5) {
            n = 5;
        }
        if (n < 12) {
            n = 12;
        }
        if (n < 7) {
            n = 7;
        }
        if (n < 3) {
            n = 3;
        }
        this.builtInRules = new Rule[n];
    }

    public void add(Rule rule) {
        this.unoptimize();
        Pattern pattern = rule.getPattern();
        ExpandedQName expandedQName = rule.getName();
        if (expandedQName != null) {
            Rule rule2 = this.getNamedRule(expandedQName);
            if (rule2 != null) {
                if (rule2.getImportance() <= rule.getImportance()) {
                    this.namedRules.remove(expandedQName);
                    this.namedRules.put(expandedQName, rule);
                }
            } else {
                this.namedRules.put(expandedQName, rule);
            }
        }
        if (pattern != null) {
            switch (pattern.getTarget()) {
                case 0: {
                    this.rootRules.add(rule);
                    break;
                }
                case 1: {
                    this.elementRules.addNamed(pattern.getTargetName(), rule);
                    break;
                }
                case 2: {
                    this.elementRules.addWildcard(rule);
                    break;
                }
                case 3: 
                case 4: {
                    this.attributeRules.add(rule);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.otherRules.add(rule);
                    break;
                }
                default: {
                    this.rootRules.add(rule);
                    this.elementRules.addWildcard(rule);
                    this.attributeRules.add(rule);
                    this.otherRules.add(rule);
                }
            }
        }
        if (expandedQName == null && pattern == null) {
            throw new IllegalArgumentException("RuleCollection: Rule with no pattern and no name");
        }
    }

    public void setBuiltIn(Rule rule, int n) {
        if (n == 9) {
            this.builtInRules[11] = rule;
        }
        this.builtInRules[n] = rule;
    }

    public Rule findMatchingRule(Node node, ProcessingEnv processingEnv, Mode mode) throws XSLException {
        return this.matchNode(node, processingEnv, mode, null);
    }

    public Rule findMatchingImportedRule(Node node, ProcessingEnv processingEnv, Rule rule) throws XSLException {
        if (rule == null) {
            throw new IllegalArgumentException("null currentRule argument to findMatchingImportedRule()");
        }
        return this.matchNode(node, processingEnv, rule.getMode(), rule);
    }

    public Rule getNamedRule(ExpandedQName expandedQName) {
        return (Rule)this.namedRules.get(expandedQName);
    }

    public void optimize() {
        if (!this.isOptimized) {
            this.rootRules.optimize();
            this.elementRules.optimize();
            this.isOptimized = true;
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("\t");
            ++n2;
        }
        printWriter.println("built-in rules");
        int n3 = 0;
        while (n3 < this.builtInRules.length) {
            if (this.builtInRules[n3] != null) {
                this.builtInRules[n3].dump(printWriter, n + 1);
            }
            ++n3;
        }
        printWriter.println(n + "rules");
        printWriter.println(n + "root rules");
        this.rootRules.dump(printWriter, n + 1);
        printWriter.println(n + "element rules");
        this.elementRules.dump(printWriter, n + 1);
        printWriter.println(n + "attribute rules");
        this.attributeRules.dump(printWriter, n + 1);
        printWriter.println(n + "other rules");
        this.otherRules.dump(printWriter, n + 1);
    }

    private void unoptimize() {
        if (this.isOptimized) {
            this.isOptimized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Rule matchNode(Node node, ProcessingEnv processingEnv, Mode mode, Rule rule) throws XSLException {
        block15: {
            Rule rule2;
            Rule[] ruleArray;
            if (!this.isOptimized) {
                this.optimize();
            }
            switch (node.getNodeType()) {
                case 9: {
                    ruleArray = this.rootRules.getRules();
                    break;
                }
                case 1: {
                    ExpandedQName expandedQName = DOMUtil.getExpandedName(node);
                    ruleArray = this.elementRules.getRules(expandedQName);
                    break;
                }
                case 2: {
                    ruleArray = this.attributeRules.getRules();
                    break;
                }
                default: {
                    ruleArray = this.otherRules.getRules();
                }
            }
            int n = 0;
            if (rule != null) {
                int n2 = rule.getImportance();
                while (true) {
                    if (n >= ruleArray.length || n2 > ruleArray[n].getImportance()) {
                        if (n < ruleArray.length) break;
                        return null;
                    }
                    ++n;
                }
            }
            processingEnv.getContext().pushState();
            try {
                while (true) {
                    if (n >= ruleArray.length) {
                        break block15;
                    }
                    Rule rule3 = ruleArray[n];
                    Trace.traceRuleBegin(rule3);
                    processingEnv.getContext().setNamespaceContext(rule3.getNamespaceContext());
                    boolean bl = rule3.matches(node, processingEnv, mode);
                    if (bl) {
                        Trace.traceRuleEnd(rule3);
                        rule2 = rule3;
                        Object var11_13 = null;
                        break;
                    }
                    Trace.traceRuleEnd(null);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                processingEnv.getContext().popState();
                throw throwable;
            }
            processingEnv.getContext().popState();
            return rule2;
        }
        Object var11_14 = null;
        processingEnv.getContext().popState();
        if (rule != null) {
            return null;
        }
        Rule rule4 = this.builtInRules[node.getNodeType()];
        Trace.traceRuleBuiltIn(rule4);
        return rule4;
    }
}

