/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.ExpandedQName;
import com.novell.xsl.process.Rule;
import com.novell.xsl.process.RuleList;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class RuleMap {
    private HashMap hashMap = new HashMap();
    private RuleList wildcardRules = new RuleList();
    private boolean isOptimized = false;

    public void addNamed(ExpandedQName expandedQName, Rule rule) {
        this.unoptimize();
        RuleList ruleList = (RuleList)this.hashMap.get(expandedQName);
        if (ruleList == null) {
            ruleList = new RuleList();
            this.hashMap.put(expandedQName, ruleList);
        }
        ruleList.add(rule);
    }

    public void addWildcard(Rule rule) {
        this.unoptimize();
        this.wildcardRules.add(rule);
    }

    public Rule[] getRules(ExpandedQName expandedQName) {
        RuleList ruleList;
        if (!this.isOptimized) {
            this.optimize();
        }
        if ((ruleList = (RuleList)this.hashMap.get(expandedQName)) == null) {
            return this.wildcardRules.getRules();
        }
        return ruleList.getRules();
    }

    public void optimize() {
        if (!this.isOptimized) {
            Iterator iterator = this.hashMap.values().iterator();
            while (iterator.hasNext()) {
                RuleList ruleList = (RuleList)iterator.next();
                ruleList.addAll(this.wildcardRules);
                ruleList.optimize();
            }
            this.wildcardRules.optimize();
            this.isOptimized = true;
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Object object;
        boolean bl = this.isOptimized;
        this.unoptimize();
        this.wildcardRules.dump(printWriter, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = ((RuleList)iterator.next()).getRules();
            int n2 = 0;
            while (n2 < ((Rule[])object).length) {
                arrayList.add(object[n2]);
                ++n2;
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((Rule)object).getNumber();
                if (n2 < (n = ((Rule)object2).getNumber())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        });
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((Rule)object.next()).dump(printWriter, n);
        }
        if (bl) {
            this.optimize();
        }
    }

    private void unoptimize() {
        if (this.isOptimized) {
            Iterator iterator = this.hashMap.values().iterator();
            while (iterator.hasNext()) {
                RuleList ruleList = (RuleList)iterator.next();
                ruleList.removeAll(this.wildcardRules);
            }
            this.isOptimized = false;
        }
    }
}

