/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.CurrentNodeList;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.SortKey;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.w3c.dom.Node;

public class SortCriteria {
    private SortKey[] sortKeys;
    private Node contextNode;

    public SortCriteria(SortKey[] sortKeyArray, Node node) {
        this.sortKeys = sortKeyArray;
        this.contextNode = node;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ContextNodeList sort(ProcessingEnv var1_1, Node var2_2, ContextNodeList var3_3) throws XSLException {
        try {
            var4_4 = this.sortKeys.length;
            var5_6 = new EvaluatedSortKey[var4_4];
            var6_8 = 0;
            while (var6_8 < var4_4) {
                var7_9 = this.sortKeys[var6_8];
                var8_11 /* !! */  = null;
                if (var7_9.getLangExpr() != null) {
                    var8_11 /* !! */  = var1_1.getContext().evaluate(var2_2, var7_9.getLangExpr()).getStringValue();
                }
                try {
                    var9_12 = Util.parseLang((String)var8_11 /* !! */ );
                }
                catch (IllegalArgumentException var10_14) {
                    var1_1.reportError(this.contextNode, "pe18", (String)var8_11 /* !! */ );
                    var9_12 = Locale.getDefault();
                }
                var10_13 = false;
                if (var7_9.getOrderExpr() != null) {
                    var11_15 = var7_9.getOrderExpr().evaluate(var2_2, var1_1.getContext()).getStringValue();
                    if ("descending".equals(var11_15)) {
                        var10_13 = true;
                    } else if (!"ascending".equals(var11_15)) {
                        var1_1.reportError(this.contextNode, "pe14", XMLUtil.quote(var11_15));
                    }
                }
                if (var7_9.getDataTypeExpr() == null) ** GOTO lbl34
                var11_15 = var1_1.getContext().evaluate(var2_2, var7_9.getDataTypeExpr()).getStringValue();
                if ("number".equals(var11_15)) {
                    var5_6[var6_8] = new NumberKey(var7_9.getSelect(), var10_13);
                } else {
                    if (!"text".equals(var11_15)) {
                        if (XMLUtil.isQName(var11_15) && var11_15.indexOf(58) != -1) {
                            var1_1.reportWarning(this.contextNode, "pe19", new String[]{XMLUtil.quote(var11_15)});
                        } else {
                            var1_1.reportError(this.contextNode, "pe15", XMLUtil.quote(var11_15));
                        }
                    }
lbl34:
                    // 5 sources

                    var11_16 = false;
                    if (var7_9.getCaseOrderExpr() != null) {
                        var12_18 = var1_1.getContext().evaluate(var2_2, var7_9.getCaseOrderExpr()).getStringValue();
                        if ("upper-first".equals(var12_18)) {
                            var11_16 = true;
                        } else if (!"lower-first".equals(var12_18)) {
                            var1_1.reportError(this.contextNode, "pe16", XMLUtil.quote(var12_18));
                        }
                    }
                    var5_6[var6_8] = new TextKey(var7_9.getSelect(), (Locale)var9_12, var10_13, var11_16);
                }
                ++var6_8;
            }
            var7_10 = var3_3.count();
            var8_11 /* !! */  = new ComparableAdapter[var7_10];
            var9_12 = var3_3.first();
            var10_13 = false;
            while (var9_12 != null) {
                var8_11 /* !! */ [var10_13++] = new ComparableAdapter((Node)var9_12, var1_1.getContext(), var5_6);
                var9_12 = var3_3.next();
            }
            Arrays.sort(var8_11 /* !! */ );
            var11_17 = new CurrentNodeList();
            var10_13 = false;
            while (var10_13 < var7_10) {
                var11_17.add(var8_11 /* !! */ [var10_13].node);
                var10_13 += 1;
            }
            return var11_17;
        }
        catch (XPathEvaluationException var4_5) {
            var1_1.reportError(this.contextNode, "pe2", var4_5.getMessage());
            return var3_3;
        }
        catch (RuntimeException var5_7) {
            var1_1.reportError(var5_7.getMessage());
            return var3_3;
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < this.sortKeys.length) {
            this.sortKeys[n2].dump(printWriter, n);
            ++n2;
        }
    }

    private static class ComparableAdapter
    implements Comparable {
        Node node;
        ExpressionContext context;
        private EvaluatedSortKey[] evaluatedSortKeys;
        private Object[] cachedValues;

        public ComparableAdapter(Node node, ExpressionContext expressionContext, EvaluatedSortKey[] evaluatedSortKeyArray) {
            this.node = node;
            this.context = expressionContext;
            this.evaluatedSortKeys = evaluatedSortKeyArray;
            this.cachedValues = new Object[evaluatedSortKeyArray.length];
        }

        public int compareTo(Object object) {
            ComparableAdapter comparableAdapter = (ComparableAdapter)object;
            Assert.assertCondition(this.evaluatedSortKeys == comparableAdapter.evaluatedSortKeys, "adapters have different sort keys");
            try {
                int n = 0;
                int n2 = 0;
                while (n2 < this.evaluatedSortKeys.length && n == 0) {
                    if (this.cachedValues[n2] == null) {
                        this.cachedValues[n2] = this.evaluatedSortKeys[n2].evaluateKeyValue(this.node, this.context);
                    }
                    if (comparableAdapter.cachedValues[n2] == null) {
                        comparableAdapter.cachedValues[n2] = comparableAdapter.evaluatedSortKeys[n2].evaluateKeyValue(comparableAdapter.node, this.context);
                    }
                    n = this.evaluatedSortKeys[n2].compare(this.cachedValues[n2], comparableAdapter.cachedValues[n2]);
                    ++n2;
                }
                return n;
            }
            catch (XPathEvaluationException xPathEvaluationException) {
                throw new RuntimeException(xPathEvaluationException.getMessage());
            }
        }
    }

    private static class TextKey
    implements EvaluatedSortKey {
        private Expression select;
        private Collator collator;
        private boolean isDescending;
        private boolean upperIsFirst;

        public TextKey(Expression expression, Locale locale, boolean bl, boolean bl2) {
            this.select = expression;
            this.collator = Collator.getInstance(locale);
            this.isDescending = bl;
            this.upperIsFirst = bl2;
        }

        public int compare(Object object, Object object2) {
            int n = ((CollationKey)object).compareTo((CollationKey)object2);
            return this.isDescending ? -n : n;
        }

        public Object evaluateKeyValue(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
            Trace.traceSortKey("Text key");
            ExpressionValue expressionValue = expressionContext.evaluate(node, this.select);
            Trace.traceSelect(this.select, expressionValue);
            String string = expressionValue.getStringValue();
            if (this.upperIsFirst) {
                char[] cArray = string.toCharArray();
                int n = cArray.length - 1;
                while (n >= 0) {
                    char c = cArray[n];
                    if (Character.isLowerCase(c)) {
                        cArray[n] = Character.toUpperCase(c);
                    } else if (Character.isUpperCase(c)) {
                        cArray[n] = Character.toLowerCase(c);
                    }
                    --n;
                }
                string = new String(cArray);
            }
            return this.collator.getCollationKey(string);
        }
    }

    private static class NumberKey
    implements EvaluatedSortKey {
        private Expression select;
        private boolean isDescending;

        public NumberKey(Expression expression, boolean bl) {
            this.select = expression;
            this.isDescending = bl;
        }

        public int compare(Object object, Object object2) {
            double d;
            Double d2 = (Double)object;
            Double d3 = (Double)object2;
            int n = d2.isNaN() ? (d3.isNaN() ? 0 : -1) : (d3.isNaN() ? 1 : ((d = d2 - d3) < 0.0 ? -1 : (d > 0.0 ? 1 : 0)));
            return this.isDescending ? -n : n;
        }

        public Object evaluateKeyValue(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
            Trace.traceSortKey("Numeric key");
            ExpressionValue expressionValue = expressionContext.evaluate(node, this.select);
            Trace.traceSelect(this.select, expressionValue);
            return new Double(expressionValue.getNumberValue());
        }
    }

    private static interface EvaluatedSortKey
    extends Comparator {
        public Object evaluateKeyValue(Node var1, ExpressionContext var2) throws XPathEvaluationException;
    }
}

