/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.XMLUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class TextTemplate
implements Template {
    private final String text;
    private final boolean noEscaping;
    private final Node nsContext;

    public TextTemplate(String string, boolean bl, Node node) {
        this.text = string;
        this.noEscaping = bl;
        this.nsContext = node;
    }

    public String getText() {
        return this.text;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate(XMLUtil.quote(this.text, 50));
        try {
            if (resultHandler instanceof Serializer) {
                ((Serializer)((Object)resultHandler)).noTextEscaping(this.noEscaping);
                resultHandler.characters(this.text);
                ((Serializer)((Object)resultHandler)).noTextEscaping(false);
            } else {
                resultHandler.characters(this.text);
            }
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println(XMLUtil.quote(this.text, 50));
    }
}

