/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.StringValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.VariableTemplate;
import com.novell.xsl.result.ResultHandler;
import org.w3c.dom.Node;

public class TopLevelVariableTemplate
extends VariableTemplate
implements XPathResetCache {
    private final int importance;
    private final int number;
    private int evalLevel = 0;
    private ProcessingEnv lazyEnv;
    private Expression replacement = null;

    public TopLevelVariableTemplate(VariableTemplate variableTemplate, int n, int n2, Node node) {
        super(variableTemplate.getName(), variableTemplate.getSelect(), variableTemplate.getTemplates(), variableTemplate.isParam(), node);
        this.importance = n;
        this.number = n2;
    }

    public void setLazyEnv(ProcessingEnv processingEnv) {
        this.lazyEnv = processingEnv;
        this.setCurrentValue(null);
    }

    public void replace(Expression expression) {
        this.replacement = expression;
    }

    public int getImportance() {
        return this.importance;
    }

    public int getNumber() {
        return this.number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("top-level variable");
        try {
            if (++this.evalLevel > 1) {
                this.setCurrentValue(new StringValue());
                processingEnv.reportError(this.getNamespaceContext(), "pe13", this.getName().getQName());
            } else {
                super.instantiate(processingEnv, node, resultHandler);
            }
            Object var5_4 = null;
            --this.evalLevel;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            --this.evalLevel;
            throw throwable;
        }
    }

    public ExpressionValue evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        if (this.getCurrentValue() == null) {
            if (this.replacement == null) {
                try {
                    ProcessingEnv processingEnv = new ProcessingEnv(this.lazyEnv);
                    this.instantiate(processingEnv, processingEnv.getContext().first(), processingEnv.getTopLevelResultHandler());
                }
                catch (XSLException xSLException) {
                    throw new XPathEvaluationException(xSLException.getMessage());
                }
            } else {
                this.setCurrentValue(this.replacement.evaluate(node, expressionContext));
            }
        }
        return this.getCurrentValue();
    }

    public void registerForReset(XPathResetRegistrar xPathResetRegistrar) {
        super.registerForReset(xPathResetRegistrar);
        xPathResetRegistrar.registerResetCache(this);
    }

    public void resetCache() {
        this.setCurrentValue(null);
    }
}

