/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class WhenTemplate
extends TemplateCollection {
    private final Expression test;

    public WhenTemplate(Expression expression, Template[] templateArray, Node node) {
        super(templateArray, node);
        this.test = expression;
    }

    public Expression getTest() {
        return this.test;
    }

    public boolean isTrue(Node node, ProcessingEnv processingEnv) throws XSLException {
        try {
            return processingEnv.getContext().evaluate(node, this.test).getBooleanValue();
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
            return false;
        }
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("when");
        this.instantiateTemplates(processingEnv, node, resultHandler);
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("when");
        this.test.dump(printWriter, n + 1);
        super.dump(printWriter, n + 1);
    }
}

