/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.tags;

import com.novell.nps.debug.Debug;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class iManNoWhiteTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;

    public int doAfterBody() throws JspTagException {
        JspWriter writer = this.getPreviousOut();
        Reader reader = this.getBodyContent().getReader();
        try {
            String device = (String)this.pageContext.findAttribute("DeviceType");
            if (device != null && device.equals("pocket")) {
                this.stripWhite(reader, (Writer)writer);
            } else {
                this.copyData(reader, (Writer)writer);
            }
        }
        catch (IOException e) {
            Debug.log((String)"iManager", (Exception)e);
        }
        return 6;
    }

    private void stripWhite(Reader reader, Writer writer) throws IOException {
        int ch;
        while ((ch = reader.read()) != -1) {
            writer.write(ch);
            if (ch != 10) continue;
            this.skipWhite(reader, writer);
        }
    }

    private final void copyData(Reader reader, Writer writer) throws IOException {
        int bCnt;
        char[] data = new char[1024];
        while ((bCnt = reader.read(data, 0, 1024)) != -1) {
            writer.write(data, 0, bCnt);
        }
    }

    private final void skipWhite(Reader reader, Writer writer) throws IOException {
        int ch = reader.read();
        while (ch != -1 && Character.isWhitespace((char)ch)) {
            ch = reader.read();
        }
        if (ch != -1) {
            writer.write(ch);
        }
    }
}

