/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.EnumResponse;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;

public class EnumRequest
extends SSRequest {
    private String filter;
    private int maxBufferSize;

    public EnumRequest(int n, String string, String string2, int n2) {
        super("2.16.840.1.113719.1.148.100.13", n, string, false);
        this.filter = string2.length() == 0 ? "*" : string2;
        this.maxBufferSize = n2;
        this.constructPacket();
    }

    public Object createExtendedResponse(String string, byte[] byArray) {
        return new EnumResponse(byArray);
    }

    protected void constructPacket() throws SSException {
        super.constructPacket(false);
        try {
            this.filter = this.filter + '\u0000';
            ASN1OctetString aSN1OctetString = new ASN1OctetString(this.filter.getBytes("UTF-8"));
            ASN1Integer aSN1Integer = new ASN1Integer(this.maxBufferSize);
            this.asn1_seq.add(aSN1OctetString);
            this.asn1_seq.add(aSN1Integer);
            this.asn1_seq.encode(this.enc, this.out);
            if (this.packet != null) {
                Arrays.fill(this.packet, (byte)0);
            }
            this.packet = this.out.toByteArray();
        }
        catch (IOException iOException) {
            throw new SSException(iOException, "Encoding Error:");
        }
    }
}

