/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import java.io.Serializable;
import java.util.Arrays;

public abstract class SSExtension
implements Serializable {
    protected transient byte[] packet;
    private String oid;

    public SSExtension(String string) {
        this.oid = string;
    }

    public SSExtension(String string, byte[] byArray) {
        this(string);
        this.packet = byArray;
    }

    public byte[] getEncodedValue() {
        if (this.packet != null) {
            byte[] byArray = new byte[this.packet.length];
            System.arraycopy(this.packet, 0, byArray, 0, this.packet.length);
            return byArray;
        }
        return null;
    }

    public String getID() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SSExtension && this.oid.equals(((SSExtension)object).oid)) {
            return Arrays.equals(this.packet, ((SSExtension)object).packet);
        }
        return false;
    }

    public int hashCode() {
        return (this.oid + new String(this.packet)).hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " OID: " + this.oid;
    }

    protected void finalize() throws Throwable {
        if (this.packet != null) {
            Arrays.fill(this.packet, (byte)0);
        }
    }
}

