/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.GetInfoResponse;
import com.novell.security.sso.ldap.ber.SSExtension;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SSRequest
extends SSExtension {
    protected transient ASN1Sequence asn1_seq = new ASN1Sequence();
    protected transient LBEREncoder enc = new LBEREncoder();
    protected transient ByteArrayOutputStream out = new ByteArrayOutputStream();
    private int flags;
    private String name;

    public SSRequest(String string) {
        super(string);
    }

    public SSRequest(String string, int n, String string2) {
        this(string, n, string2, true);
    }

    SSRequest(String string, int n, String string2, boolean bl) {
        this(string);
        this.flags = n | 0x10;
        this.name = string2;
        if (bl) {
            this.constructPacket(true);
        }
    }

    public Object createExtendedResponse(String string, byte[] byArray) {
        if (string.equalsIgnoreCase("2.16.840.1.113719.1.148.100.2")) {
            return new GetInfoResponse(byArray);
        }
        return new SSResponse(string, byArray);
    }

    protected void constructPacket(boolean bl) throws SSException {
        try {
            this.name = this.name + '\u0000';
            ASN1Integer aSN1Integer = new ASN1Integer(784);
            ASN1Integer aSN1Integer2 = new ASN1Integer(this.flags);
            ASN1OctetString aSN1OctetString = new ASN1OctetString(this.name.getBytes("UTF-8"));
            this.asn1_seq.add(aSN1Integer);
            this.asn1_seq.add(aSN1Integer2);
            this.asn1_seq.add(aSN1OctetString);
            if (bl) {
                this.asn1_seq.encode(this.enc, this.out);
                this.packet = this.out.toByteArray();
            }
        }
        catch (IOException iOException) {
            throw new SSException(iOException, "Encoding Error:");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }
}

