/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.jndi;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.ldap.ber.AddRequest;
import com.novell.security.sso.ldap.ber.ReadRequest;
import com.novell.security.sso.ldap.ber.ReadResponse;
import com.novell.security.sso.ldap.ber.RemSecRequest;
import com.novell.security.sso.ldap.ber.SSResponse;
import com.novell.security.sso.ldap.ber.WriteRequest;
import com.novell.security.sso.ldap.jndi.JNDISecretStore;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;

public final class JNDISecret
extends Secret {
    private transient LdapContext ctx;
    private String name;

    JNDISecret(LdapContext ldapContext, String string, String string2) {
        super(string2);
        this.ctx = ldapContext;
        this.name = string;
        this.erPassword = new StringBuffer();
    }

    JNDISecret(LdapContext ldapContext, String string, String string2, StringBuffer stringBuffer) {
        super(string2);
        this.ctx = ldapContext;
        this.name = string;
        this.erPassword = stringBuffer;
        this.ssFlags |= 1;
        this.ssFlags |= 0x20;
    }

    protected synchronized void create0(int n) throws SSException {
        try {
            AddRequest addRequest = new AddRequest(n, this.name, this.id);
            JNDISecretStore.InternalRequest internalRequest = new JNDISecretStore.InternalRequest(addRequest.getID(), addRequest.getEncodedValue());
            JNDISecretStore.InternalResponse internalResponse = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(internalRequest);
            SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
            if (sSResponse.getErrorCode() != 0) {
                throw new SSException(sSResponse.getErrorCode());
            }
            this.isChanged = true;
        }
        catch (NullPointerException nullPointerException) {
            this.isChanged = true;
        }
        catch (NamingException namingException) {
            throw new SSException(JNDISecretStore.checkException(namingException));
        }
    }

    protected synchronized void delete0(int n) throws SSException {
        try {
            RemSecRequest remSecRequest = new RemSecRequest(n, this.name, this.id);
            JNDISecretStore.InternalRequest internalRequest = new JNDISecretStore.InternalRequest(remSecRequest.getID(), remSecRequest.getEncodedValue());
            JNDISecretStore.InternalResponse internalResponse = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(internalRequest);
            SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
            if (sSResponse.getErrorCode() != 0) {
                throw new SSException(sSResponse.getErrorCode());
            }
            this.isChanged = true;
        }
        catch (NullPointerException nullPointerException) {
            this.isChanged = true;
        }
        catch (NamingException namingException) {
            throw new SSException(JNDISecretStore.checkException(namingException));
        }
    }

    protected synchronized void read0(int n) throws SSException {
        this.isInitialized = true;
        char[] cArray = new char[this.erPassword.length()];
        if (cArray.length > 0) {
            this.erPassword.getChars(0, cArray.length, cArray, 0);
        } else {
            n &= 0xFFFFFFBF;
            n &= 0xFFFFFFDF;
        }
        try {
            try {
                ReadRequest readRequest = new ReadRequest(n, this.name, this.id, cArray);
                JNDISecretStore.InternalRequest internalRequest = new JNDISecretStore.InternalRequest(readRequest.getID(), readRequest.getEncodedValue());
                JNDISecretStore.InternalResponse internalResponse = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(internalRequest);
                ReadResponse readResponse = new ReadResponse(internalResponse.getEncodedValue());
                this.status = readResponse.getStatFlags();
                this.accTime = readResponse.getAccessedTime();
                this.crtTime = readResponse.getCreatedTime();
                this.modTime = readResponse.getModifiedTime();
                this.isChanged = false;
                int n2 = readResponse.getErrorCode();
                if (n2 != 0) {
                    if (n2 == -804 || n2 == -832 || n2 == -806 || n2 == -811) {
                        this.getValueException = new SSException(n2);
                    } else {
                        throw new SSException(n2);
                    }
                }
                Arrays.fill(this.secret, (byte)0);
                this.secret = readResponse.getSecretValue();
            }
            catch (NamingException namingException) {
                throw new SSException(JNDISecretStore.checkException(namingException));
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Arrays.fill(cArray, ' ');
            throw throwable;
        }
        Arrays.fill(cArray, ' ');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void write0(byte[] byArray, int n) throws SSException {
        block9: {
            char[] cArray = new char[this.erPassword.length()];
            if (cArray.length > 0) {
                this.erPassword.getChars(0, cArray.length, cArray, 0);
            } else {
                n &= 0xFFFFFFBF;
                n &= 0xFFFFFFDF;
            }
            try {
                try {
                    WriteRequest writeRequest = new WriteRequest(n, this.name, this.id, byArray, cArray);
                    JNDISecretStore.InternalRequest internalRequest = new JNDISecretStore.InternalRequest(writeRequest.getID(), writeRequest.getEncodedValue());
                    JNDISecretStore.InternalResponse internalResponse = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(internalRequest);
                    SSResponse sSResponse = new SSResponse(internalResponse.getID(), internalResponse.getEncodedValue());
                    if (sSResponse.getErrorCode() != 0) {
                        throw new SSException(sSResponse.getErrorCode());
                    }
                    Object var9_10 = null;
                }
                catch (NullPointerException nullPointerException) {
                    this.isChanged = true;
                    Object var9_11 = null;
                    Arrays.fill(cArray, ' ');
                    break block9;
                }
                catch (NamingException namingException) {
                    throw new SSException(JNDISecretStore.checkException(namingException));
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                Arrays.fill(cArray, ' ');
                throw throwable;
            }
            Arrays.fill(cArray, ' ');
        }
        this.isChanged = true;
    }
}

