/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ncp;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.ncp.NCPSecret;
import com.novell.security.sso.ncp.SSOWrap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class NCPSecretStore
extends SecretStore {
    public NCPSecretStore(Hashtable hashtable) throws SSException {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary("nwsso");
                    return null;
                }
            });
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new SSException(unsatisfiedLinkError, "- Cannot find nwsso.dll.");
        }
        this.env = (Hashtable)hashtable.clone();
    }

    public synchronized Secret getSecret0(String string, boolean bl) {
        if (bl) {
            return new NCPSecret(string, (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"), this.masterPassword);
        }
        return new NCPSecret(string, (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"));
    }

    protected synchronized void getServiceInfo0(int n) throws SSException {
        int n2;
        String string;
        this.initialized = true;
        String[] stringArray = new String[5];
        int[] nArray = new int[10];
        String string2 = this.env.containsKey("com.novell.sso.userdn") ? this.env.get("com.novell.sso.userdn").toString() : null;
        int n3 = SSOWrap.getServiceInfo(n, string2, string = this.env.containsKey("com.novell.sso.tree") ? this.env.get("com.novell.sso.tree").toString() : null, stringArray, nArray);
        if (n3 != 0) {
            throw new SSException(n3);
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4] != null && (n2 = stringArray[n4].indexOf(0)) > 0) {
                stringArray[n4] = stringArray[n4].substring(0, n2);
            }
            ++n4;
        }
        n2 = 0;
        if (stringArray[n2] != null) {
            this.env.put("com.novell.sso.callerdn", stringArray[n2]);
        }
        if (stringArray[++n2] != null) {
            this.env.put("com.novell.sso.serverdn", stringArray[n2]);
        }
        if (stringArray[++n2] != null) {
            this.env.put("com.novell.sso.tree", stringArray[n2]);
        }
        if (stringArray[++n2] != null) {
            if (this.hint != null) {
                Arrays.fill(this.hint, '\u0000');
            }
            this.hint = new char[stringArray[n2].length()];
            stringArray[n2].getChars(0, stringArray[n2].length(), this.hint, 0);
        }
        if (stringArray[++n2] != null) {
            this.lastAdminUnlockDn = stringArray[n2];
        }
        n2 = 0;
        this.clientVersion = nArray[n2++];
        this.serverVersion = nArray[n2++];
        this.clientCryptoStrength = (byte)nArray[n2++];
        this.serverCryptoStrength = (byte)nArray[n2++];
        this.status = nArray[n2++];
        this.secretCount = nArray[n2++];
        this.lockCount = nArray[n2++];
        this.enumBuffLen = nArray[n2++];
        this.lastAdminUnlockTime = nArray[n2++];
        this.hiddenCount = nArray[n2++];
    }

    protected synchronized void commitMasterPasswordChange0(int n, char[] cArray) throws SSException {
        int n2;
        String string = null;
        if (this.masterPassword.length() > 0) {
            char[] cArray2 = new char[this.masterPassword.length()];
            this.masterPassword.getChars(0, this.masterPassword.length(), cArray2, 0);
            string = new String(cArray2);
            Arrays.fill(cArray2, '\u0000');
        }
        if ((n2 = SSOWrap.setMasterPassword(n, string, new String(cArray), (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"))) != 0) {
            throw new SSException(n2);
        }
    }

    protected synchronized StringTokenizer enumerateSecrets0(int n, String string, int n2) throws SSException {
        Integer n3 = new Integer(0);
        String string2 = SSOWrap.enumerateSecretIDs(n, string, n2, (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"), n3);
        if (n3 != 0) {
            throw new SSException(n3);
        }
        int n4 = string2.indexOf(0);
        if (n4 != -1) {
            string2 = string2.substring(0, n4);
        }
        return new StringTokenizer(string2, "*");
    }

    protected synchronized void removeSecretStore0(int n) throws SSException {
        int n2 = SSOWrap.removeSecretStore(n, (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"));
        if (n2 != 0) {
            throw new SSException(n2);
        }
    }

    protected synchronized void unlockSecretStore0(int n) throws SSException {
        String[] stringArray;
        String string = null;
        if ((n & 4) != 4) {
            if (this.masterPassword == null) {
                throw new IllegalArgumentException("master password is null");
            }
            n |= 0x20;
            if (this.masterPassword.length() > 0) {
                stringArray = (String[])new char[this.masterPassword.length()];
                this.masterPassword.getChars(0, this.masterPassword.length(), (char[])stringArray, 0);
                string = new String((char[])stringArray);
                Arrays.fill((char[])stringArray, '\u0000');
            }
        }
        stringArray = new String[1];
        int n2 = SSOWrap.unlockSecrets(n, string, (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"), stringArray);
        if (n2 != 0) {
            throw new SSException(n2);
        }
        if (stringArray[0] != null) {
            Arrays.fill(this.hint, '\u0000');
            int n3 = stringArray[0].indexOf(0);
            if (n3 > 0) {
                stringArray[0] = stringArray[0].substring(0, n3);
            }
            this.hint = new char[stringArray[0].length()];
            stringArray[0].getChars(0, stringArray[0].length(), this.hint, 0);
        }
    }

    protected synchronized void unlockSecretStore0(int n, char[] cArray) throws SSException {
        int n2;
        if ((n & 4) != 4) {
            if (cArray == null) {
                throw new IllegalArgumentException("NDS Password is null");
            }
        } else if (cArray == null) {
            cArray = new char[]{};
        }
        String[] stringArray = new String[1];
        char[] cArray2 = cArray;
        synchronized (cArray2) {
            n2 = SSOWrap.unlockSecrets(n, new String(cArray), (String)this.env.get("com.novell.sso.userdn"), (String)this.env.get("com.novell.sso.tree"), stringArray);
        }
        if (n2 != 0) {
            throw new SSException(n2);
        }
        if (stringArray[0] != null) {
            Arrays.fill(this.hint, '\u0000');
            int n3 = stringArray[0].indexOf(0);
            if (n3 > 0) {
                stringArray[0] = stringArray[0].substring(0, n3);
            }
            this.hint = new char[stringArray[0].length()];
            stringArray[0].getChars(0, stringArray[0].length(), this.hint, 0);
        }
    }
}

