/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.NvdsLdapExtensions.NVDSException;
import com.novell.NvdsLdapExtensions.NvdsLdapExtensions;
import com.novell.NvdsLdapExtensions.RBACRoleInfo;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBACRole;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSRoleReport;
import com.novell.rbs.RBSScope;
import com.novell.rbs.RBSTask;
import com.novell.rbs.RBSUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RBSAssociatedObject
extends RBSObject
implements Serializable {
    private Hashtable otherNSObjectsTable = new Hashtable(10);
    private HashMap roleHashMap = new HashMap();

    public RBSAssociatedObject(ObjectEntry objectEntry) {
        super(objectEntry);
    }

    public RBSAssociatedObject(NSObject obj) {
        super(obj);
    }

    public RBSCollection[] getOwnedCollections() throws SPIException {
        return this.getOwnedCollectionsMain(1);
    }

    public RBSCollection[] getOwnedCollections2() throws SPIException {
        return this.getOwnedCollectionsMain(2);
    }

    private RBSCollection[] getOwnedCollectionsMain(int version) throws SPIException {
        this.verifyNSObject();
        ObjectEntry[] ownedCollections = version == 1 ? NSModel.getDN(this.oe, this.nsObj, "rbsOwnedCollections") : NSModel.getDN(this.oe, this.nsObj, "rbsOwnedCollections2");
        if (ownedCollections != null) {
            RBSCollection[] collections = new RBSCollection[ownedCollections.length];
            for (int i = 0; i < ownedCollections.length; ++i) {
                collections[i] = new RBSCollection(ownedCollections[i]);
            }
            return collections;
        }
        return null;
    }

    public void setOwnedCollections(RBSCollection[] collections) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.setOwnedCollectionsMain(collections, 1);
    }

    public void setOwnedCollections2(RBSCollection[] collections) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.setOwnedCollectionsMain(collections, 2);
    }

    private void setOwnedCollectionsMain(RBSCollection[] collections, int version) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        if (collections == null) {
            if (version == 1) {
                this.deleteOwnedCollections(this.getOwnedCollections());
            } else {
                this.deleteOwnedCollections2(this.getOwnedCollections2());
            }
        } else if (version == 1) {
            this.deleteOwnedCollections(this.getOwnedCollections());
            this.addOwnedCollections(collections);
        } else {
            this.deleteOwnedCollections2(this.getOwnedCollections2());
            this.addOwnedCollections2(collections);
        }
    }

    public void addOwnedCollections(RBSCollection[] collections) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.addOwnedCollectionsMain(collections, 1);
    }

    public void addOwnedCollections2(RBSCollection[] collections) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.addOwnedCollectionsMain(collections, 2);
    }

    private void addOwnedCollectionsMain(RBSCollection[] collections, int version) throws SPIException, ComponentCreationException, NamespaceException, SnapinVetoException {
        this.verifyNSObject();
        if (collections != null) {
            if (this.isNVDS && !RBSUtil.doesObjectHaveRBSAuxCollectionInfoClass(this.nsObj)) {
                RBSUtil.addRBSAuxCollectionInfoClass(this.nsObj);
            }
            String ownerName = this.ns.getUnrootedName(this.nsObj.getObjectEntry());
            for (int i = 0; i < collections.length; ++i) {
                RBSRights entryRights;
                ObjectEntry collectionOE = collections[i].getObjectEntry();
                String collectionName = this.ns.getUnrootedName(collectionOE);
                NSObject collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName);
                if (collectionObj == null) {
                    collectionObj = this.ns.getDetails(collectionOE);
                    this.otherNSObjectsTable.put(collectionName, collectionObj);
                }
                if (version == 1) {
                    NSModel.makeDNRelation(collectionObj, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)collectionOE, (String)"Owner"), "rbsOwnedCollections");
                } else {
                    NSModel.makeDNRelation(collectionObj, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)collectionOE, (String)"Owner"), "rbsOwnedCollections2");
                }
                if (this.isNVDS) {
                    entryRights = new RBSNVDSRights(ownerName, "", "wholeSubtree", "", "", 1L, 16L);
                    RBSUtil.addNVDSACLRights(collectionObj, entryRights);
                    continue;
                }
                entryRights = new RBSRights(ownerName, "[Entry Rights]", RBSUtil.setInheritableBit("[Entry Rights]", RBSUtil.setRBSBit(16L), "true"));
                RBSUtil.addACLRights(collectionObj, entryRights);
            }
        }
    }

    public void deleteOwnedCollections(RBSCollection[] collections) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.deleteOwnedCollectionsMain(collections, 1);
    }

    public void deleteOwnedCollections2(RBSCollection[] collections) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.deleteOwnedCollectionsMain(collections, 2);
    }

    public void deleteOwnedCollectionsMain(RBSCollection[] collections, int version) throws RBSException, SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        this.verifyNSObject();
        if (collections != null) {
            String ownerName = this.ns.getUnrootedName(this.nsObj.getObjectEntry());
            for (int i = 0; i < collections.length; ++i) {
                RBSRights entryRights;
                ObjectEntry collectionOE = collections[i].getObjectEntry();
                String collectionName = this.ns.getUnrootedName(collectionOE);
                NSObject collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName);
                if (collectionObj == null) {
                    collectionObj = this.ns.getDetails(collectionOE);
                    this.otherNSObjectsTable.put(collectionName, collectionObj);
                }
                if (version == 1) {
                    NSModel.removeDNRelation(collectionObj, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)collectionOE, (String)"Owner"), "rbsOwnedCollections");
                } else {
                    NSModel.removeDNRelation(collectionObj, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)collectionOE, (String)"Owner"), "rbsOwnedCollections2");
                }
                if (this.isNVDS) {
                    entryRights = new RBSNVDSRights(ownerName, "", "wholeSubtree", "", "", 1L, 16L);
                    RBSUtil.removeNVDSACLRights(collectionObj, entryRights);
                    continue;
                }
                entryRights = new RBSRights(ownerName, "[Entry Rights]", RBSUtil.setInheritableBit("[Entry Rights]", RBSUtil.setRBSBit(16L), "true"));
                RBSUtil.removeACLRights(collectionObj, entryRights);
            }
        }
    }

    public RBSAssociation[] getAllRoleAssociations() throws SPIException, RBSException, NamespaceException {
        return this.getAllRoleAssociationsMain(1);
    }

    public RBSAssociation[] getAllRoleAssociations2() throws SPIException, RBSException, NamespaceException {
        return this.getAllRoleAssociationsMain(2);
    }

    private RBSAssociation[] getAllRoleAssociationsMain(int version) throws SPIException {
        RBSAssociation[] containerAssociation;
        RBSAssociation[] groupAssociation;
        this.verifyNSObject();
        Hashtable<String, String> roles = new Hashtable<String, String>();
        Vector<RBSAssociation> vector = new Vector<RBSAssociation>();
        RBSAssociation[] directAssociation = this.getFromDirect(this.oe, version);
        if (directAssociation != null) {
            for (int i = 0; i < directAssociation.length; ++i) {
                String name = this.ns.getUnrootedName(directAssociation[i].getRole().getObjectEntry());
                if (roles.get(name) != null) continue;
                roles.put(name, name);
                vector.add(directAssociation[i]);
            }
        }
        if ((groupAssociation = this.getFromGroups(version)) != null) {
            for (int i = 0; i < groupAssociation.length; ++i) {
                String name = this.ns.getUnrootedName(groupAssociation[i].getRole().getObjectEntry());
                if (roles.get(name) != null) continue;
                roles.put(name, name);
                vector.add(groupAssociation[i]);
            }
        }
        if ((containerAssociation = this.getFromContainer("container", version)) != null) {
            for (int i = 0; i < containerAssociation.length; ++i) {
                String name = this.ns.getUnrootedName(containerAssociation[i].getRole().getObjectEntry());
                if (roles.get(name) != null) continue;
                roles.put(name, name);
                vector.add(containerAssociation[i]);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] relations = new RBSAssociation[vector.size()];
        vector.copyInto(relations);
        return relations;
    }

    public RBSAssociation[] getDirectRoleAssociations() throws SPIException, RBSException, NamespaceException {
        return this.getDirectRoleAssociationsMain(1);
    }

    public RBSAssociation[] getDirectRoleAssociations2() throws SPIException, RBSException, NamespaceException {
        return this.getDirectRoleAssociationsMain(2);
    }

    private RBSAssociation[] getDirectRoleAssociationsMain(int version) throws SPIException {
        return this.getFromDirect(this.oe, version);
    }

    public void setDirectRoleAssociations(RBSAssociation[] roles, String dynamicGroupSearchType) throws RBSException, SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, IOException, JDOMException {
        this.setDirectRoleAssociationsMain(roles, dynamicGroupSearchType, 1);
    }

    public void setDirectRoleAssociations2(RBSAssociation[] roles, String dynamicGroupSearchType) throws RBSException, SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, IOException, JDOMException {
        this.setDirectRoleAssociationsMain(roles, dynamicGroupSearchType, 2);
    }

    private void setDirectRoleAssociationsMain(RBSAssociation[] roles, String dynamicGroupSearchType, int version) throws RBSException, SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, IOException, JDOMException {
        if (version == 1) {
            this.deleteDirectRoleAssociations(this.getDirectRoleAssociations(), dynamicGroupSearchType);
            this.addDirectRoleAssociations(roles, dynamicGroupSearchType);
        } else {
            this.deleteDirectRoleAssociations2(this.getDirectRoleAssociations2(), dynamicGroupSearchType);
            this.addDirectRoleAssociations2(roles, dynamicGroupSearchType);
        }
    }

    public void addDirectRoleAssociations(RBSAssociation[] assc, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, SnapinVetoException, RBSException, IOException, JDOMException {
        this.addDirectRoleAssociationsMain(assc, dynamicGroupSearchType, 1);
    }

    public void addDirectRoleAssociations2(RBSAssociation[] assc, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, SnapinVetoException, RBSException, IOException, JDOMException {
        this.addDirectRoleAssociationsMain(assc, dynamicGroupSearchType, 2);
    }

    private void addDirectRoleAssociationsMain(RBSAssociation[] assc, String dynamicGroupSearchType, int version) throws SPIException, NamespaceException, ComponentCreationException, SnapinVetoException, RBSException, IOException, JDOMException {
        this.verifyNSObject();
        if (assc == null) {
            return;
        }
        Hashtable<String, String> secondaryRightsTable = new Hashtable<String, String>();
        if (this.isNVDS && !RBSUtil.doesObjectHaveRBSAuxRoleInfoClass(this.nsObj)) {
            RBSUtil.addRBSAuxRoleInfoClass(this.nsObj);
        }
        String memberName = this.ns.getUnrootedName(this.getObjectEntry());
        for (int i = 0; i < assc.length; ++i) {
            RBSObject[] rbsObjects;
            RBSRights attrRights;
            NSObject collectionObj;
            String collectionName;
            ObjectEntry collectionOE;
            RBSRights attrRights2;
            String trustee;
            NSObject collectionObj2;
            String collectionName2;
            ObjectEntry collectionOE2;
            Document doc;
            String name;
            String compareStr;
            String otherOT;
            NSObject otherObj;
            Enumeration myenum;
            RBSScope rbsScope = null;
            RBACRole rbacRole = null;
            ObjectEntry roleOE = assc[i].getRole().getObjectEntry();
            String roleName = this.ns.getUnrootedName(roleOE);
            NSObject roleObj = (NSObject)this.otherNSObjectsTable.get(roleName);
            if (roleObj == null) {
                roleObj = this.ns.getDetails(roleOE);
                this.otherNSObjectsTable.put(roleName, roleObj);
            }
            boolean selfProvisioning = RBSUtil.getSelfProvisioningFromParameters(roleOE, roleObj);
            ObjectEntry scopeOE = assc[i].getScope();
            String scopeName = null;
            String scopeOT = scopeOE.getObjectType().getName();
            scopeName = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)roleOE, (String)"Top")) ? "[root]" : this.ns.getUnrootedName(scopeOE);
            NSObject scopeObj = (NSObject)this.otherNSObjectsTable.get(scopeName);
            if (scopeObj == null) {
                scopeObj = this.ns.getDetails(scopeOE);
                this.otherNSObjectsTable.put(scopeName, scopeObj);
            }
            RBSUtil.createAssociation(assc[i], this.nsObj, roleObj);
            RBSRole rbsRole = new RBSRole(roleObj);
            if (this.isNVDS) {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    otherObj = (NSObject)myenum.nextElement();
                    otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase(compareStr = "rbacRole")) continue;
                    RBACRole role = new RBACRole(otherObj);
                    ObjectEntry rbacRoleParentOE = otherObj.getObjectEntry().getParent();
                    String rbacRoleParent = this.ns.getUnrootedName(rbacRoleParentOE);
                    if (!roleName.equalsIgnoreCase(rbacRoleParent)) continue;
                    String rbacRoleString = role.getContext();
                    if (rbacRoleString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !role.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbacRole = role;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbacRoleString) || !role.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbacRole = role;
                    break;
                }
                if (rbacRole == null) {
                    NSObject rbacRoleObj = null;
                    rbacRole = rbsRole.getRBACRoleObject(scopeOE, assc[i].getInheritanceScope());
                    if (rbacRole != null) {
                        rbacRoleObj = this.ns.getDetails(rbacRole.getObjectEntry());
                        rbacRole = new RBACRole(rbacRoleObj);
                        ObjectEntry rbacRoleOE = rbacRoleObj.getObjectEntry();
                        String rbacRoleName = this.ns.getUnrootedName(rbacRoleOE);
                        this.otherNSObjectsTable.put(rbacRoleName, rbacRoleObj);
                    } else if (assc[i].isRightsSet()) {
                        name = null;
                        name = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : scopeOE.getName();
                        rbacRoleObj = rbsRole.createRBACRoleObject(rbsRole.getObjectEntry(), name);
                        rbacRole = new RBACRole(rbacRoleObj);
                        rbacRole.setContext(scopeOE);
                        rbacRole.addRoleMember(rbsRole.getObjectEntry());
                        doc = new Document(new Element("rbs-xml-info"));
                        doc.getRootElement().addContent(new Element("rbs-Inheritable").setText(assc[i].getInheritanceScope()));
                        rbacRole.setrbsXMLInfo(doc);
                        collectionOE2 = roleOE.getParent();
                        collectionName2 = this.ns.getUnrootedName(collectionOE2);
                        collectionObj2 = (NSObject)this.otherNSObjectsTable.get(collectionName2);
                        if (collectionObj2 == null) {
                            collectionObj2 = this.ns.getDetails(collectionOE2);
                            this.otherNSObjectsTable.put(collectionName2, collectionObj2);
                        }
                        trustee = this.ns.getUnrootedName(rbacRole.getObjectEntry());
                        attrRights2 = new RBSNVDSRights(trustee, "", "wholeSubtree", "", "any", 0L, 2L);
                        RBSUtil.addNVDSACLRights(collectionObj2, attrRights2);
                        ObjectEntry rbacRoleOE = rbacRoleObj.getObjectEntry();
                        String rbacRoleName = this.ns.getUnrootedName(rbacRoleOE);
                        this.otherNSObjectsTable.put(rbacRoleName, rbacRoleObj);
                    }
                }
                if (assc[i].isRightsSet()) {
                    rbacRole.addStaticRoleMember(this.nsObj.getObjectEntry());
                } else {
                    collectionOE = roleOE.getParent();
                    collectionName = this.ns.getUnrootedName(collectionOE);
                    collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName);
                    if (collectionObj == null) {
                        collectionObj = this.ns.getDetails(collectionOE);
                        this.otherNSObjectsTable.put(collectionName, collectionObj);
                    }
                    attrRights = new RBSNVDSRights(memberName, "", "wholeSubtree", "", "any", 0L, 2L);
                    RBSUtil.addNVDSACLRights(collectionObj, attrRights);
                }
            } else if (RBSUtil.checkSpecialTypes(this.getObjectEntry(), dynamicGroupSearchType)) {
                ObjectEntry collectionOE3 = roleOE.getParent();
                String collectionName3 = this.ns.getUnrootedName(collectionOE3);
                NSObject collectionObj3 = (NSObject)this.otherNSObjectsTable.get(collectionName3);
                if (collectionObj3 == null) {
                    collectionObj3 = this.ns.getDetails(collectionOE3);
                    this.otherNSObjectsTable.put(collectionName3, collectionObj3);
                }
                if (this.getObjectEntry().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)this.getObjectEntry(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(this.getObjectEntry())) {
                    RBSUtil.addACLRights(collectionObj3, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 0x20000002L, "true"))));
                    if (version == 1) {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(0x20000002L)));
                    } else {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(0x20000002L)));
                    }
                    RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"Member"), RBSUtil.setRBSBit(0x20000002L)));
                } else if (RBSUtil.checkIfNestedGroupAuxExist(this.getObjectEntry())) {
                    RBSUtil.addACLRights(collectionObj3, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", -2147483646L, "true"))));
                    if (version == 1) {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(-2147483646L)));
                    } else {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(-2147483646L)));
                    }
                    RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"Member"), RBSUtil.setRBSBit(-2147483646L)));
                } else {
                    RBSUtil.addACLRights(collectionObj3, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true"))));
                    if (version == 1) {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(2L)));
                    } else {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(2L)));
                    }
                    if (this.getObjectEntry().getObjectType().getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)roleOE, (String)"Organizational Role"))) {
                        RBSUtil.addACLRights(this.nsObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Role Occupant"), RBSUtil.setRBSBit(2L)));
                    }
                }
            } else {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    otherObj = (NSObject)myenum.nextElement();
                    otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase(compareStr = version == 1 ? "rbsScope" : "rbsScope2")) continue;
                    RBSScope scope = new RBSScope(otherObj);
                    ObjectEntry rbsScopeParentOE = otherObj.getObjectEntry().getParent();
                    String rbsScopeParent = this.ns.getUnrootedName(rbsScopeParentOE);
                    if (!roleName.equalsIgnoreCase(rbsScopeParent)) continue;
                    String rbsScopeString = scope.getContext();
                    if (rbsScopeString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbsScope = scope;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbsScopeString) || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbsScope = scope;
                    break;
                }
                if (rbsScope == null) {
                    NSObject rbsScopeObj = null;
                    rbsScope = rbsRole.getScopeObject(scopeOE, assc[i].getInheritanceScope());
                    if (rbsScope != null) {
                        rbsScopeObj = this.ns.getDetails(rbsScope.getObjectEntry());
                        rbsScope = new RBSScope(rbsScopeObj);
                        ObjectEntry rbsScopeOE = rbsScopeObj.getObjectEntry();
                        String rbsScopeName = this.ns.getUnrootedName(rbsScopeOE);
                        this.otherNSObjectsTable.put(rbsScopeName, rbsScopeObj);
                    } else if (assc[i].isRightsSet()) {
                        block75: {
                            name = null;
                            name = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : scopeOE.getName();
                            rbsScopeObj = rbsRole.createRBSScopeObject(rbsRole.getObjectEntry(), name);
                            rbsScope = new RBSScope(rbsScopeObj);
                            rbsScope.setContext(scopeOE);
                            doc = new Document(new Element("rbs-xml-info"));
                            doc.getRootElement().addContent(new Element("rbs-Inheritable").setText(assc[i].getInheritanceScope()));
                            try {
                                rbsScope.setrbsXMLInfo(doc);
                            }
                            catch (SPIException e) {
                                if (e instanceof UniqueSPIException && e.getErrorCode() == -603) break block75;
                                throw e;
                            }
                        }
                        collectionOE2 = roleOE.getParent();
                        collectionName2 = this.ns.getUnrootedName(collectionOE2);
                        collectionObj2 = (NSObject)this.otherNSObjectsTable.get(collectionName2);
                        if (collectionObj2 == null) {
                            collectionObj2 = this.ns.getDetails(collectionOE2);
                            this.otherNSObjectsTable.put(collectionName2, collectionObj2);
                        }
                        trustee = this.ns.getUnrootedName(rbsScope.getObjectEntry());
                        attrRights2 = new RBSRights(trustee, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                        RBSUtil.addACLRights(collectionObj2, attrRights2);
                        ObjectEntry rbsScopeOE = rbsScopeObj.getObjectEntry();
                        String rbsScopeName = this.ns.getUnrootedName(rbsScopeOE);
                        this.otherNSObjectsTable.put(rbsScopeName, rbsScopeObj);
                    }
                }
                if (assc[i].isRightsSet()) {
                    rbsScope.addMember(this.nsObj);
                } else {
                    collectionOE = roleOE.getParent();
                    collectionName = this.ns.getUnrootedName(collectionOE);
                    collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName);
                    if (collectionObj == null) {
                        collectionObj = this.ns.getDetails(collectionOE);
                        this.otherNSObjectsTable.put(collectionName, collectionObj);
                    }
                    attrRights = new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                    RBSUtil.addACLRights(collectionObj, attrRights);
                }
            }
            if (!assc[i].isRightsSet() || (rbsObjects = rbsRole.getContent()) == null) continue;
            for (int j = 0; j < rbsObjects.length; ++j) {
                Object[] taskValues = ((RBSTask)rbsObjects[j]).getRights();
                if (taskValues == null) continue;
                Vector<Object> selfValues = new Vector<Object>();
                Vector<Object> adminValues = new Vector<Object>();
                for (int k = 0; k < taskValues.length; ++k) {
                    boolean dynamicGroupBit = false;
                    boolean nestedGroupBit = false;
                    if (selfProvisioning) {
                        taskValues[k].setSubjectName("[This]");
                    } else if (this.isNVDS) {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(rbacRole.getObjectEntry()));
                        if (((RBSNVDSRights)taskValues[k]).getScopeName() == null) {
                            ((RBSNVDSRights)taskValues[k]).setScopeName(assc[i].getInheritanceScope());
                        }
                        if (((RBSRights)taskValues[k]).getProtectedAttrName().equalsIgnoreCase("[Entry Rights]")) {
                            ((RBSRights)taskValues[k]).setProtectedAttrName("");
                            ((RBSNVDSRights)taskValues[k]).setModifier(1L);
                        }
                        if (((RBSRights)taskValues[k]).getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]")) {
                            ((RBSRights)taskValues[k]).setProtectedAttrName("any");
                        }
                    } else if (RBSUtil.checkSpecialTypes(assc[i].getMember(), dynamicGroupSearchType)) {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(assc[i].getMember()));
                        if (assc[i].getMember().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)this.getObjectEntry(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(assc[i].getMember())) {
                            dynamicGroupBit = true;
                        }
                        if (RBSUtil.checkIfNestedGroupAuxExist(assc[i].getMember())) {
                            nestedGroupBit = true;
                        }
                    } else {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(rbsScope.getObjectEntry()));
                    }
                    String attribute = ((RBSRights)taskValues[k]).getProtectedAttrName();
                    long privileges = ((RBSRights)taskValues[k]).getPrivileges();
                    if (assc[i].getInheritanceScope().equals("true")) {
                        if (this.isNVDS) {
                            ((RBSNVDSRights)taskValues[k]).setScopeName("wholeSubtree");
                        } else {
                            privileges = RBSUtil.setInheritableBit(attribute, privileges, "true");
                        }
                    } else if (assc[i].getInheritanceScope().equals("false")) {
                        if (this.isNVDS) {
                            ((RBSNVDSRights)taskValues[k]).setScopeName("baseObject");
                        } else {
                            privileges = RBSUtil.setInheritableBit(attribute, privileges, "false");
                        }
                    }
                    if (selfProvisioning) {
                        if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                            ((RBSRights)taskValues[k]).setPrivileges(privileges -= Integer.MIN_VALUE);
                            selfValues.add(taskValues[k]);
                            continue;
                        }
                        ((RBSRights)taskValues[k]).setPrivileges(privileges);
                        adminValues.add(taskValues[k]);
                        continue;
                    }
                    if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) continue;
                    if (dynamicGroupBit) {
                        privileges |= 0x20000000L;
                    }
                    if (nestedGroupBit) {
                        privileges |= Integer.MIN_VALUE;
                    }
                    ((RBSRights)taskValues[k]).setPrivileges(privileges);
                    adminValues.add(taskValues[k]);
                }
                if (selfProvisioning) {
                    taskValues = new RBSRights[selfValues.size()];
                    selfValues.copyInto(taskValues);
                    if (taskValues.length == 0) {
                        taskValues = new RBSRights[adminValues.size()];
                        adminValues.copyInto(taskValues);
                    } else if (taskValues.length == 1 && ((RBSRights)taskValues[0]).getProtectedAttrName().equals("[No Self Rights Assignment]")) {
                        taskValues = new RBSRights[]{};
                    }
                } else if (this.isNVDS) {
                    taskValues = new RBSNVDSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                } else {
                    taskValues = new RBSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                }
                if (this.isNVDS) {
                    RBSUtil.addNVDSACLValuesToScope(scopeObj, (RBSNVDSRights[])taskValues);
                    continue;
                }
                RBSUtil.addACLValuesToScope(scopeObj, (RBSRights[])taskValues);
            }
            Element[] secondarySetElements = RBSUtil.getSecondarySetElements(rbsObjects);
            if (secondarySetElements == null) continue;
            ObjectEntry subjectOE = null;
            subjectOE = this.isNVDS ? (rbacRole == null ? assc[i].getMember() : rbacRole.getObjectEntry()) : (rbsScope == null ? assc[i].getMember() : rbsScope.getObjectEntry());
            String subjectName = this.ns.getUnrootedName(subjectOE);
            if (secondaryRightsTable.get(subjectName) != null) continue;
            secondaryRightsTable.put(subjectName, subjectName);
            RBSUtil.setSecondaryRights(secondarySetElements, subjectOE, this.otherNSObjectsTable);
        }
    }

    public void deleteDirectRoleAssociations(RBSAssociation[] assc, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, RBSException, SnapinVetoException, JDOMException, IOException {
        this.deleteDirectRoleAssociationsMain(assc, dynamicGroupSearchType, 1);
    }

    public void deleteDirectRoleAssociations2(RBSAssociation[] assc, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, RBSException, SnapinVetoException, JDOMException, IOException {
        this.deleteDirectRoleAssociationsMain(assc, dynamicGroupSearchType, 2);
    }

    private void deleteDirectRoleAssociationsMain(RBSAssociation[] assc, String dynamicGroupSearchType, int version) throws SPIException, NamespaceException, ComponentCreationException, RBSException, SnapinVetoException, JDOMException, IOException {
        this.verifyNSObject();
        if (assc == null) {
            return;
        }
        Hashtable<String, String> secondaryRightsTable = new Hashtable<String, String>();
        String memberName = this.ns.getUnrootedName(this.getObjectEntry());
        for (int i = 0; i < assc.length; ++i) {
            RBSObject[] rbsObjects;
            NSObject otherObj;
            Enumeration myenum;
            RBSScope rbsScope = null;
            RBACRole rbacRole = null;
            ObjectEntry roleOE = assc[i].getRole().getObjectEntry();
            String roleName = this.ns.getUnrootedName(roleOE);
            NSObject roleObj = (NSObject)this.otherNSObjectsTable.get(roleName);
            if (roleObj == null) {
                roleObj = this.ns.getDetails(roleOE);
                this.otherNSObjectsTable.put(roleName, roleObj);
            }
            boolean selfProvisioning = RBSUtil.getSelfProvisioningFromParameters(roleOE, roleObj);
            ObjectEntry scopeOE = assc[i].getScope();
            String scopeName = null;
            String scopeOT = scopeOE.getObjectType().getName();
            scopeName = scopeOT.equals(SchemaUtil.translateNDAPClass((ObjectEntry)scopeOE, (String)"Top")) ? "[root]" : this.ns.getUnrootedName(scopeOE);
            NSObject scopeObj = (NSObject)this.otherNSObjectsTable.get(scopeName);
            if (scopeObj == null) {
                scopeObj = this.ns.getDetails(scopeOE);
                this.otherNSObjectsTable.put(scopeName, scopeObj);
            }
            RBSUtil.deleteAssociation(assc[i], this.nsObj, roleObj);
            RBSRole rbsRole = (RBSRole)this.roleHashMap.get(roleName);
            if (rbsRole == null) {
                rbsRole = new RBSRole(roleObj);
                this.roleHashMap.put(roleName, rbsRole);
            }
            if (this.isNVDS) {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    String compareStr;
                    otherObj = (NSObject)myenum.nextElement();
                    String otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase(compareStr = "rbacRole")) continue;
                    RBACRole role = new RBACRole(otherObj);
                    ObjectEntry rbacRoleParentOE = otherObj.getObjectEntry().getParent();
                    String rbacRoleParent = this.ns.getUnrootedName(rbacRoleParentOE);
                    if (!roleName.equalsIgnoreCase(rbacRoleParent)) continue;
                    String rbacRoleString = role.getContext();
                    if (rbacRoleString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !role.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbacRole = role;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbacRoleString) || !role.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbacRole = role;
                    break;
                }
                if (rbacRole == null && assc[i].isRightsSet() && (rbacRole = rbsRole.getRBACRoleObject(scopeOE, assc[i].getInheritanceScope())) != null) {
                    NSObject rbacRoleObj = this.ns.getDetails(rbacRole.getObjectEntry());
                    rbacRole.setNSObject(rbacRoleObj);
                    ObjectEntry rbacRoleOE = rbacRoleObj.getObjectEntry();
                    String rbacRoleName = this.ns.getUnrootedName(rbacRoleOE);
                    this.otherNSObjectsTable.put(rbacRoleName, rbacRoleObj);
                }
                if (rbacRole != null && assc[i].isRightsSet()) {
                    rbacRole.deleteStaticRoleMember(this.nsObj.getObjectEntry());
                }
            } else if (RBSUtil.checkSpecialTypes(this.getObjectEntry(), dynamicGroupSearchType)) {
                ObjectEntry collectionOE = roleOE.getParent();
                String collectionName = this.ns.getUnrootedName(collectionOE);
                NSObject collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName);
                if (collectionObj == null) {
                    collectionObj = this.ns.getDetails(collectionOE);
                    this.otherNSObjectsTable.put(collectionName, collectionObj);
                }
                if (this.getObjectEntry().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)this.getObjectEntry(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(this.getObjectEntry())) {
                    RBSUtil.removeACLRights(collectionObj, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 0x20000002L, "true"))));
                    if (version == 1) {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(0x20000002L)));
                    } else {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(0x20000002L)));
                    }
                    RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Member"), RBSUtil.setRBSBit(0x20000002L)));
                } else if (RBSUtil.checkIfNestedGroupAuxExist(this.getObjectEntry())) {
                    RBSUtil.removeACLRights(collectionObj, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", -2147483646L, "true"))));
                    if (version == 1) {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(-2147483646L)));
                    } else {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(-2147483646L)));
                    }
                    RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Member"), RBSUtil.setRBSBit(-2147483646L)));
                } else {
                    RBSUtil.removeACLRights(collectionObj, new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true"))));
                    if (version == 1) {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles", RBSUtil.setRBSBit(2L)));
                    } else {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, "rbsAssignedRoles2", RBSUtil.setRBSBit(2L)));
                    }
                    if (this.getObjectEntry().getObjectType().getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Organizational Role"))) {
                        RBSUtil.removeACLRights(this.nsObj, new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Role Occupant"), RBSUtil.setRBSBit(2L)));
                    }
                }
            } else {
                myenum = this.otherNSObjectsTable.elements();
                while (myenum.hasMoreElements()) {
                    String compareStr;
                    otherObj = (NSObject)myenum.nextElement();
                    String otherOT = otherObj.getObjectEntry().getObjectType().getName();
                    if (!otherOT.equalsIgnoreCase(compareStr = version == 1 ? "rbsScope" : "rbsScope2")) continue;
                    RBSScope scope = new RBSScope(otherObj);
                    ObjectEntry rbsScopeParentOE = otherObj.getObjectEntry().getParent();
                    String rbsScopeParent = this.ns.getUnrootedName(rbsScopeParentOE);
                    if (!roleName.equalsIgnoreCase(rbsScopeParent)) continue;
                    String rbsScopeString = scope.getContext();
                    if (rbsScopeString.equalsIgnoreCase("")) {
                        if (!scopeName.equalsIgnoreCase("[root]") || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                        rbsScope = scope;
                        break;
                    }
                    if (!scopeName.equalsIgnoreCase(rbsScopeString) || !scope.getInheritable().equalsIgnoreCase(assc[i].getInheritanceScope())) continue;
                    rbsScope = scope;
                    break;
                }
                if (rbsScope == null && assc[i].isRightsSet() && (rbsScope = rbsRole.getScopeObject(scopeOE, assc[i].getInheritanceScope())) != null) {
                    NSObject rbsScopeObj = this.ns.getDetails(rbsScope.getObjectEntry());
                    rbsScope.setNSObject(rbsScopeObj);
                    ObjectEntry rbsScopeOE = rbsScopeObj.getObjectEntry();
                    String rbsScopeName = this.ns.getUnrootedName(rbsScopeOE);
                    this.otherNSObjectsTable.put(rbsScopeName, rbsScopeObj);
                }
                if (rbsScope != null && assc[i].isRightsSet()) {
                    rbsScope.deleteMember(this.nsObj);
                }
            }
            if (!assc[i].isRightsSet()) {
                RBSAssociatedObject memberAO = new RBSAssociatedObject(this.nsObj);
                RBSAssociation[] memberAssoc = memberAO.getDirectRoleAssociations2();
                int countThis = 0;
                int countAll = 0;
                if (memberAssoc != null) {
                    for (int m = 0; m < memberAssoc.length; ++m) {
                        if (memberAssoc[m].isRightsSet()) continue;
                        ++countAll;
                    }
                }
                for (int n = 0; n < assc.length; ++n) {
                    if (!memberName.equalsIgnoreCase(this.ns.getUnrootedName(assc[n].getMember())) || assc[n].isRightsSet()) continue;
                    ++countThis;
                }
                if (countAll <= countThis) {
                    RBSRights attrRights;
                    ObjectEntry collectionOE = roleOE.getParent();
                    String collectionName = this.ns.getUnrootedName(collectionOE);
                    NSObject collectionObj = (NSObject)this.otherNSObjectsTable.get(collectionName);
                    if (collectionObj == null) {
                        collectionObj = this.ns.getDetails(collectionOE);
                        this.otherNSObjectsTable.put(collectionName, collectionObj);
                    }
                    if (this.isNVDS) {
                        attrRights = new RBSNVDSRights(memberName, "", "wholeSubtree", "", "any", 0L, 2L);
                        RBSUtil.removeNVDSACLRights(collectionObj, attrRights);
                    } else {
                        attrRights = new RBSRights(memberName, "[All Attributes Rights]", RBSUtil.setRBSBit(RBSUtil.setInheritableBit("[All Attributes Rights]", 2L, "true")));
                        RBSUtil.removeACLRights(collectionObj, attrRights);
                    }
                }
            }
            if (!assc[i].isRightsSet() || this.isNVDS || !selfProvisioning && !RBSUtil.checkSpecialTypes(assc[i].getMember(), dynamicGroupSearchType) || (rbsObjects = rbsRole.getContent()) == null) continue;
            for (int j = 0; j < rbsObjects.length; ++j) {
                Object[] taskValues = ((RBSTask)rbsObjects[j]).getRights();
                if (taskValues == null) continue;
                Vector<Object> selfValues = new Vector<Object>();
                Vector<Object> adminValues = new Vector<Object>();
                for (int k = 0; k < taskValues.length; ++k) {
                    boolean dynamicGroupBit = false;
                    boolean nestedGroupBit = false;
                    if (selfProvisioning) {
                        taskValues[k].setSubjectName("[This]");
                    } else if (RBSUtil.checkSpecialTypes(assc[i].getMember(), dynamicGroupSearchType)) {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(assc[i].getMember()));
                        if (assc[i].getMember().getObjectType().getName().equals(SchemaUtil.translateNDAPClass((ObjectEntry)this.getObjectEntry(), (String)"dynamicGroup")) || RBSUtil.checkIfDynamicGroupAuxExist(assc[i].getMember())) {
                            dynamicGroupBit = true;
                        }
                        if (RBSUtil.checkIfNestedGroupAuxExist(assc[i].getMember())) {
                            nestedGroupBit = true;
                        }
                    } else {
                        ((RBSRights)taskValues[k]).setSubjectName(this.ns.getUnrootedName(assc[i].getMember()));
                    }
                    String attribute = ((RBSRights)taskValues[k]).getProtectedAttrName();
                    long privileges = ((RBSRights)taskValues[k]).getPrivileges();
                    privileges = assc[i].getInheritanceScope().equals("true") ? RBSUtil.setInheritableBit(attribute, privileges, "true") : RBSUtil.setInheritableBit(attribute, privileges, "false");
                    privileges = RBSUtil.setRBSBit(privileges);
                    if (selfProvisioning) {
                        if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                            ((RBSRights)taskValues[k]).setPrivileges(privileges -= Integer.MIN_VALUE);
                            selfValues.add(taskValues[k]);
                            continue;
                        }
                        ((RBSRights)taskValues[k]).setPrivileges(privileges);
                        adminValues.add(taskValues[k]);
                        continue;
                    }
                    if ((privileges & Integer.MIN_VALUE) == Integer.MIN_VALUE) continue;
                    if (dynamicGroupBit) {
                        privileges |= 0x20000000L;
                    }
                    if (nestedGroupBit) {
                        privileges |= Integer.MIN_VALUE;
                    }
                    ((RBSRights)taskValues[k]).setPrivileges(privileges);
                    adminValues.add(taskValues[k]);
                }
                if (selfProvisioning) {
                    taskValues = new RBSRights[selfValues.size()];
                    selfValues.copyInto(taskValues);
                    if (taskValues.length == 0) {
                        taskValues = new RBSRights[adminValues.size()];
                        adminValues.copyInto(taskValues);
                    } else if (taskValues.length == 1 && ((RBSRights)taskValues[0]).getProtectedAttrName().equals("[No Self Rights Assignment]")) {
                        taskValues = new RBSRights[]{};
                    }
                } else {
                    taskValues = new RBSRights[adminValues.size()];
                    adminValues.copyInto(taskValues);
                }
                RBSUtil.removeACLValuesFromScope(scopeObj, (RBSRights[])taskValues);
            }
            Element[] secondarySetElements = RBSUtil.getSecondarySetElements(rbsObjects);
            if (secondarySetElements == null) continue;
            ObjectEntry subjectOE = null;
            subjectOE = rbsScope == null ? assc[i].getMember() : rbsScope.getObjectEntry();
            String subjectName = this.ns.getUnrootedName(subjectOE);
            if (secondaryRightsTable.get(subjectName) != null) continue;
            secondaryRightsTable.put(subjectName, subjectName);
            RBSUtil.removeSecondaryRights(secondarySetElements, subjectOE, this.otherNSObjectsTable);
        }
    }

    public void update() throws SPIException, SnapinVetoException, NamespaceException {
        super.update();
        Enumeration myenum = this.otherNSObjectsTable.elements();
        while (myenum.hasMoreElements()) {
            NSObject roleObj = (NSObject)myenum.nextElement();
            this.ns.update(roleObj);
        }
        Enumeration enumer = this.otherNSObjectsTable.elements();
        while (enumer.hasMoreElements()) {
            NSObject roleObj = (NSObject)enumer.nextElement();
            String objectType = roleObj.getObjectEntry().getObjectType().getName();
            if (!objectType.equalsIgnoreCase("rbsRole") && !objectType.equalsIgnoreCase("rbsRole2")) continue;
            RBSRole rbsRole = new RBSRole(roleObj);
            if (this.isNVDS) {
                rbsRole.removeUnusedRBACRoleObjects();
                continue;
            }
            rbsRole.removeUnusedRBSScopeObjects();
        }
    }

    private RBSAssociation[] getFromDirect(ObjectEntry directOE, int version) throws SPIException {
        String thisName = this.ns.getUnrootedName(directOE);
        ObjectEntry scopeOE = null;
        String inherit = "false";
        boolean rightsSet = false;
        Vector<RBSAssociation> v = new Vector<RBSAssociation>(10);
        Enumeration valueSet = version == 1 ? NSModel.getAttribute(directOE, null, "rbsAssignedRoles") : NSModel.getAttribute(directOE, null, "rbsAssignedRoles2");
        if (valueSet != null) {
            while (valueSet.hasMoreElements()) {
                TypedNameFacade facade = (TypedNameFacade)((ValueList)valueSet.nextElement()).createFacade();
                String roleName = facade.getObject();
                ObjectEntry roleOE = this.ns.getObjectEntry(directOE.getRoot(), roleName);
                ObjectAttribute memberAttrib = this.ns.getAttribute(roleOE, "rbsMember");
                ObjectAttribute trusteeAttrib = this.ns.getAttribute(roleOE, "rbsTrusteeOf");
                if (memberAttrib == null) continue;
                Enumeration memberSet = memberAttrib.getValueComponents();
                while (memberSet.hasMoreElements()) {
                    TypedNameFacade memberFacade = (TypedNameFacade)((ValueList)memberSet.nextElement()).createFacade();
                    if (!thisName.equalsIgnoreCase(memberFacade.getObject())) continue;
                    long index = memberFacade.getInterval();
                    if (trusteeAttrib == null) continue;
                    Enumeration trusteeSet = trusteeAttrib.getValueComponents();
                    boolean found = false;
                    while (trusteeSet.hasMoreElements()) {
                        TypedNameFacade trusteeFacade = (TypedNameFacade)((ValueList)trusteeSet.nextElement()).createFacade();
                        if (index != trusteeFacade.getInterval()) continue;
                        found = true;
                        String objName = trusteeFacade.getObject();
                        scopeOE = objName.startsWith(".") && objName.endsWith(".") ? directOE.getRoot() : this.ns.getObjectEntry(directOE.getRoot(), trusteeFacade.getObject());
                        inherit = this.isNVDS ? RBSUtil.getNVDSInheritedBitset(trusteeFacade.getLevel()) : RBSUtil.isInheritedBitset(trusteeFacade.getLevel());
                        rightsSet = version == 1 ? true : RBSUtil.isRightsSet(trusteeFacade.getLevel());
                        break;
                    }
                    if (!found) continue;
                    v.addElement(new RBSAssociation(directOE, new RBSRole(roleOE), scopeOE, index, inherit, rightsSet));
                }
            }
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] relations = new RBSAssociation[v.size()];
        v.copyInto(relations);
        return relations;
    }

    private RBSAssociation[] getFromGroups(int version) throws SPIException {
        this.verifyNSObject();
        ObjectEntry[] groups = NSModel.getDN(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Group Membership"));
        if (groups != null) {
            Vector<RBSAssociation> v = new Vector<RBSAssociation>(20);
            for (int i = 0; i < groups.length; ++i) {
                RBSAssociation[] relations = this.getFromDirect(groups[i], version);
                if (relations == null) continue;
                for (int j = 0; j < relations.length; ++j) {
                    v.addElement(relations[j]);
                }
            }
            if (v.size() == 0) {
                return null;
            }
            Object[] rval = new RBSAssociation[v.size()];
            v.copyInto(rval);
            return rval;
        }
        return null;
    }

    private RBSAssociation[] getFromContainer(String levelUp, int version) throws SPIException {
        RBSAssociation[] association;
        Object[] relations;
        ObjectEntry currentOE;
        this.verifyNSObject();
        Vector<Object> vector = new Vector<Object>();
        if (levelUp.equalsIgnoreCase("root")) {
            for (currentOE = this.oe.getParent(); currentOE != null; currentOE = currentOE.getParent()) {
                relations = this.getFromDirect(currentOE, version);
                if (relations == null) continue;
                for (int i = 0; i < relations.length; ++i) {
                    vector.addElement(relations[i]);
                }
            }
        } else if (levelUp.equalsIgnoreCase("partition")) {
            while (currentOE != null) {
                relations = this.getFromDirect(currentOE, version);
                if (relations != null) {
                    for (int i = 0; i < relations.length; ++i) {
                        vector.addElement(relations[i]);
                    }
                }
                if (!ObjectFlags.isPartition((long)currentOE.getObjectFlags())) {
                    currentOE = currentOE.getParent();
                    continue;
                }
                break;
            }
        } else if (currentOE != null && (association = this.getFromDirect(currentOE, version)) != null) {
            for (int i = 0; i < association.length; ++i) {
                vector.add(association[i]);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        relations = new RBSAssociation[vector.size()];
        vector.copyInto(relations);
        return relations;
    }

    private RBSAssociation[] getFromDynamicGroups(String dynamicGroupDiscoveryDomain, String dynamicGroupSearchType, int version) throws SPIException, NamespaceException, ComponentCreationException {
        if (dynamicGroupDiscoveryDomain == null || dynamicGroupSearchType == null) {
            return null;
        }
        this.verifyNSObject();
        Vector<RBSAssociation> dgAsscV = new Vector<RBSAssociation>();
        FilterResultModifier.Filter filter = new FilterResultModifier.Filter();
        FilterResultModifier.FilterItemGroup filterItem = new FilterResultModifier.FilterItemGroup();
        filterItem.addFilterItem(SchemaUtil.translateNDAPAttr((ObjectEntry)this.getObjectEntry(), (String)"BaseClass"), "=", SchemaUtil.translateNDAPClass((ObjectEntry)this.getObjectEntry(), (String)"dynamicGroup"), null);
        if (dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
            filter.addFilterItemGroupPair(filterItem, "|");
            filterItem = new FilterResultModifier.FilterItemGroup();
            filterItem.addFilterItem(SchemaUtil.translateNDAPAttr((ObjectEntry)this.getObjectEntry(), (String)"Object Class"), "=", SchemaUtil.translateNDAPClass((ObjectEntry)this.getObjectEntry(), (String)"dynamicGroupAux"), null);
        }
        filter.addFilterItemGroupPair(filterItem, null);
        FilterResultModifier resultModifier = new FilterResultModifier("", filter, true);
        ObjectEntry startOE = null;
        if (dynamicGroupDiscoveryDomain.equalsIgnoreCase("root")) {
            startOE = this.oe.getRoot();
        } else if (dynamicGroupDiscoveryDomain.equalsIgnoreCase("partition")) {
            for (startOE = this.oe.getParent(); startOE != null && !ObjectFlags.isPartition((long)startOE.getObjectFlags()); startOE = startOE.getParent()) {
            }
        } else {
            startOE = this.oe.getParent();
        }
        ObjectEntry authenticatedOE = this.ns.getAuthenticatedIdentity(this.oe.getRoot());
        String whoami = this.ns.getUnrootedName(authenticatedOE);
        ObjectEntryEnumeration myenum = this.ns.getChildren(startOE, (ResultModifier)resultModifier);
        while (myenum.hasMoreElements()) {
            RBSAssociation[] dgAssc;
            ObjectEntry dgOE = myenum.next();
            if (!NSModel.compareAttribute(dgOE, SchemaUtil.translateNDAPAttr((ObjectEntry)dgOE, (String)"Member"), whoami) || (dgAssc = this.getFromDirect(dgOE, version)) == null) continue;
            for (int j = 0; j < dgAssc.length; ++j) {
                dgAsscV.add(dgAssc[j]);
            }
        }
        if (dgAsscV.size() == 0) {
            return null;
        }
        Object[] relations = new RBSAssociation[dgAsscV.size()];
        dgAsscV.copyInto(relations);
        return relations;
    }

    private RBSAssociation[] getFromOrgRoles(int version) throws SPIException {
        this.verifyNSObject();
        ObjectEntry[] securityEqualsOE = NSModel.getDN(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Security Equals"));
        if (securityEqualsOE != null) {
            String loggedInUser = this.ns.getUnrootedName(this.getObjectEntry());
            Vector<RBSAssociation> v = new Vector<RBSAssociation>(20);
            block0: for (int i = 0; i < securityEqualsOE.length; ++i) {
                ObjectEntry[] roleOccupantOE;
                if (!RBSUtil.isOfType(securityEqualsOE[i].getObjectType(), SchemaUtil.translateNDAPAttr((ObjectEntry)securityEqualsOE[i], (String)"Organizational Role"), true) || (roleOccupantOE = NSModel.getDN(securityEqualsOE[i], null, SchemaUtil.translateNDAPAttr((ObjectEntry)securityEqualsOE[i], (String)"Role Occupant"))) == null) continue;
                for (int k = 0; k < roleOccupantOE.length; ++k) {
                    String occupant = this.ns.getUnrootedName(roleOccupantOE[k]);
                    if (!occupant.equalsIgnoreCase(loggedInUser)) continue;
                    RBSAssociation[] relations = this.getFromDirect(securityEqualsOE[i], version);
                    if (relations == null) continue block0;
                    for (int j = 0; j < relations.length; ++j) {
                        v.addElement(relations[j]);
                    }
                    continue block0;
                }
            }
            if (v.size() == 0) {
                return null;
            }
            Object[] rval = new RBSAssociation[v.size()];
            v.copyInto(rval);
            return rval;
        }
        return null;
    }

    public RBSAssociation[] getSpecifiedRoleAssociations(String[] types, String lvlUp, String dynamicGroupDiscoveryDomain, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, JDOMException, NVDSException, IOException, NamingException, RBSException {
        return this.getSpecifiedRoleAssociationsMain(types, lvlUp, dynamicGroupDiscoveryDomain, dynamicGroupSearchType, 1);
    }

    public RBSAssociation[] getSpecifiedRoleAssociations2(String[] types, String lvlUp, String dynamicGroupDiscoveryDomain, String dynamicGroupSearchType) throws SPIException, NamespaceException, ComponentCreationException, JDOMException, NVDSException, IOException, NamingException, RBSException {
        return this.getSpecifiedRoleAssociationsMain(types, lvlUp, dynamicGroupDiscoveryDomain, dynamicGroupSearchType, 2);
    }

    private RBSAssociation[] getSpecifiedRoleAssociationsMain(String[] types, String lvlUp, String dynamicGroupDiscoveryDomain, String dynamicGroupSearchType, int version) throws SPIException, NamespaceException, ComponentCreationException, JDOMException, NVDSException, IOException, NamingException, RBSException {
        RBSAssociation[] orgRoleAssociation;
        RBSAssociation[] dynamicGroupAssociation;
        RBSAssociation[] containerAssociation;
        RBSAssociation[] groupAssociation;
        RBSAssociation[] directAssociation;
        String levelUp;
        this.verifyNSObject();
        if (this.isNVDS) {
            return this.getSpecifiedRoleAssociationsFromRBACRoles(types);
        }
        Hashtable<String, String> roles = new Hashtable<String, String>();
        Vector<RBSAssociation> vector = new Vector<RBSAssociation>();
        String[] theTypes = types;
        if (theTypes == null) {
            theTypes = new String[]{"iManager"};
        }
        if ((levelUp = lvlUp) == null) {
            levelUp = new String("container");
        }
        if ((directAssociation = this.getFromDirect(this.oe, version)) != null) {
            block0: for (int i = 0; i < directAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(directAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < theTypes.length; ++j) {
                    if (!type.equalsIgnoreCase(theTypes[j])) continue;
                    String name = this.ns.getUnrootedName(directAssociation[i].getRole().getObjectEntry());
                    if (roles.get(name) != null) continue block0;
                    roles.put(name, name);
                    vector.add(directAssociation[i]);
                    continue block0;
                }
            }
        }
        if ((groupAssociation = this.getFromGroups(version)) != null) {
            block2: for (int i = 0; i < groupAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(groupAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < theTypes.length; ++j) {
                    if (!type.equalsIgnoreCase(theTypes[j])) continue;
                    String name = this.ns.getUnrootedName(groupAssociation[i].getRole().getObjectEntry());
                    if (roles.get(name) != null) continue block2;
                    roles.put(name, name);
                    vector.add(groupAssociation[i]);
                    continue block2;
                }
            }
        }
        if ((containerAssociation = this.getFromContainer(levelUp, version)) != null) {
            block4: for (int i = 0; i < containerAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(containerAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < theTypes.length; ++j) {
                    if (!type.equalsIgnoreCase(theTypes[j])) continue;
                    String name = this.ns.getUnrootedName(containerAssociation[i].getRole().getObjectEntry());
                    if (roles.get(name) != null) continue block4;
                    roles.put(name, name);
                    vector.add(containerAssociation[i]);
                    continue block4;
                }
            }
        }
        if ((dynamicGroupAssociation = this.getFromDynamicGroups(dynamicGroupDiscoveryDomain, dynamicGroupSearchType, version)) != null) {
            block6: for (int i = 0; i < dynamicGroupAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(dynamicGroupAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < theTypes.length; ++j) {
                    if (!type.equalsIgnoreCase(theTypes[j])) continue;
                    String name = this.ns.getUnrootedName(dynamicGroupAssociation[i].getRole().getObjectEntry());
                    if (roles.get(name) != null) continue block6;
                    roles.put(name, name);
                    vector.add(dynamicGroupAssociation[i]);
                    continue block6;
                }
            }
        }
        if ((orgRoleAssociation = this.getFromOrgRoles(version)) != null) {
            for (int i = 0; i < orgRoleAssociation.length; ++i) {
                String name = this.ns.getUnrootedName(orgRoleAssociation[i].getRole().getObjectEntry());
                if (roles.get(name) != null) continue;
                roles.put(name, name);
                vector.add(orgRoleAssociation[i]);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] relations = new RBSAssociation[vector.size()];
        vector.copyInto(relations);
        return relations;
    }

    public Vector[] getRoleAssociations(String[] types, String lvlUp, String dynamicGroupDiscoveryDomain, String dynamicGroupSearchType, int version) throws SPIException, RBSException, NamespaceException, ComponentCreationException {
        Vector[] roleAssociations = new Vector[5];
        Vector<RBSAssociation> v1 = new Vector<RBSAssociation>();
        RBSAssociation[] directAssociation = this.getFromDirect(this.oe, version);
        if (directAssociation != null) {
            for (int i = 0; i < directAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(directAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < types.length; ++j) {
                    if (!type.equalsIgnoreCase(types[j])) continue;
                    v1.add(directAssociation[i]);
                }
            }
        }
        roleAssociations[0] = v1;
        Vector<RBSAssociation> v2 = new Vector<RBSAssociation>();
        RBSAssociation[] groupAssociation = this.getFromGroups(version);
        if (groupAssociation != null) {
            for (int i = 0; i < groupAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(groupAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < types.length; ++j) {
                    if (!type.equalsIgnoreCase(types[j])) continue;
                    v2.add(groupAssociation[i]);
                }
            }
        }
        roleAssociations[1] = v2;
        Vector<RBSAssociation> v3 = new Vector<RBSAssociation>();
        RBSAssociation[] containerAssociation = this.getFromContainer(lvlUp, version);
        if (containerAssociation != null) {
            for (int i = 0; i < containerAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(containerAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < types.length; ++j) {
                    if (!type.equalsIgnoreCase(types[j])) continue;
                    v3.add(containerAssociation[i]);
                }
            }
        }
        roleAssociations[2] = v3;
        Vector<RBSAssociation> v4 = new Vector<RBSAssociation>();
        RBSAssociation[] dynamicGroupAssociation = this.getFromDynamicGroups(dynamicGroupDiscoveryDomain, dynamicGroupSearchType, version);
        if (dynamicGroupAssociation != null) {
            for (int i = 0; i < dynamicGroupAssociation.length; ++i) {
                String type = RBSUtil.getTypeFromParameters(dynamicGroupAssociation[i].getRole().getObjectEntry());
                for (int j = 0; j < types.length; ++j) {
                    if (!type.equalsIgnoreCase(types[j])) continue;
                    v4.add(dynamicGroupAssociation[i]);
                }
            }
        }
        roleAssociations[3] = v4;
        Vector<RBSAssociation> v5 = new Vector<RBSAssociation>();
        RBSAssociation[] orgRoleAssociation = this.getFromOrgRoles(version);
        if (orgRoleAssociation != null) {
            for (int i = 0; i < orgRoleAssociation.length; ++i) {
                v5.add(orgRoleAssociation[i]);
            }
        }
        roleAssociations[4] = v5;
        return roleAssociations;
    }

    public RBSRoleReport[] getDirectRoleReport(ObjectEntry directOE) throws SPIException, RBSException {
        String thisName = this.ns.getUnrootedName(directOE);
        ObjectEntry scopeOE = null;
        String inherit = "false";
        boolean rightsSet = false;
        Vector<RBSRoleReport> vector = new Vector<RBSRoleReport>(10);
        Enumeration valueSet = NSModel.getAttribute(directOE, null, "rbsAssignedRoles2");
        if (valueSet != null) {
            while (valueSet.hasMoreElements()) {
                TypedNameFacade facade = (TypedNameFacade)((ValueList)valueSet.nextElement()).createFacade();
                String roleName = facade.getObject();
                ObjectEntry roleOE = this.ns.getObjectEntry(directOE.getRoot(), roleName);
                ObjectAttribute memberAttrib = this.ns.getAttribute(roleOE, "rbsMember");
                ObjectAttribute trusteeAttrib = this.ns.getAttribute(roleOE, "rbsTrusteeOf");
                if (memberAttrib == null) continue;
                Enumeration memberSet = memberAttrib.getValueComponents();
                while (memberSet.hasMoreElements()) {
                    TypedNameFacade memberFacade = (TypedNameFacade)((ValueList)memberSet.nextElement()).createFacade();
                    if (!thisName.equalsIgnoreCase(memberFacade.getObject())) continue;
                    long index = memberFacade.getInterval();
                    if (trusteeAttrib == null) continue;
                    Enumeration trusteeSet = trusteeAttrib.getValueComponents();
                    boolean found = false;
                    while (trusteeSet.hasMoreElements()) {
                        TypedNameFacade trusteeFacade = (TypedNameFacade)((ValueList)trusteeSet.nextElement()).createFacade();
                        if (index != trusteeFacade.getInterval()) continue;
                        found = true;
                        String objName = trusteeFacade.getObject();
                        scopeOE = objName.startsWith(".") && objName.endsWith(".") ? directOE.getRoot() : this.ns.getObjectEntry(directOE.getRoot(), trusteeFacade.getObject());
                        inherit = RBSUtil.isInheritedBitset(trusteeFacade.getLevel());
                        rightsSet = RBSUtil.isRightsSet(trusteeFacade.getLevel());
                        break;
                    }
                    if (!found) continue;
                    boolean isDGAux = this.isDGAuxClass(directOE);
                    RBSRoleReport report = new RBSRoleReport(this.ns.getUnrootedName(this.oe), roleOE.getName(), this.ns.getUnrootedName(roleOE), this.getDisplayName(scopeOE), directOE.getObjectType().getName().replace(' ', '_'), this.ns.getUnrootedName(directOE), inherit, rightsSet, isDGAux);
                    vector.addElement(report);
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] rbsRoleReport = new RBSRoleReport[vector.size()];
        vector.copyInto(rbsRoleReport);
        return rbsRoleReport;
    }

    public RBSRoleReport[] getGroupRoleReport() throws SPIException, RBSException {
        this.verifyNSObject();
        ObjectEntry[] groups = NSModel.getDN(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Group Membership"));
        if (groups != null) {
            Vector<RBSRoleReport> vector = new Vector<RBSRoleReport>();
            for (int i = 0; i < groups.length; ++i) {
                RBSRoleReport[] rbsRoleReport = this.getDirectRoleReport(groups[i]);
                if (rbsRoleReport == null) continue;
                for (int j = 0; j < rbsRoleReport.length; ++j) {
                    vector.addElement(rbsRoleReport[j]);
                }
            }
            if (vector.size() == 0) {
                return null;
            }
            Object[] rval = new RBSRoleReport[vector.size()];
            vector.copyInto(rval);
            return rval;
        }
        return null;
    }

    public RBSRoleReport[] getContainerRoleReport(String levelUp) throws SPIException, RBSException {
        Object[] rbsRoleReport;
        ObjectEntry currentOE;
        this.verifyNSObject();
        Vector<Object> vector = new Vector<Object>();
        if (levelUp.equalsIgnoreCase("root")) {
            for (currentOE = this.oe.getParent(); currentOE != null; currentOE = currentOE.getParent()) {
                rbsRoleReport = this.getDirectRoleReport(currentOE);
                if (rbsRoleReport == null) continue;
                for (int i = 0; i < rbsRoleReport.length; ++i) {
                    vector.addElement(rbsRoleReport[i]);
                }
            }
        } else if (levelUp.equalsIgnoreCase("partition")) {
            while (currentOE != null) {
                rbsRoleReport = this.getDirectRoleReport(currentOE);
                if (rbsRoleReport != null) {
                    for (int i = 0; i < rbsRoleReport.length; ++i) {
                        vector.addElement(rbsRoleReport[i]);
                    }
                }
                if (!ObjectFlags.isPartition((long)currentOE.getObjectFlags())) {
                    currentOE = currentOE.getParent();
                    continue;
                }
                break;
            }
        } else {
            rbsRoleReport = this.getDirectRoleReport(currentOE);
            if (rbsRoleReport != null) {
                for (int i = 0; i < rbsRoleReport.length; ++i) {
                    vector.add(rbsRoleReport[i]);
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        rbsRoleReport = new RBSRoleReport[vector.size()];
        vector.copyInto(rbsRoleReport);
        return rbsRoleReport;
    }

    public RBSRoleReport[] getDynamicGroupRoleReport(String dynamicGroupDiscoveryDomain, String dynamicGroupSearchType) throws SPIException, RBSException, ComponentCreationException, NamespaceException {
        if (dynamicGroupDiscoveryDomain == null || dynamicGroupSearchType == null) {
            return null;
        }
        this.verifyNSObject();
        Vector<RBSRoleReport> dgAsscV = new Vector<RBSRoleReport>();
        FilterResultModifier.Filter filter = new FilterResultModifier.Filter();
        FilterResultModifier.FilterItemGroup filterItem = new FilterResultModifier.FilterItemGroup();
        filterItem.addFilterItem(SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"BaseClass"), "=", SchemaUtil.translateNDAPClass((ObjectEntry)this.oe, (String)"dynamicGroup"), null);
        if (dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
            filter.addFilterItemGroupPair(filterItem, "|");
            filterItem = new FilterResultModifier.FilterItemGroup();
            filterItem.addFilterItem(SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Object Class"), "=", "dynamicGroupAux", null);
        }
        filter.addFilterItemGroupPair(filterItem, null);
        FilterResultModifier resultModifier = new FilterResultModifier("", filter, true);
        ObjectEntry startOE = null;
        if (dynamicGroupDiscoveryDomain.equalsIgnoreCase("root")) {
            startOE = this.oe.getRoot();
        } else if (dynamicGroupDiscoveryDomain.equalsIgnoreCase("partition")) {
            for (startOE = this.oe.getParent(); startOE != null && !ObjectFlags.isPartition((long)startOE.getObjectFlags()); startOE = startOE.getParent()) {
            }
        } else {
            startOE = this.oe.getParent();
        }
        String whoami = this.ns.getUnrootedName(this.oe);
        ObjectEntryEnumeration myenum = this.ns.getChildren(startOE, (ResultModifier)resultModifier);
        while (myenum.hasMoreElements()) {
            RBSRoleReport[] dgAssc;
            ObjectEntry dgOE = myenum.next();
            if (!NSModel.compareAttribute(dgOE, SchemaUtil.translateNDAPAttr((ObjectEntry)dgOE, (String)"Member"), whoami) || (dgAssc = this.getDirectRoleReport(dgOE)) == null) continue;
            for (int j = 0; j < dgAssc.length; ++j) {
                dgAsscV.add(dgAssc[j]);
            }
        }
        if (dgAsscV.size() == 0) {
            return null;
        }
        Object[] rbsRoleReport = new RBSRoleReport[dgAsscV.size()];
        dgAsscV.copyInto(rbsRoleReport);
        return rbsRoleReport;
    }

    public RBSRoleReport[] getOrgRolesRoleReport() throws SPIException, RBSException {
        this.verifyNSObject();
        ObjectEntry[] securityEqualsOE = NSModel.getDN(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Security Equals"));
        if (securityEqualsOE != null) {
            String loggedInUser = this.ns.getUnrootedName(this.getObjectEntry());
            Vector<RBSRoleReport> vector = new Vector<RBSRoleReport>();
            block0: for (int i = 0; i < securityEqualsOE.length; ++i) {
                ObjectEntry[] roleOccupantOE;
                if (!RBSUtil.isOfType(securityEqualsOE[i].getObjectType(), SchemaUtil.translateNDAPAttr((ObjectEntry)securityEqualsOE[i], (String)"Organizational Role"), true) || (roleOccupantOE = NSModel.getDN(securityEqualsOE[i], null, SchemaUtil.translateNDAPAttr((ObjectEntry)securityEqualsOE[i], (String)"Role Occupant"))) == null) continue;
                for (int k = 0; k < roleOccupantOE.length; ++k) {
                    String occupant = this.ns.getUnrootedName(roleOccupantOE[k]);
                    if (!occupant.equalsIgnoreCase(loggedInUser)) continue;
                    RBSRoleReport[] relations = this.getDirectRoleReport(securityEqualsOE[i]);
                    if (relations == null) continue block0;
                    for (int j = 0; j < relations.length; ++j) {
                        vector.addElement(relations[j]);
                    }
                    continue block0;
                }
            }
            if (vector.size() == 0) {
                return null;
            }
            Object[] rbsRoleReport = new RBSRoleReport[vector.size()];
            vector.copyInto(rbsRoleReport);
            return rbsRoleReport;
        }
        return null;
    }

    private boolean isDGAuxClass(ObjectEntry memberOE) throws SPIException {
        NSObject memberObj = this.ns.getDetails(memberOE);
        ClassDefinition[] classDefinition = memberObj.getClassDefinitions();
        for (int j = 0; j < classDefinition.length; ++j) {
            if (!classDefinition[j].getName().equals("dynamicGroupAux")) continue;
            return true;
        }
        return false;
    }

    private String getDisplayName(ObjectEntry oe) {
        String displayName = oe.getObjectType().getName().equalsIgnoreCase(SchemaUtil.translateNDAPClass((ObjectEntry)oe, (String)"Top")) ? oe.getName() : oe.getAdminNamespace().getUnrootedName(oe);
        return displayName;
    }

    public RBSAssociation[] getSpecifiedRoleAssociationsFromRBACRoles(String[] types) throws SPIException, JDOMException, NVDSException, IOException, NamingException, RBSException, NamespaceException {
        RBACRoleInfo[] rbacRoleInfo;
        if (!this.isNVDS) {
            return null;
        }
        this.verifyNSObject();
        Hashtable<String, String> roles = new Hashtable<String, String>();
        Vector<RBSAssociation> vector = new Vector<RBSAssociation>();
        String loggedInUserName = this.ns.getUnrootedName(this.oe);
        String[] theTypes = types;
        if (theTypes == null) {
            theTypes = new String[]{"iManager"};
        }
        if ((rbacRoleInfo = NvdsLdapExtensions.getAssignedRBACRoles((AdminNamespace)this.ns)) != null) {
            NvdsLdapExtensions.activateRBACRoles((AdminNamespace)this.ns, (RBACRoleInfo[])rbacRoleInfo);
            for (int i = 0; i < rbacRoleInfo.length; ++i) {
                ObjectEntry rbacRoleOE;
                RBACRole rbacRole;
                ObjectEntry[] rbsRoleOE;
                String rbacRoleName = rbacRoleInfo[i].getRoleName();
                if (rbacRoleName == null || (rbsRoleOE = (rbacRole = new RBACRole(rbacRoleOE = this.ns.getObjectEntry(this.oe.getRoot(), rbacRoleName))).getRoleMember()) == null) continue;
                for (int j = 0; j < rbsRoleOE.length; ++j) {
                    RBSRole rbsRole = new RBSRole(rbsRoleOE[j]);
                    RBSAssociation[] rbsAssociation = rbsRole.getMembers();
                    if (rbsAssociation == null) continue;
                    block2: for (int k = 0; k < rbsAssociation.length; ++k) {
                        String type = RBSUtil.getTypeFromParameters(rbsAssociation[k].getRole().getObjectEntry());
                        for (int m = 0; m < theTypes.length; ++m) {
                            String memberName;
                            if (!type.equalsIgnoreCase(theTypes[m]) || !loggedInUserName.equalsIgnoreCase(memberName = this.ns.getUnrootedName(rbsAssociation[k].getMember()))) continue;
                            String name = this.ns.getUnrootedName(rbsAssociation[k].getRole().getObjectEntry());
                            if (roles.get(name) != null) continue block2;
                            roles.put(name, name);
                            vector.add(rbsAssociation[k]);
                            continue block2;
                        }
                    }
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] relations = new RBSAssociation[vector.size()];
        vector.copyInto(relations);
        return relations;
    }

    public RBSCollection[] getAllOwnedCollections2() throws SPIException, NamespaceException {
        Collection collection;
        ObjectEntry[] groupOEs;
        this.verifyNSObject();
        HashMap<String, RBSCollection> collectionMap = new HashMap<String, RBSCollection>();
        ObjectEntry[] ownedCollections = NSModel.getDN(this.oe, this.nsObj, "rbsOwnedCollections2");
        if (ownedCollections != null) {
            for (int i = 0; i < ownedCollections.length; ++i) {
                RBSCollection collection2 = new RBSCollection(ownedCollections[i]);
                String collectionName = this.ns.getUnrootedName(ownedCollections[i]);
                collectionMap.put(collectionName, collection2);
            }
        }
        if (this.ns.isSupported("eDir") && (groupOEs = NSModel.getDN(this.oe, this.nsObj, "Group Membership")) != null) {
            for (int i = 0; i < groupOEs.length; ++i) {
                RBSAssociatedObject rbsGroupAssociatedObject = new RBSAssociatedObject(groupOEs[i]);
                RBSCollection[] rbsGroupCollections = rbsGroupAssociatedObject.getOwnedCollections2();
                if (rbsGroupCollections == null) continue;
                for (int j = 0; j < rbsGroupCollections.length; ++j) {
                    String collectionName = this.ns.getUnrootedName(rbsGroupCollections[j].getObjectEntry());
                    if (collectionMap.get(collectionName) != null) continue;
                    collectionMap.put(collectionName, rbsGroupCollections[j]);
                }
            }
        }
        if (collectionMap.size() > 0 && (collection = collectionMap.values()).size() > 0) {
            RBSCollection[] collections = collection.toArray(new RBSCollection[collection.size()]);
            return collections;
        }
        return null;
    }
}

