/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.rbs.RBSRole;

public class RBSAssociation {
    private ObjectEntry oe;
    private RBSRole role;
    private ObjectEntry scope;
    private long index;
    private String inheritanceScope;
    private boolean rightsSet;

    public RBSAssociation(ObjectEntry objectEntry, RBSRole rbsRole, ObjectEntry theScope, long scopeIndex, String inheritScope, boolean setRights) {
        this.oe = objectEntry;
        this.role = rbsRole;
        this.scope = theScope;
        this.index = scopeIndex;
        this.inheritanceScope = inheritScope;
        this.rightsSet = setRights;
    }

    public RBSAssociation() {
        this.oe = null;
        this.role = null;
        this.scope = null;
        this.index = -1L;
        this.inheritanceScope = "false";
        this.rightsSet = false;
    }

    public ObjectEntry getMember() {
        return this.oe;
    }

    public void setMember(ObjectEntry obj) {
        this.oe = obj;
    }

    public RBSRole getRole() {
        return this.role;
    }

    public void setRole(RBSRole newRole) {
        this.role = newRole;
    }

    public long getIndex() {
        return this.index;
    }

    public ObjectEntry getScope() {
        return this.scope;
    }

    public void setScope(ObjectEntry theScope) {
        this.scope = theScope;
    }

    public String getInheritanceScope() {
        return this.inheritanceScope;
    }

    public void setInheritanceScope(String state) {
        this.inheritanceScope = state;
    }

    public boolean isRightsSet() {
        return this.rightsSet;
    }

    public void setRights(boolean setRights) {
        this.rightsSet = setRights;
    }

    public boolean isExternalScope() throws SPIException, NamespaceException {
        if (this.scope != null) {
            AdminNamespace ns = this.scope.getAdminNamespace();
            ClassDefinition def = ns.getClassDefinition(this.scope, this.scope.getObjectType().getName());
            return def.isInheritedFrom("rbsExternalScope");
        }
        return false;
    }
}

