/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSAttributeFlags;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSClassFlags;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.rbs.ASNOne;
import java.beans.PropertyVetoException;
import java.util.Vector;

public class RBSNDSSchemaVerifier {
    private ObjectEntry oe;
    private AdminNamespace ns;
    private NDSSchemaDefinition schemaDef;
    private NDSAttributeDefinition[] attribs;
    private NDSAttributeDefinition RBS_ASSIGNED_ROLES2;
    private NDSAttributeDefinition RBS_CONTENT;
    private NDSAttributeDefinition RBS_CONTENT_MEMBERSHIP;
    private NDSAttributeDefinition RBS_ENTRY_POINT;
    private NDSAttributeDefinition RBS_MEMBER;
    private NDSAttributeDefinition RBS_OWNED_COLLECTIONS2;
    private NDSAttributeDefinition RBS_PATH;
    private NDSAttributeDefinition RBS_PARAMETERS;
    private NDSAttributeDefinition RBS_TASK_RIGHTS;
    private NDSAttributeDefinition RBS_TRUSTEE_OF;
    private NDSAttributeDefinition RBS_TYPE;
    private NDSAttributeDefinition RBS_PAGE_MEMBERSHIP;
    private NDSAttributeDefinition RBS_TARGET_OBJECT_TYPE;
    private NDSAttributeDefinition RBS_CONTEXT;
    private NDSAttributeDefinition RBS_XML_INFO;
    private NDSAttributeDefinition RBS_ROLE_MEMBER;
    private NDSAttributeDefinition RBS_CATEGORY_MEMBERSHIP;
    private NDSClassDefinition[] classes;
    private AttributeDefinition[] OPTIONAL_RBS_EXTERNAL_SCOPE;
    private AttributeDefinition[] OPTIONAL_RBS_MODULE;
    private AttributeDefinition[] OPTIONAL_RBS_ROLE;
    private AttributeDefinition[] OPTIONAL_RBS_TASK;
    private AttributeDefinition[] OPTIONAL_RBS_BOOK;
    private AttributeDefinition[] OPTIONAL_RBS_SCOPE;
    private AttributeDefinition[] OPTIONAL_RBS_COLLECTION;
    private AttributeDefinition[] OPTIONAL_TOP;
    private AttributeDefinition[] OPTIONAL_RBS_CATEGORY;
    private AttributeDefinition CN;
    private AttributeDefinition DESCRIPTION;
    private AttributeDefinition OWNER;
    private NDSClassDefinition TOP;

    public RBSNDSSchemaVerifier(ObjectEntry treeOE) throws NamespaceException, SPIException {
        this.oe = treeOE;
        this.ns = this.oe.getAdminNamespace();
        this.schemaDef = (NDSSchemaDefinition)this.ns.getSchemaDefinition(this.oe);
        this.setupAttributes();
        this.setupClasses();
    }

    public boolean isSchemaValid() throws NamespaceException {
        int i;
        if (this.attribs != null) {
            for (i = 0; i < this.attribs.length; ++i) {
                if (this.schemaDef.isAttributeDefined(this.attribs[i].getName())) continue;
                return false;
            }
        }
        if (this.classes != null) {
            for (i = 0; i < this.classes.length; ++i) {
                if (!this.schemaDef.isClassDefined(this.classes[i].getName())) {
                    return false;
                }
                NDSClassDefinition classDef = (NDSClassDefinition)this.schemaDef.getClassDefinition(this.classes[i].getName());
                if (this.areAllOptionalAttributesAssigned(this.classes[i], classDef)) continue;
                return false;
            }
        }
        if (!this.TOP.isClassUsingAttribute("rbsAssignedRoles2")) {
            return false;
        }
        return this.TOP.isClassUsingAttribute("rbsOwnedCollections2");
    }

    public void extendSchema() throws PropertyVetoException, NamespaceException, SPIException {
        int i;
        if (this.attribs != null) {
            for (i = 0; i < this.attribs.length; ++i) {
                if (this.schemaDef.isAttributeDefined(this.attribs[i].getName())) continue;
                this.schemaDef.putAttributeDefinition((AttributeDefinition)this.attribs[i]);
            }
        }
        if (this.classes != null) {
            for (i = 0; i < this.classes.length; ++i) {
                if (!this.schemaDef.isClassDefined(this.classes[i].getName())) {
                    this.schemaDef.putClassDefinition((ClassDefinition)this.classes[i]);
                    continue;
                }
                NDSClassDefinition classDef = this.schemaDef.getUnexpandedClassDefinition(this.classes[i].getName());
                if (this.areAllOptionalAttributesAssigned(this.classes[i], classDef)) continue;
                this.addAttrsToClass(this.classes[i].getOptionalAttributes(), classDef);
            }
        }
        if (!this.TOP.isClassUsingAttribute("rbsAssignedRoles2") || !this.TOP.isClassUsingAttribute("rbsOwnedCollections2")) {
            this.addAttrsToClass(this.OPTIONAL_TOP, this.TOP);
        }
    }

    private void setupAttributes() throws NamespaceException {
        this.attribs = new NDSAttributeDefinition[17];
        this.attribs[0] = new NDSAttributeDefinition("rbsAssignedRoles2", NDSSyntax.SYN_TYPED_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.51").getAsn1());
        this.RBS_ASSIGNED_ROLES2 = this.attribs[0];
        this.attribs[1] = new NDSAttributeDefinition("rbsContent", NDSSyntax.SYN_TYPED_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.31").getAsn1());
        this.RBS_CONTENT = this.attribs[1];
        this.attribs[2] = new NDSAttributeDefinition("rbsContentMembership", NDSSyntax.SYN_TYPED_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.32").getAsn1());
        this.RBS_CONTENT_MEMBERSHIP = this.attribs[2];
        this.attribs[3] = new NDSAttributeDefinition("rbsEntryPoint", NDSSyntax.SYN_CE_STRING, new NDSAttributeFlags(97), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.33").getAsn1());
        this.RBS_ENTRY_POINT = this.attribs[3];
        this.attribs[4] = new NDSAttributeDefinition("rbsMember", NDSSyntax.SYN_TYPED_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.34").getAsn1());
        this.RBS_MEMBER = this.attribs[4];
        this.attribs[5] = new NDSAttributeDefinition("rbsOwnedCollections2", NDSSyntax.SYN_DIST_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.52").getAsn1());
        this.RBS_OWNED_COLLECTIONS2 = this.attribs[5];
        this.attribs[6] = new NDSAttributeDefinition("rbsPath", NDSSyntax.SYN_TYPED_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.36").getAsn1());
        this.RBS_PATH = this.attribs[6];
        this.attribs[7] = new NDSAttributeDefinition("rbsParameters", NDSSyntax.SYN_CE_STRING, new NDSAttributeFlags(96), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.37").getAsn1());
        this.RBS_PARAMETERS = this.attribs[7];
        this.attribs[8] = new NDSAttributeDefinition("rbsTaskRights", NDSSyntax.SYN_OCTET_STRING, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.38").getAsn1());
        this.RBS_TASK_RIGHTS = this.attribs[8];
        this.attribs[9] = new NDSAttributeDefinition("rbsTrusteeOf", NDSSyntax.SYN_TYPED_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.39").getAsn1());
        this.RBS_TRUSTEE_OF = this.attribs[9];
        this.attribs[10] = new NDSAttributeDefinition("rbsType", NDSSyntax.SYN_CI_STRING, new NDSAttributeFlags(99), 1L, 256L, new ASNOne("2.16.840.1.113719.1.135.4.40").getAsn1());
        this.RBS_TYPE = this.attribs[10];
        this.attribs[11] = new NDSAttributeDefinition("rbsPageMembership", NDSSyntax.SYN_CE_STRING, new NDSAttributeFlags(96), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.45").getAsn1());
        this.RBS_PAGE_MEMBERSHIP = this.attribs[11];
        this.attribs[12] = new NDSAttributeDefinition("rbsTargetObjectType", NDSSyntax.SYN_CI_STRING, new NDSAttributeFlags(96), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.46").getAsn1());
        this.RBS_TARGET_OBJECT_TYPE = this.attribs[12];
        this.attribs[13] = new NDSAttributeDefinition("rbsContext", NDSSyntax.SYN_DIST_NAME, new NDSAttributeFlags(65), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.47").getAsn1());
        this.RBS_CONTEXT = this.attribs[13];
        this.attribs[14] = new NDSAttributeDefinition("rbsXMLInfo", NDSSyntax.SYN_CI_STRING, new NDSAttributeFlags(97), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.48").getAsn1());
        this.RBS_XML_INFO = this.attribs[14];
        this.attribs[15] = new NDSAttributeDefinition("rbsRoleMember", NDSSyntax.SYN_DIST_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.53").getAsn1());
        this.RBS_ROLE_MEMBER = this.attribs[15];
        this.attribs[16] = new NDSAttributeDefinition("rbsCategoryMembership", NDSSyntax.SYN_DIST_NAME, new NDSAttributeFlags(64), 0L, 0L, new ASNOne("2.16.840.1.113719.1.135.4.54").getAsn1());
        this.RBS_CATEGORY_MEMBERSHIP = this.attribs[16];
        this.CN = this.schemaDef.getAttributeDefinition("CN");
        this.DESCRIPTION = this.schemaDef.getAttributeDefinition("Description");
        this.OWNER = this.schemaDef.getAttributeDefinition("Owner");
        this.OPTIONAL_RBS_COLLECTION = new AttributeDefinition[]{this.OWNER, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_EXTERNAL_SCOPE = new AttributeDefinition[]{this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_MODULE = new AttributeDefinition[]{this.RBS_PATH, this.RBS_TYPE, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_ROLE = new AttributeDefinition[]{this.RBS_CONTENT, this.RBS_MEMBER, this.RBS_TRUSTEE_OF, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_CATEGORY_MEMBERSHIP, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_TASK = new AttributeDefinition[]{this.RBS_CONTENT_MEMBERSHIP, this.RBS_TYPE, this.RBS_TASK_RIGHTS, this.RBS_ENTRY_POINT, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_XML_INFO};
        this.OPTIONAL_RBS_BOOK = new AttributeDefinition[]{this.RBS_TARGET_OBJECT_TYPE, this.RBS_PAGE_MEMBERSHIP};
        this.OPTIONAL_RBS_SCOPE = new AttributeDefinition[]{this.RBS_CONTEXT, this.RBS_XML_INFO};
        this.OPTIONAL_TOP = new AttributeDefinition[]{this.RBS_ASSIGNED_ROLES2, this.RBS_OWNED_COLLECTIONS2};
        this.OPTIONAL_RBS_CATEGORY = new AttributeDefinition[]{this.RBS_ROLE_MEMBER, this.RBS_PARAMETERS, this.DESCRIPTION, this.RBS_XML_INFO};
    }

    private void setupClasses() throws NamespaceException {
        this.TOP = this.schemaDef.getUnexpandedClassDefinition("Top");
        this.classes = new NDSClassDefinition[8];
        this.classes[0] = new NDSClassDefinition("rbsCollection2", new NDSClassFlags(3), new String[]{"Country", "Locality", "Organizational Unit", "Organization", "domain"}, new String[]{"Top"}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_COLLECTION, new ASNOne("2.16.840.1.113719.1.135.6.45.1").getAsn1());
        this.classes[1] = new NDSClassDefinition("rbsExternalScope2", new NDSClassFlags(0), new String[]{"rbsCollection2"}, new String[]{"Top"}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_EXTERNAL_SCOPE, new ASNOne("2.16.840.1.113719.1.135.6.38.1").getAsn1());
        this.classes[2] = new NDSClassDefinition("rbsModule2", new NDSClassFlags(3), new String[]{"rbsCollection2"}, new String[]{"Top"}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_MODULE, new ASNOne("2.16.840.1.113719.1.135.6.39.1").getAsn1());
        this.classes[3] = new NDSClassDefinition("rbsRole2", new NDSClassFlags(3), new String[]{"rbsCollection2"}, new String[]{"Top"}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_ROLE, new ASNOne("2.16.840.1.113719.1.135.6.40.1").getAsn1());
        this.classes[4] = new NDSClassDefinition("rbsTask2", new NDSClassFlags(2), new String[]{"rbsModule2"}, new String[]{"Top"}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_TASK, new ASNOne("2.16.840.1.113719.1.135.6.41.1").getAsn1());
        this.classes[5] = new NDSClassDefinition("rbsBook2", new NDSClassFlags(2), new String[]{"rbsModule2"}, new String[]{"rbsTask2"}, null, null, this.OPTIONAL_RBS_BOOK, new ASNOne("2.16.840.1.113719.1.135.6.42.1").getAsn1());
        this.classes[6] = new NDSClassDefinition("rbsScope2", new NDSClassFlags(2), new String[]{"rbsRole2"}, new String[]{"Group"}, null, null, this.OPTIONAL_RBS_SCOPE, new ASNOne("2.16.840.1.113719.1.135.6.43.1").getAsn1());
        this.classes[7] = new NDSClassDefinition("rbsCategory2", new NDSClassFlags(2), new String[]{"rbsCollection2"}, new String[]{"Top"}, new AttributeDefinition[]{this.CN}, new AttributeDefinition[]{this.CN}, this.OPTIONAL_RBS_CATEGORY, new ASNOne("2.16.840.1.113719.1.135.6.46.1").getAsn1());
    }

    void addAttrsToClass(AttributeDefinition[] subAttrs, NDSClassDefinition classDef) throws NamespaceException, PropertyVetoException, SPIException {
        int i;
        AttributeDefinition[] superAttrs = classDef.getOptionalAttributes();
        Vector<AttributeDefinition> optionalVector = new Vector<AttributeDefinition>(10);
        for (i = 0; i < superAttrs.length; ++i) {
            optionalVector.addElement(superAttrs[i]);
        }
        for (i = 0; i < subAttrs.length; ++i) {
            boolean attrMatches = false;
            for (int j = 0; j < superAttrs.length; ++j) {
                if (!subAttrs[i].getName().equals(superAttrs[j].getName())) continue;
                attrMatches = true;
                break;
            }
            if (attrMatches) continue;
            optionalVector.addElement(subAttrs[i]);
        }
        Object[] newOptional = new NDSAttributeDefinition[optionalVector.size()];
        optionalVector.copyInto(newOptional);
        classDef = new NDSClassDefinition(classDef.getName(), classDef.getClassFlags(), classDef.getContainmentClasses(), classDef.getSuperClasses(), classDef.getMandatoryAttributes(), classDef.getNamingAttributes(), (AttributeDefinition[])newOptional, classDef.getASN1Data());
        this.schemaDef.putClassDefinition((ClassDefinition)classDef);
    }

    private boolean areAllOptionalAttributesAssigned(NDSClassDefinition subClass, NDSClassDefinition superClass) {
        boolean returnValue = true;
        AttributeDefinition[] subAttrs = subClass.getOptionalAttributes();
        AttributeDefinition[] superAttrs = superClass.getOptionalAttributes();
        for (int i = 0; i < subAttrs.length; ++i) {
            boolean attrMatches = false;
            for (int j = 0; j < superAttrs.length; ++j) {
                if (!subAttrs[i].getName().equals(superAttrs[j].getName())) continue;
                attrMatches = true;
                break;
            }
            if (attrMatches) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }
}

