/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.rbs.RBSRights;

public class RBSNVDSRights
extends RBSRights {
    private String filterName;
    private String scopeName;
    private String className;
    private long modifier;

    public RBSNVDSRights() {
        this.filterName = null;
        this.scopeName = null;
        this.className = null;
        this.modifier = 0L;
    }

    public RBSNVDSRights(ObjectACLFacade facade) {
        super(facade.getNVDSTrustee(), facade.getNVDSAttributeName(), facade.getNVDSPrivileges());
        this.filterName = facade.getNVDSFilter();
        this.scopeName = facade.getNVDSScope();
        this.className = facade.getNVDSClassName();
        this.modifier = facade.getNVDSModifier();
    }

    public RBSNVDSRights(String trusteeDN, String filterDN, String scope, String classNameFilter, String attr, long modifierType, String[] privilegeStrings) {
        super(trusteeDN, attr, 0L);
        this.priv = this.convertNVDSPrivilegeStringsToLong(privilegeStrings);
        this.filterName = filterDN;
        this.scopeName = scope;
        this.className = classNameFilter;
        this.modifier = modifierType;
    }

    public RBSNVDSRights(String trusteeDN, String filterDN, String scope, String classNameFilter, String attr, long modifierType, long privileges) {
        super(trusteeDN, attr, privileges);
        this.filterName = filterDN;
        this.scopeName = scope;
        this.className = classNameFilter;
        this.modifier = modifierType;
    }

    public long getModifier() {
        return this.modifier;
    }

    public void setModifier(long modRights) {
        this.modifier = modRights;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String name) {
        this.filterName = name;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(String name) {
        this.scopeName = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    private long convertNVDSPrivilegeStringsToLong(String[] privilegeStrings) {
        long prvlg = 0L;
        if (this.modifier == 1L) {
            for (int i = 0; i < privilegeStrings.length; ++i) {
                String privilege = privilegeStrings[i];
                if (privilege.equalsIgnoreCase("Supervisor")) {
                    prvlg |= 0x10L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Browse")) {
                    prvlg |= 1L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Create")) {
                    prvlg |= 2L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Delete")) {
                    prvlg |= 4L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Rename")) {
                    prvlg |= 8L;
                    continue;
                }
                if (!privilege.equalsIgnoreCase("AddForwardReference")) continue;
                prvlg |= 0x20L;
            }
        } else {
            for (int i = 0; i < privilegeStrings.length; ++i) {
                String privilege = privilegeStrings[i];
                if (privilege.equalsIgnoreCase("Supervisor")) {
                    prvlg |= 0x10L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Compare")) {
                    prvlg |= 1L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Read")) {
                    prvlg |= 2L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Modify")) {
                    prvlg |= 4L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Delete")) {
                    prvlg |= 8L;
                    continue;
                }
                if (privilege.equalsIgnoreCase("Write")) {
                    prvlg |= 8L;
                    prvlg |= 4L;
                    continue;
                }
                if (!privilege.equalsIgnoreCase("Self")) continue;
                prvlg |= 0x20L;
            }
        }
        return prvlg;
    }
}

