/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaUtil;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class RBSObject
implements Serializable {
    protected ObjectEntry oe = null;
    protected AdminNamespace ns = null;
    protected NSObject nsObj = null;
    protected String objectClassName = null;
    protected boolean isNVDS = false;

    public RBSObject(ObjectEntry objectOE) {
        this.oe = objectOE;
        this.objectClassName = this.oe.getObjectType().getName();
        this.ns = this.oe.getAdminNamespace();
        try {
            this.isNVDS = this.ns.isSupported("NVDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RBSObject(NSObject obj) {
        this.nsObj = obj;
        this.oe = this.nsObj.getObjectEntry();
        this.objectClassName = this.oe.getObjectType().getName();
        this.ns = this.oe.getAdminNamespace();
        try {
            this.isNVDS = this.ns.isSupported("NVDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setNSObject(NSObject newObj) {
        this.nsObj = newObj;
    }

    public void verifyNSObject() throws SPIException {
        if (this.nsObj == null) {
            this.nsObj = this.ns.getDetails(this.oe);
        }
    }

    public NSObject getNSObject() throws SPIException {
        if (this.nsObj == null) {
            this.nsObj = this.ns.getDetails(this.oe);
        }
        return this.nsObj;
    }

    public void update() throws SPIException, SnapinVetoException, NamespaceException {
        this.ns.update(this.nsObj);
    }

    public ObjectEntry getObjectEntry() {
        return this.oe;
    }

    public String getDescription() throws SPIException, NamespaceException {
        this.verifyNSObject();
        String[] values = NSModel.getStrings(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Description"));
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public void setDescription(String description) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (description == null || description.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Description"), null);
        } else {
            NSModel.setStrings(this.oe, this.nsObj, SchemaUtil.translateNDAPAttr((ObjectEntry)this.oe, (String)"Description"), new String[]{description});
        }
    }

    public Document getrbsXMLInfo() throws SPIException, JDOMException, IOException {
        this.verifyNSObject();
        Document doc = null;
        String[] values = NSModel.getStrings(this.oe, this.nsObj, "rbsXMLInfo");
        if (values != null) {
            SAXBuilder saxBuilder = new SAXBuilder(false);
            doc = saxBuilder.build((Reader)new StringReader(values[0]));
        }
        return doc;
    }

    public void setrbsXMLInfo(Document doc) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException, IOException {
        this.verifyNSObject();
        if (doc == null) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsXMLInfo", null);
        } else {
            XMLOutputter xmlOutputter = new XMLOutputter();
            String docString = xmlOutputter.outputString(doc);
            if (docString.length() == 0) {
                NSModel.setStrings(this.oe, this.nsObj, "rbsXMLInfo", null);
            } else {
                NSModel.setStrings(this.oe, this.nsObj, "rbsXMLInfo", new String[]{docString});
            }
        }
    }

    public Element getrbsXMLInfo(String elementTag) throws SPIException, JDOMException, IOException {
        this.verifyNSObject();
        Element element = null;
        String[] values = NSModel.getStrings(this.oe, this.nsObj, "rbsXMLInfo");
        if (values != null) {
            SAXBuilder saxBuilder = new SAXBuilder(false);
            Document doc = null;
            try {
                doc = saxBuilder.build((Reader)new StringReader(values[0]));
            }
            catch (JDOMException jDom) {
                return null;
            }
            Element el = doc.getRootElement().getChild(elementTag);
            if (el != null) {
                element = (Element)el.clone();
            }
        }
        return element;
    }

    public void setrbsXMLInfo(Element newElement) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException, IOException, JDOMException {
        this.verifyNSObject();
        Document doc = null;
        String[] values = NSModel.getStrings(this.oe, this.nsObj, "rbsXMLInfo");
        if (values != null) {
            String elementName;
            SAXBuilder saxBuilder = new SAXBuilder(false);
            doc = saxBuilder.build((Reader)new StringReader(values[0]));
            Element rootElement = doc.getRootElement();
            Element oldElement = rootElement.getChild(elementName = newElement.getName());
            if (oldElement != null) {
                rootElement.removeContent(oldElement);
            }
            if (newElement != null) {
                rootElement.addContent(newElement);
            }
        } else if (newElement != null) {
            doc = new Document(new Element("rbs-xml-info"));
            doc.getRootElement().addContent(newElement);
        }
        if (doc != null) {
            XMLOutputter xmlOutputter = new XMLOutputter();
            String docString = xmlOutputter.outputString(doc);
            NSModel.setStrings(this.oe, this.nsObj, "rbsXMLInfo", new String[]{docString});
        }
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }
}

