/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.rbs.RBSLDAPSchemaVerifier;
import com.novell.rbs.RBSNDSSchemaVerifier;
import java.beans.PropertyVetoException;

public class RBSSchemaVerifier {
    boolean isLDAP = false;
    RBSNDSSchemaVerifier ndsVerifier = null;
    RBSLDAPSchemaVerifier ldapVerifier = null;

    public RBSSchemaVerifier(ObjectEntry treeOE) throws NamespaceException, SPIException {
        this.isLDAP = treeOE.getNamespace().getUniqueID().equalsIgnoreCase("LDAP");
        if (this.isLDAP) {
            this.ldapVerifier = new RBSLDAPSchemaVerifier(treeOE);
        } else {
            this.ndsVerifier = new RBSNDSSchemaVerifier(treeOE);
        }
    }

    public boolean isSchemaValid() throws NamespaceException {
        if (this.isLDAP) {
            return this.ldapVerifier.isSchemaValid();
        }
        return this.ndsVerifier.isSchemaValid();
    }

    public void extendSchema() throws PropertyVetoException, NamespaceException, SPIException {
        if (this.isLDAP) {
            this.ldapVerifier.extendSchema();
        } else {
            this.ndsVerifier.extendSchema();
        }
    }
}

