/*
 * Decompiled with CFR 0.152.
 */
package com.novell.rbs;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.rbs.NSModel;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RBSTask
extends RBSObject {
    protected Hashtable otherNSObjectsTable = new Hashtable(20);

    public RBSTask(ObjectEntry objectOE) {
        super(objectOE);
    }

    public RBSTask(NSObject obj) {
        super(obj);
    }

    public RBSRole[] getContentMembership() throws SPIException {
        this.verifyNSObject();
        Object[] content = null;
        Vector<RBSRole> v = new Vector<RBSRole>(10);
        Enumeration myenum = NSModel.getAttribute(this.oe, this.nsObj, "rbsContentMembership");
        ObjectEntry currentOE = null;
        RBSRole rbsRole = null;
        if (myenum != null) {
            while (myenum.hasMoreElements()) {
                TypedNameFacade facade = (TypedNameFacade)((ValueList)myenum.nextElement()).createFacade();
                currentOE = this.ns.getObjectEntry(this.oe.getRoot(), facade.getObject());
                rbsRole = new RBSRole(currentOE);
                v.addElement(rbsRole);
            }
            content = new RBSRole[v.size()];
            v.copyInto(content);
        }
        return content;
    }

    public void setContentMembership(RBSRole[] content, String dynamicGroupSearchType) throws SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, RBSException, JDOMException, IOException {
        this.verifyNSObject();
        if (content == null) {
            this.deleteContentMembership(this.getContentMembership(), dynamicGroupSearchType);
        } else {
            this.deleteContentMembership(this.getContentMembership(), dynamicGroupSearchType);
            this.addContentMembership(content, dynamicGroupSearchType);
        }
    }

    public void addContentMembership(RBSRole[] content, String dynamicGroupSearchType) throws SPIException, SnapinVetoException, NamespaceException, ComponentCreationException, RBSException, JDOMException, IOException {
        if (content == null) {
            return;
        }
        this.verifyNSObject();
        NSObject contentObj = null;
        ObjectEntry contentOE = null;
        for (int i = 0; i < content.length; ++i) {
            contentOE = content[i].getObjectEntry();
            String contentName = this.ns.getUnrootedName(contentOE);
            contentObj = (NSObject)this.otherNSObjectsTable.get(contentName);
            if (contentObj == null) {
                contentObj = this.ns.getDetails(contentOE);
                this.otherNSObjectsTable.put(contentName, contentObj);
            }
            NSModel.makeTypedNameRelation(this.nsObj, contentObj, "rbsContentMembership", "rbsContent", 0L, 0L, 0L, 0L);
            RBSRole rbsRole = new RBSRole(contentObj);
            RBSAssociation[] assc = rbsRole.getMembers();
            if (assc == null) continue;
            if (this instanceof RBSBook) {
                RBSUtil.addRightsForBook(rbsRole, this, this.otherNSObjectsTable, dynamicGroupSearchType);
                continue;
            }
            RBSUtil.addRightsForTask(rbsRole, this, this.otherNSObjectsTable, dynamicGroupSearchType);
        }
    }

    public void deleteContentMembership(RBSRole[] content, String dynamicGroupSearchType) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException, RBSException, JDOMException, IOException {
        if (content == null) {
            return;
        }
        this.verifyNSObject();
        NSObject contentObj = null;
        ObjectEntry contentOE = null;
        for (int i = 0; i < content.length; ++i) {
            contentOE = content[i].getObjectEntry();
            String contentName = this.ns.getUnrootedName(contentOE);
            contentObj = (NSObject)this.otherNSObjectsTable.get(contentName);
            if (contentObj == null) {
                contentObj = this.ns.getDetails(contentOE);
                this.otherNSObjectsTable.put(contentName, contentObj);
            }
            NSModel.removeTypedNameRelation(this.nsObj, contentObj, "rbsContentMembership", "rbsContent", 0L, 0L, 0L, 0L);
            RBSRole rbsRole = new RBSRole(contentObj);
            RBSAssociation[] assc = rbsRole.getMembers();
            if (assc == null) continue;
            if (this instanceof RBSBook) {
                RBSUtil.removeRightsForBook(rbsRole, this, this.otherNSObjectsTable, dynamicGroupSearchType);
                continue;
            }
            RBSUtil.removeRightsForTask(rbsRole, this, this.otherNSObjectsTable, dynamicGroupSearchType);
        }
    }

    public RBSRights[] getRights() throws SPIException {
        this.verifyNSObject();
        RBSRights[] rights = null;
        Enumeration myenum = NSModel.getAttribute(this.oe, this.nsObj, "rbsTaskRights");
        if (myenum != null) {
            Vector<RBSRights> rightsVector = new Vector<RBSRights>();
            while (myenum.hasMoreElements()) {
                int startIndex = 0;
                int currentIndex = 0;
                byte[] bytes = ((HexValue)myenum.nextElement()).getValue();
                String str = new String(bytes);
                String objectClass = null;
                long priv = 0L;
                currentIndex = str.indexOf(";");
                String attr = str.substring(startIndex, currentIndex);
                startIndex = currentIndex;
                if ((currentIndex = str.indexOf(";", currentIndex + 1)) == -1) {
                    priv = new Long(str.substring(startIndex + 1, str.length()));
                } else {
                    priv = new Long(str.substring(startIndex + 1, currentIndex));
                    startIndex = currentIndex;
                    objectClass = str.substring(startIndex + 1, str.length());
                }
                RBSRights rbsRights = null;
                rbsRights = this.isNVDS ? new RBSNVDSRights("", null, null, objectClass, attr, 0L, priv) : new RBSRights("", attr, priv);
                rightsVector.addElement(rbsRights);
            }
            if (this.isNVDS) {
                rights = new RBSNVDSRights[rightsVector.size()];
                rightsVector.copyInto(rights);
            } else {
                rights = new RBSRights[rightsVector.size()];
                rightsVector.copyInto(rights);
            }
        }
        return rights;
    }

    public void setRights(RBSRights[] rights) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (rights == null) {
            this.deleteRights(this.getRights());
        } else {
            this.deleteRights(this.getRights());
            this.addRights(rights);
        }
    }

    public void addRights(RBSRights[] rights) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (rights == null || rights.length == 0) {
            NSModel.setValueComponents(this.oe, this.nsObj, "rbsTaskRights", null);
        } else {
            ValueComponent[] vc = new ValueComponent[rights.length];
            for (int i = 0; i < rights.length; ++i) {
                String objectClass;
                String data = this.isNVDS ? ((objectClass = ((RBSNVDSRights)rights[i]).getClassName()) != null ? new String(rights[i].getProtectedAttrName() + ";" + rights[i].getPrivileges() + ";" + objectClass) : new String(rights[i].getProtectedAttrName() + ";" + rights[i].getPrivileges())) : new String(rights[i].getProtectedAttrName() + ";" + rights[i].getPrivileges());
                Syntax syntax = this.ns.getAttributeDefinition(this.oe, "rbsTaskRights").getSyntax();
                vc[i] = syntax.createValueComponent((Object)data.getBytes());
            }
            NSModel.setValueComponents(this.oe, this.nsObj, "rbsTaskRights", vc);
        }
    }

    public void deleteRights(RBSRights[] rights) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (rights == null || rights.length == 0) {
            NSModel.setValueComponents(this.oe, this.nsObj, "rbsTaskRights", null);
        } else {
            ValueComponent[] vc = new ValueComponent[rights.length];
            for (int i = 0; i < rights.length; ++i) {
                String objectClass;
                String data = this.isNVDS ? ((objectClass = ((RBSNVDSRights)rights[i]).getClassName()) != null ? new String(rights[i].getProtectedAttrName() + ";" + rights[i].getPrivileges() + ";" + objectClass) : new String(rights[i].getProtectedAttrName() + ";" + rights[i].getPrivileges())) : new String(rights[i].getProtectedAttrName() + ";" + rights[i].getPrivileges());
                Syntax syntax = this.ns.getAttributeDefinition(this.oe, "rbsTaskRights").getSyntax();
                vc[i] = syntax.createValueComponent((Object)data.getBytes());
            }
            NSModel.deleteValueComponents(this.oe, this.nsObj, "rbsTaskRights", vc);
        }
    }

    public String getEntryPoint() throws NamespaceException, SPIException, ComponentCreationException {
        this.verifyNSObject();
        String[] strings = NSModel.getStrings(this.oe, this.nsObj, "rbsEntryPoint");
        if (strings != null) {
            return strings[0];
        }
        return null;
    }

    public void setEntryPoint(String point) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (point == null || point.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsEntryPoint", null);
        } else {
            NSModel.setStrings(this.oe, this.nsObj, "rbsEntryPoint", new String[]{point});
        }
    }

    public String getParameters() throws SPIException {
        this.verifyNSObject();
        String[] strings = NSModel.getStrings(this.oe, this.nsObj, "rbsParameters");
        if (strings != null) {
            return strings[0];
        }
        return null;
    }

    public void setParameters(String parameters) throws NamespaceException, SPIException, SnapinVetoException, ComponentCreationException {
        this.verifyNSObject();
        if (parameters == null || parameters.length() == 0) {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", null);
        } else {
            NSModel.setStrings(this.oe, this.nsObj, "rbsParameters", new String[]{parameters});
        }
    }

    public RBSModule getModule() {
        return new RBSModule(this.oe.getParent());
    }

    public void update() throws SPIException, SnapinVetoException, NamespaceException {
        super.update();
        Enumeration myenum = this.otherNSObjectsTable.elements();
        while (myenum.hasMoreElements()) {
            NSObject memberObj = (NSObject)myenum.nextElement();
            this.ns.update(memberObj);
        }
    }

    public boolean hasSecondaryRights() {
        boolean flag = false;
        try {
            Element secondaryRightsElement;
            Element iManagerElement = this.getrbsXMLInfo("imanager");
            if (iManagerElement != null && !iManagerElement.getChildren().isEmpty() && (secondaryRightsElement = iManagerElement.getChild("secondary-rights")) != null && !secondaryRightsElement.getChildren().isEmpty()) {
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }
}

