/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class AddReplicaRequest
implements ExtendedRequest {
    private int flag;
    private int replicaType;
    private String partitionDN;
    private String serverDN;

    public AddReplicaRequest() {
    }

    public AddReplicaRequest(String partitionDN, String serverDN, int replicaType, int flag) {
        this.partitionDN = partitionDN;
        this.serverDN = serverDN;
        this.replicaType = replicaType;
        this.flag = flag;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.8")) {
            throw new NamingException("AddReplica request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeInt(this.flag);
            ber.encodeInt(this.replicaType);
            ber.encodeString(this.serverDN, true);
            ber.encodeString(this.partitionDN, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public int getFlag() {
        return this.flag;
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.7";
    }

    public String getPartitionDN() {
        return this.partitionDN;
    }

    public int getReplicaType() {
        return this.replicaType;
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setPartitionDN(String partitionDN) {
        this.partitionDN = partitionDN;
    }

    public void setReplicaType(int replicaType) {
        this.replicaType = replicaType;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }
}

