/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.GetEffectiveRightsResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class GetEffectiveRightsRequest
implements ExtendedRequest {
    private String entryDN;
    private String trusteeDN;
    private String attrName;

    public GetEffectiveRightsRequest() {
    }

    public GetEffectiveRightsRequest(String entryDN, String trusteeDN, String attrName) {
        this.entryDN = entryDN;
        this.trusteeDN = trusteeDN;
        this.attrName = attrName;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.34")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new GetEffectiveRightsResponse(id, berValue, offset, length, this.attrName);
    }

    public String getAttrName() {
        return this.attrName;
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.entryDN, true);
            ber.encodeString(this.trusteeDN, true);
            ber.encodeString(this.attrName, true);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error: " + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.33";
    }

    public String getTrusteeDN() {
        return this.trusteeDN;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public void setEntryDN(String entryDN) {
        this.entryDN = entryDN;
    }

    public void setTrusteeDN(String trusteeDN) {
        this.trusteeDN = trusteeDN;
    }
}

