/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.Vector;
import javax.naming.NamingException;

public class GetReplicationFilterResponse
extends LDAPExtendedResponse {
    private Vector filters = new Vector(1, 1);

    GetReplicationFilterResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        super(id, berValue, offset, length);
    }

    private byte[] decodeOctetString(BerDecoder ber, int[] rlen) throws IOException {
        byte[] octets = new byte[rlen[0]];
        int i = 0;
        while (i < rlen[0]) {
            octets[i] = (byte)ber.parseByte();
            ++i;
        }
        return octets;
    }

    public Vector getFilters() throws IOException {
        int preTag = 0;
        int[] rlen = new int[1];
        boolean isClass = true;
        BerDecoder ber = this.getBerValue();
        try {
            int tag = ber.peekByte();
            if ((tag & 0x20) != 0) {
                tag = ber.parseSeq(rlen);
                int i = 0;
                while (ber.bytesLeft() > 0) {
                    byte[] content;
                    tag = ber.parseSeq(rlen);
                    if (tag == 4 && preTag == 48 && isClass) {
                        content = this.decodeOctetString(ber, rlen);
                        this.filters.addElement("Class: " + new String(content, 0, rlen[0]));
                        isClass = false;
                    } else if (tag == 4) {
                        content = this.decodeOctetString(ber, rlen);
                        this.filters.addElement("    Attribute: " + new String(content, 0, rlen[0]));
                        isClass = true;
                    }
                    preTag = tag;
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("BerDecoder error: " + ioe.toString());
        }
        return this.filters;
    }
}

