/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.Vector;
import javax.naming.NamingException;

public class ListReplicasResponse
extends LDAPExtendedResponse {
    private Vector replicas = new Vector(1, 1);

    ListReplicasResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        super(id, berValue, offset, length);
    }

    private byte[] decodeOctetString(BerDecoder ber, int[] rlen) throws IOException {
        byte[] octets = new byte[rlen[0]];
        int i = 0;
        while (i < rlen[0]) {
            octets[i] = (byte)ber.parseByte();
            ++i;
        }
        return octets;
    }

    public Vector getReplicas() throws IOException {
        int[] rlen = new int[1];
        BerDecoder ber = this.getBerValue();
        try {
            int tag = ber.peekByte();
            if ((tag & 0x20) != 0) {
                tag = ber.parseSeq(rlen);
                while (ber.bytesLeft() > 0) {
                    tag = ber.parseSeq(rlen);
                    if (tag != 4) continue;
                    byte[] content = this.decodeOctetString(ber, rlen);
                    if (rlen[0] == 0) continue;
                    this.replicas.addElement(new String(content, 0, rlen[0]));
                }
            }
        }
        catch (IOException ioe) {
            throw new IOException("BerDecoder error: " + ioe.toString());
        }
        return this.replicas;
    }
}

